/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net;

import com.sun.deploy.net.BasicHttpResponse;
import com.sun.deploy.net.HttpResponse;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.URLUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class HttpUtils {
    private static final String CONNECTION_HEADER = "Connection";
    public static final String LOCATION_HEADER = "Location";
    private static final String CONNECTION_KEEP_ALIVE = "Keep-Alive";
    private static final String PROTOCOL_VERSION_1_1 = "HTTP/1.1";

    public static HttpURLConnection followRedirects(URLConnection uRLConnection) throws IOException {
        boolean bl;
        int n = 0;
        InputStream inputStream = null;
        do {
            HttpURLConnection httpURLConnection;
            int n2;
            if (uRLConnection instanceof HttpURLConnection) {
                ((HttpURLConnection)uRLConnection).setInstanceFollowRedirects(false);
            }
            inputStream = uRLConnection.getInputStream();
            bl = false;
            if (!(uRLConnection instanceof HttpURLConnection) || !HttpUtils.isRedirect(n2 = (httpURLConnection = (HttpURLConnection)uRLConnection).getResponseCode())) continue;
            URL uRL = httpURLConnection.getURL();
            String string = httpURLConnection.getHeaderField(LOCATION_HEADER);
            URL uRL2 = null;
            if (string != null) {
                uRL2 = new URL(uRL, string);
            }
            HttpUtils.cleanupConnection(httpURLConnection);
            if (uRL2 == null || !uRL.getProtocol().equals(uRL2.getProtocol()) || n >= 5) {
                throw new SecurityException("illegal URL redirect");
            }
            bl = true;
            uRLConnection = uRL2.openConnection();
            ++n;
        } while (bl);
        if (!(uRLConnection instanceof HttpURLConnection)) {
            throw new IOException(uRLConnection.getURL() + " redirected to non-http URL");
        }
        return (HttpURLConnection)uRLConnection;
    }

    public static URL removeQueryStringFromURL(URL uRL) {
        String string;
        int n;
        URL uRL2 = uRL;
        if (uRL2 != null && (n = (string = uRL2.toString()).lastIndexOf(63)) != -1) {
            try {
                uRL2 = new URL(string.substring(0, n));
            }
            catch (MalformedURLException malformedURLException) {
                Trace.ignoredException(malformedURLException);
            }
        }
        return uRL2;
    }

    public static URL removeVersionQueriesFromURL(URL uRL) {
        String string;
        int n;
        if (uRL != null && (n = (string = uRL.toString()).lastIndexOf(63)) > -1) {
            StringBuffer stringBuffer = new StringBuffer(string.substring(0, n + 1));
            String[] stringArray = string.substring(n + 1).split("&");
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String[] stringArray2 = string2.split("=");
                if (stringArray2.length > 0 && ("version-id".equals(stringArray2[0]) || "current-version-id".equals(stringArray2[0]))) continue;
                if (bl) {
                    stringBuffer.append('&');
                } else {
                    bl = true;
                }
                stringBuffer.append(string2);
            }
            try {
                return new URL(stringBuffer.toString());
            }
            catch (MalformedURLException malformedURLException) {
                Trace.ignoredException(malformedURLException);
            }
        }
        return uRL;
    }

    public static boolean sameURLsIgnoreVersionQueries(URL uRL, URL uRL2) {
        uRL = HttpUtils.removeVersionQueriesFromURL(uRL);
        uRL2 = HttpUtils.removeVersionQueriesFromURL(uRL2);
        return URLUtil.sameURLs(uRL, uRL2);
    }

    public static void cleanupConnection(URLConnection uRLConnection) {
        if (uRLConnection == null || !(uRLConnection instanceof HttpURLConnection)) {
            return;
        }
        try {
            InputStream inputStream;
            int n;
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            String string = httpURLConnection.getHeaderField(null);
            String string2 = httpURLConnection.getHeaderField(CONNECTION_HEADER);
            if ((string2 != null && string2.equalsIgnoreCase(CONNECTION_KEEP_ALIVE) || string != null && string.startsWith(PROTOCOL_VERSION_1_1) && string2 == null) && (n = httpURLConnection.getResponseCode()) < 400 && (inputStream = httpURLConnection.getInputStream()) != null) {
                byte[] byArray = new byte[8192];
                while (inputStream.read(byArray) > 0) {
                }
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean isRedirect(int n) {
        return n >= 300 && n <= 305 && n != 304;
    }

    public static URL getFinalRedirectedURL(HttpResponse httpResponse) {
        if (httpResponse instanceof BasicHttpResponse) {
            return ((BasicHttpResponse)httpResponse).getFinalURL();
        }
        return null;
    }
}

