/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.proxy;

import com.sun.deploy.config.Platform;
import com.sun.deploy.net.proxy.BrowserProxyConfig;
import com.sun.deploy.net.proxy.BrowserProxyInfo;
import com.sun.deploy.net.proxy.ProxyUtils;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.WinRegistry;
import java.util.ArrayList;
import java.util.Locale;
import java.util.StringTokenizer;

public final class WIExplorerProxyConfig
implements BrowserProxyConfig {
    private static final String REGSTR_PATH_INTERNET_SETTINGS = "Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings";
    private static final String REGSTR_PATH_AUTOPROXY_DETECT = "Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\Connections";
    private static final String REGSTR_VAL_PROXYENABLE = "ProxyEnable";
    private static final String REGSTR_VAL_PROXYSERVER = "ProxyServer";
    private static final String REGSTR_VAL_PROXYOVERRIDE = "ProxyOverride";
    private static final String REGSTR_VAL_AUTOCONFIGURL = "AutoConfigURL";
    private static final String DEFAULT_CONNECTION_SETTINGS = "DefaultConnectionSettings";

    private native String performAutoDetection();

    public BrowserProxyInfo getBrowserProxyInfo() {
        Trace.msgNetPrintln("net.proxy.loading.ie");
        BrowserProxyInfo browserProxyInfo = new BrowserProxyInfo();
        browserProxyInfo.setType(0);
        ProxyInfo proxyInfo = this.getBrowserProxySettings();
        if (proxyInfo != null) {
            switch (proxyInfo.getProxyType()) {
                case 1: {
                    browserProxyInfo.setType(0);
                    break;
                }
                case 3: {
                    Object object;
                    browserProxyInfo.setType(1);
                    if (proxyInfo.getProxy() != null) {
                        object = proxyInfo.getProxy().replace(' ', ';');
                        ProxyUtils.parseProxyServer((String)object, browserProxyInfo);
                    }
                    if (proxyInfo.getProxyBypass() == null) break;
                    object = new StringTokenizer(proxyInfo.getProxyBypass(), " ;");
                    ArrayList<String> arrayList = new ArrayList<String>();
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        String string = ((StringTokenizer)object).nextToken().toLowerCase(Locale.ENGLISH).trim();
                        if (string == null || string.length() <= 0) continue;
                        arrayList.add(string);
                    }
                    browserProxyInfo.setOverrides(arrayList);
                    break;
                }
                default: {
                    browserProxyInfo.setType(0);
                }
            }
        }
        if (this.isAutoDetectEnabled()) {
            browserProxyInfo.setAutoProxyDetectionEnabled(true);
            browserProxyInfo.setAutoConfigURL(this.performAutoDetection());
        }
        if (browserProxyInfo.getAutoConfigURL() == null) {
            browserProxyInfo.setAutoConfigURL(this.getAutoConfigURL());
        }
        if (browserProxyInfo.getAutoConfigURL() != null) {
            Trace.msgNetPrintln("net.proxy.browser.autoConfigURL", new Object[]{browserProxyInfo.getAutoConfigURL()});
            browserProxyInfo.setType(2);
        }
        Trace.msgNetPrintln("net.proxy.loading.done");
        return browserProxyInfo;
    }

    public String getAutoConfigURL() {
        String string = null;
        string = WinRegistry.getString(-2147483647, REGSTR_PATH_INTERNET_SETTINGS, REGSTR_VAL_AUTOCONFIGURL);
        return string;
    }

    public boolean isAutoDetectEnabled() {
        boolean bl = false;
        byte[] byArray = (byte[])WinRegistry.get(-2147483647, REGSTR_PATH_AUTOPROXY_DETECT, DEFAULT_CONNECTION_SETTINGS);
        if (byArray != null && (byArray[8] & 8) != 0) {
            bl = true;
        }
        return bl;
    }

    public void getSystemProxy(BrowserProxyInfo browserProxyInfo) {
    }

    private native ProxyInfo getBrowserProxySettings();

    static {
        Platform.get().loadDeployNativeLib();
    }

    static class ProxyInfo {
        private int proxyType;
        private String proxy;
        private String proxyBypass;

        public ProxyInfo(int n, String string, String string2) {
            this.proxyType = n;
            this.proxy = string;
            this.proxyBypass = string2;
        }

        public int getProxyType() {
            return this.proxyType;
        }

        public String getProxy() {
            return this.proxy;
        }

        public String getProxyBypass() {
            return this.proxyBypass;
        }
    }
}

