/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.util;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.util.DeploySysAction;
import com.sun.deploy.util.DeploySysRun;
import com.sun.deploy.util.DeployUIManager;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.security.AccessController;
import javax.swing.JDialog;
import sun.security.action.GetPropertyAction;

public final class PluginSysUtil
extends DeploySysRun {
    private static ThreadGroup pluginThreadGroup = null;
    private static ClassLoader pluginSysClassLoader = null;
    private static final SysExecutionThreadCreator sysExecutionThreadCreator = new SysExecutionThreadCreator();

    public static synchronized ThreadGroup getPluginThreadGroup() {
        if (pluginThreadGroup == null) {
            pluginSysClassLoader = Thread.currentThread().getContextClassLoader();
            pluginThreadGroup = new ThreadGroup(Thread.currentThread().getThreadGroup(), "Plugin Thread Group");
            PluginSysUtil.createAppContext(pluginThreadGroup);
            try {
                Thread thread = new Thread(pluginThreadGroup, new Runnable(){

                    public void run() {
                        DeployUIManager.setLookAndFeel();
                    }
                });
                thread.start();
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return pluginThreadGroup;
    }

    public static Thread createPluginSysThread(Runnable runnable) {
        Thread thread = new Thread(pluginThreadGroup, runnable);
        thread.setContextClassLoader(pluginSysClassLoader);
        return thread;
    }

    public static Thread createPluginSysThread(Runnable runnable, String string) {
        Thread thread = new Thread(pluginThreadGroup, runnable, string);
        thread.setContextClassLoader(pluginSysClassLoader);
        return thread;
    }

    public Object delegate(DeploySysAction deploySysAction) throws Exception {
        return PluginSysUtil.execute(deploySysAction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object execute(DeploySysAction deploySysAction) throws Exception {
        if (pluginThreadGroup == null) {
            Trace.println((String)"ERROR:  pluginThreadGroup should not be null!");
            return null;
        }
        if (pluginThreadGroup.equals(Thread.currentThread().getThreadGroup())) {
            return deploySysAction.execute();
        }
        final SysExecutionThread sysExecutionThread = sysExecutionThreadCreator.createThread(deploySysAction);
        sysExecutionThread.setContextClassLoader(pluginSysClassLoader);
        if (EventQueue.isDispatchThread()) {
            Object object = sysExecutionThread.syncObject;
            synchronized (object) {
                block15: {
                    DummyDialog dummyDialog;
                    sysExecutionThread.theDummy = dummyDialog = new DummyDialog(null, true);
                    dummyDialog.addWindowListener(new WindowAdapter(){

                        public void windowOpened(WindowEvent windowEvent) {
                            sysExecutionThread.start();
                        }

                        public void windowClosing(WindowEvent windowEvent) {
                            dummyDialog.setVisible(false);
                        }
                    });
                    Rectangle rectangle = new Rectangle(new Point(0, 0), Toolkit.getDefaultToolkit().getScreenSize());
                    if (!PluginSysUtil.isOnWindows()) {
                        dummyDialog.setLocation(rectangle.x + rectangle.width / 2 - 50, rectangle.y + rectangle.height / 2);
                    } else {
                        dummyDialog.setLocation(-100, -100);
                    }
                    dummyDialog.setResizable(false);
                    dummyDialog.toBack();
                    dummyDialog.setVisible(true);
                    try {
                        try {
                            sysExecutionThread.syncObject.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            Object var7_7 = null;
                            dummyDialog.setVisible(false);
                            break block15;
                        }
                        Object var7_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_8 = null;
                        dummyDialog.setVisible(false);
                        throw throwable;
                    }
                    dummyDialog.setVisible(false);
                }
            }
        } else {
            sysExecutionThread.start();
            try {
                sysExecutionThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (sysExecutionThread.exception != null) {
            throw sysExecutionThread.exception;
        }
        return sysExecutionThread.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createAppContext(ThreadGroup threadGroup) {
        AppContextCreatorThread appContextCreatorThread = new AppContextCreatorThread(threadGroup);
        Object object = appContextCreatorThread.synObject;
        synchronized (object) {
            appContextCreatorThread.start();
            try {
                appContextCreatorThread.synObject.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static boolean isOnWindows() {
        String string = AccessController.doPrivileged(new GetPropertyAction("os.name"));
        return string.indexOf("Windows") != -1;
    }

    static {
        sysExecutionThreadCreator.start();
    }

    private static class AppContextCreatorThread
    extends Thread {
        Object synObject = new Object();

        public AppContextCreatorThread(ThreadGroup threadGroup) {
            super(threadGroup, "AppContext Creator Thread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = this.synObject;
            synchronized (object) {
                ToolkitStore.get().createAppContext();
                this.synObject.notifyAll();
            }
        }
    }

    private static class DummyDialog
    extends JDialog {
        private ThreadGroup _unsecureGroup = Thread.currentThread().getThreadGroup();

        DummyDialog(Frame frame, boolean bl) {
            super(frame, bl);
        }

        public void secureHide() {
            new Thread(this._unsecureGroup, new Runnable(){

                public void run() {
                    DummyDialog.this.setVisible(false);
                }
            }).start();
        }
    }

    static class SysExecutionThread
    extends Thread {
        Exception exception = null;
        Object result = null;
        DeploySysAction action = null;
        Object syncObject = new Object();
        DummyDialog theDummy = null;

        public SysExecutionThread(DeploySysAction deploySysAction) {
            super(pluginThreadGroup, "SysExecutionThead");
            this.action = deploySysAction;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Object object;
            try {
                try {
                    this.result = this.action.execute();
                }
                catch (Exception exception) {
                    this.exception = exception;
                    Object var3_2 = null;
                    if (this.theDummy != null) {
                        this.theDummy.secureHide();
                    }
                    Object object3 = this.syncObject;
                    synchronized (object3) {
                        this.syncObject.notifyAll();
                        return;
                    }
                }
                Object var3_1 = null;
                if (this.theDummy != null) {
                    this.theDummy.secureHide();
                }
                object = this.syncObject;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (this.theDummy != null) {
                    this.theDummy.secureHide();
                }
                Object object2 = this.syncObject;
                synchronized (object2) {
                    this.syncObject.notifyAll();
                    throw throwable;
                }
            }
            synchronized (object) {
                this.syncObject.notifyAll();
                return;
            }
        }
    }

    static class SysExecutionThreadCreator
    extends Thread {
        private DeploySysAction deploySysAction = null;
        private SysExecutionThread sysExecutionThread = null;

        SysExecutionThreadCreator() {
            super("SysExecutionTheadCreator");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SysExecutionThread createThread(DeploySysAction deploySysAction) {
            SysExecutionThreadCreator sysExecutionThreadCreator = this;
            synchronized (sysExecutionThreadCreator) {
                this.deploySysAction = deploySysAction;
                this.notifyAll();
                while (this.sysExecutionThread == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Trace.ignoredException((Exception)interruptedException);
                    }
                }
                SysExecutionThread sysExecutionThread = this.sysExecutionThread;
                this.sysExecutionThread = null;
                return sysExecutionThread;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                SysExecutionThreadCreator sysExecutionThreadCreator = this;
                synchronized (sysExecutionThreadCreator) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Trace.ignoredException((Exception)interruptedException);
                    }
                    if (this.deploySysAction != null) {
                        this.sysExecutionThread = new SysExecutionThread(this.deploySysAction);
                        this.notifyAll();
                        this.deploySysAction = null;
                    }
                }
            }
        }
    }
}

