/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.discovery;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.ModClassLoader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.discovery.ContainerType;
import cpw.mods.fml.common.discovery.ModCandidate;
import cpw.mods.fml.relauncher.CoreModManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ModDiscoverer {
    private static Pattern zipJar = Pattern.compile("(.+).(zip|jar)$");
    private List<ModCandidate> candidates = Lists.newArrayList();
    private ASMDataTable dataTable = new ASMDataTable();
    private List<File> nonModLibs = Lists.newArrayList();

    public void findClasspathMods(ModClassLoader modClassLoader) {
        ImmutableList knownLibraries = ImmutableList.builder().addAll(modClassLoader.getDefaultLibraries()).addAll(CoreModManager.getLibraries()).build();
        File[] minecraftSources = modClassLoader.getParentSources();
        if (minecraftSources.length == 1 && minecraftSources[0].isFile()) {
            FMLLog.fine("Minecraft is a file at %s, loading", minecraftSources[0].getAbsolutePath());
            this.candidates.add(new ModCandidate(minecraftSources[0], minecraftSources[0], ContainerType.JAR, true, true));
        } else {
            for (int i = 0; i < minecraftSources.length; ++i) {
                if (minecraftSources[i].isFile()) {
                    if (knownLibraries.contains(minecraftSources[i].getName())) {
                        FMLLog.finer("Skipping known library file %s", minecraftSources[i].getAbsolutePath());
                        continue;
                    }
                    FMLLog.fine("Found a minecraft related file at %s, examining for mod candidates", minecraftSources[i].getAbsolutePath());
                    this.candidates.add(new ModCandidate(minecraftSources[i], minecraftSources[i], ContainerType.JAR, i == 0, true));
                    continue;
                }
                if (!minecraftSources[i].isDirectory()) continue;
                FMLLog.fine("Found a minecraft related directory at %s, examining for mod candidates", minecraftSources[i].getAbsolutePath());
                this.candidates.add(new ModCandidate(minecraftSources[i], minecraftSources[i], ContainerType.DIR, i == 0, true));
            }
        }
    }

    public void findModDirMods(File modsDir) {
        Object[] modList = modsDir.listFiles();
        Arrays.sort(modList);
        for (Object modFile : modList) {
            if (((File)modFile).isDirectory()) {
                FMLLog.fine("Found a candidate mod directory %s", ((File)modFile).getName());
                this.candidates.add(new ModCandidate((File)modFile, (File)modFile, ContainerType.DIR));
                continue;
            }
            Matcher matcher = zipJar.matcher(((File)modFile).getName());
            if (matcher.matches()) {
                FMLLog.fine("Found a candidate zip or jar file %s", matcher.group(0));
                this.candidates.add(new ModCandidate((File)modFile, (File)modFile, ContainerType.JAR));
                continue;
            }
            FMLLog.fine("Ignoring unknown file %s in mods directory", ((File)modFile).getName());
        }
    }

    public List<ModContainer> identifyMods() {
        ArrayList modList = Lists.newArrayList();
        for (ModCandidate candidate : this.candidates) {
            try {
                List<ModContainer> mods = candidate.explore(this.dataTable);
                if (mods.isEmpty() && !candidate.isClasspath()) {
                    this.nonModLibs.add(candidate.getModContainer());
                    continue;
                }
                modList.addAll(mods);
            }
            catch (LoaderException le) {
                FMLLog.log(Level.WARNING, le, "Identified a problem with the mod candidate %s, ignoring this source", candidate.getModContainer());
            }
            catch (Throwable t2) {
                Throwables.propagate((Throwable)t2);
            }
        }
        return modList;
    }

    public ASMDataTable getASMTable() {
        return this.dataTable;
    }

    public List<File> getNonModLibs() {
        return this.nonModLibs;
    }
}

