/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.launcher;

import com.google.common.base.Throwables;
import com.google.common.collect.ObjectArrays;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.LaunchClassLoader;

public class FMLTweaker
implements ITweaker {
    private List<String> args;
    private File gameDir;
    private File assetsDir;
    private String profile;
    private static URI jarLocation;
    private String[] array;

    public void acceptOptions(List<String> args, File gameDir, File assetsDir, String profile) {
        this.args = args;
        this.gameDir = gameDir == null ? new File(".") : gameDir;
        this.assetsDir = assetsDir;
        this.profile = profile;
        try {
            jarLocation = this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI();
        }
        catch (URISyntaxException e) {
            Logger.getLogger("FMLTWEAK").log(Level.SEVERE, "Missing URI information for FML tweak");
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void injectIntoClassLoader(LaunchClassLoader classLoader) {
        classLoader.addTransformerExclusion("cpw.mods.fml.repackage.");
        classLoader.addTransformerExclusion("cpw.mods.fml.relauncher.");
        classLoader.addTransformerExclusion("cpw.mods.fml.common.asm.transformers.");
        classLoader.addClassLoaderExclusion("LZMA.");
        FMLLaunchHandler.configureForClientLaunch(classLoader, this);
    }

    public String getLaunchTarget() {
        return "net.minecraft.client.main.Main";
    }

    public String[] getLaunchArguments() {
        Object[] array = this.args.toArray(new String[this.args.size()]);
        if (this.gameDir != null) {
            array = (String[])ObjectArrays.concat((Object)this.gameDir.getAbsolutePath(), (Object[])array);
            array = (String[])ObjectArrays.concat((Object)"--gameDir", (Object[])array);
        }
        if (this.assetsDir != null) {
            array = (String[])ObjectArrays.concat((Object)this.assetsDir.getAbsolutePath(), (Object[])array);
            array = (String[])ObjectArrays.concat((Object)"--assetsDir", (Object[])array);
        }
        if (this.profile != null) {
            array = (String[])ObjectArrays.concat((Object)this.profile, (Object[])array);
            array = (String[])ObjectArrays.concat((Object)"--version", (Object[])array);
        } else {
            array = (String[])ObjectArrays.concat((Object)"UnknownFMLProfile", (Object[])array);
            array = (String[])ObjectArrays.concat((Object)"--version", (Object[])array);
        }
        return array;
    }

    public File getGameDir() {
        return this.gameDir;
    }

    public static URI getJarLocation() {
        return jarLocation;
    }
}

