/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.network;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.network.FMLNetworkHandler;
import cpw.mods.fml.common.network.FMLPacket;
import cpw.mods.fml.common.network.IChatListener;
import cpw.mods.fml.common.network.IConnectionHandler;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.NetworkModHandler;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import net.minecraft.server.MinecraftServer;

public class NetworkRegistry {
    private static final NetworkRegistry INSTANCE = new NetworkRegistry();
    private Multimap<Player, String> activeChannels = ArrayListMultimap.create();
    private Multimap<String, IPacketHandler> universalPacketHandlers = ArrayListMultimap.create();
    private Multimap<String, IPacketHandler> clientPacketHandlers = ArrayListMultimap.create();
    private Multimap<String, IPacketHandler> serverPacketHandlers = ArrayListMultimap.create();
    private Set<IConnectionHandler> connectionHandlers = Sets.newLinkedHashSet();
    private Map<ModContainer, IGuiHandler> serverGuiHandlers = Maps.newHashMap();
    private Map<ModContainer, IGuiHandler> clientGuiHandlers = Maps.newHashMap();
    private List<IChatListener> chatListeners = Lists.newArrayList();

    public static NetworkRegistry instance() {
        return INSTANCE;
    }

    byte[] getPacketRegistry(Side side) {
        return Joiner.on((char)'\u0000').join(Iterables.concat(Arrays.asList("FML"), (Iterable)this.universalPacketHandlers.keySet(), (Iterable)(side.isClient() ? this.clientPacketHandlers.keySet() : this.serverPacketHandlers.keySet()))).getBytes(Charsets.UTF_8);
    }

    public boolean isChannelActive(String channel, Player player) {
        return this.activeChannels.containsEntry((Object)player, (Object)channel);
    }

    public void registerChannel(IPacketHandler handler, String channelName) {
        if (Strings.isNullOrEmpty((String)channelName) || channelName != null && channelName.length() > 16) {
            FMLLog.severe("Invalid channel name '%s' : %s", channelName, Strings.isNullOrEmpty((String)channelName) ? "Channel name is empty" : "Channel name is too long (16 chars is maximum)");
            throw new RuntimeException("Channel name is invalid");
        }
        this.universalPacketHandlers.put((Object)channelName, (Object)handler);
    }

    public void registerChannel(IPacketHandler handler, String channelName, Side side) {
        if (side == null) {
            this.registerChannel(handler, channelName);
            return;
        }
        if (Strings.isNullOrEmpty((String)channelName) || channelName != null && channelName.length() > 16) {
            FMLLog.severe("Invalid channel name '%s' : %s", channelName, Strings.isNullOrEmpty((String)channelName) ? "Channel name is empty" : "Channel name is too long (16 chars is maximum)");
            throw new RuntimeException("Channel name is invalid");
        }
        if (side.isClient()) {
            this.clientPacketHandlers.put((Object)channelName, (Object)handler);
        } else {
            this.serverPacketHandlers.put((Object)channelName, (Object)handler);
        }
    }

    void activateChannel(Player player, String channel) {
        this.activeChannels.put((Object)player, (Object)channel);
    }

    void deactivateChannel(Player player, String channel) {
        this.activeChannels.remove((Object)player, (Object)channel);
    }

    public void registerConnectionHandler(IConnectionHandler handler) {
        this.connectionHandlers.add(handler);
    }

    public void registerChatListener(IChatListener listener) {
        this.chatListeners.add(listener);
    }

    void playerLoggedIn(js player, jx netHandler, cl manager) {
        this.generateChannelRegistration((ua)player, (ey)netHandler, manager);
        for (IConnectionHandler handler : this.connectionHandlers) {
            handler.playerLoggedIn((Player)player, (ey)netHandler, manager);
        }
    }

    String connectionReceived(jv netHandler, cl manager) {
        for (IConnectionHandler handler : this.connectionHandlers) {
            String kick = handler.connectionReceived(netHandler, manager);
            if (Strings.isNullOrEmpty((String)kick)) continue;
            return kick;
        }
        return null;
    }

    void connectionOpened(ey netClientHandler, String server, int port, cl networkManager) {
        for (IConnectionHandler handler : this.connectionHandlers) {
            handler.connectionOpened(netClientHandler, server, port, networkManager);
        }
    }

    void connectionOpened(ey netClientHandler, MinecraftServer server, cl networkManager) {
        for (IConnectionHandler handler : this.connectionHandlers) {
            handler.connectionOpened(netClientHandler, server, networkManager);
        }
    }

    void clientLoggedIn(ey clientHandler, cl manager, eo login) {
        this.generateChannelRegistration(clientHandler.getPlayer(), clientHandler, manager);
        for (IConnectionHandler handler : this.connectionHandlers) {
            handler.clientLoggedIn(clientHandler, manager, login);
        }
    }

    void connectionClosed(cl manager, ua player) {
        for (IConnectionHandler handler : this.connectionHandlers) {
            handler.connectionClosed(manager);
        }
        this.activeChannels.removeAll((Object)player);
    }

    void generateChannelRegistration(ua player, ey netHandler, cl manager) {
        dz pkt = new dz();
        pkt.a = "REGISTER";
        pkt.c = this.getPacketRegistry(player instanceof js ? Side.SERVER : Side.CLIENT);
        pkt.b = pkt.c.length;
        manager.a((ex)pkt);
    }

    void handleCustomPacket(dz packet, cl network, ey handler) {
        if ("REGISTER".equals(packet.a)) {
            this.handleRegistrationPacket(packet, (Player)handler.getPlayer());
        } else if ("UNREGISTER".equals(packet.a)) {
            this.handleUnregistrationPacket(packet, (Player)handler.getPlayer());
        } else {
            this.handlePacket(packet, network, (Player)handler.getPlayer());
        }
    }

    private void handlePacket(dz packet, cl network, Player player) {
        String channel = packet.a;
        for (IPacketHandler handler : Iterables.concat((Iterable)this.universalPacketHandlers.get((Object)channel), (Iterable)(player instanceof js ? this.serverPacketHandlers.get((Object)channel) : this.clientPacketHandlers.get((Object)channel)))) {
            handler.onPacketData(network, packet, player);
        }
    }

    private void handleRegistrationPacket(dz packet, Player player) {
        List<String> channels = this.extractChannelList(packet);
        for (String channel : channels) {
            this.activateChannel(player, channel);
        }
    }

    private void handleUnregistrationPacket(dz packet, Player player) {
        List<String> channels = this.extractChannelList(packet);
        for (String channel : channels) {
            this.deactivateChannel(player, channel);
        }
    }

    private List<String> extractChannelList(dz packet) {
        String request = new String(packet.c, Charsets.UTF_8);
        ArrayList channels = Lists.newArrayList((Iterable)Splitter.on((char)'\u0000').split((CharSequence)request));
        return channels;
    }

    public void registerGuiHandler(Object mod, IGuiHandler handler) {
        NetworkModHandler nmh;
        ModContainer mc = FMLCommonHandler.instance().findContainerFor(mod);
        if (mc == null) {
            mc = Loader.instance().activeModContainer();
            FMLLog.log(Level.WARNING, "Mod %s attempted to register a gui network handler during a construction phase", mc.getModId());
        }
        if ((nmh = FMLNetworkHandler.instance().findNetworkModHandler(mc)) == null) {
            FMLLog.log(Level.FINE, "The mod %s needs to be a @NetworkMod to register a Networked Gui Handler", mc.getModId());
        } else {
            this.serverGuiHandlers.put(mc, handler);
        }
        this.clientGuiHandlers.put(mc, handler);
    }

    void openRemoteGui(ModContainer mc, js player, int modGuiId, abr world, int x2, int y, int z) {
        ut container;
        IGuiHandler handler = this.serverGuiHandlers.get(mc);
        NetworkModHandler nmh = FMLNetworkHandler.instance().findNetworkModHandler(mc);
        if (handler != null && nmh != null && (container = (ut)handler.getServerGuiElement(modGuiId, (ua)player, world, x2, y, z)) != null) {
            player.bJ();
            player.k();
            int windowId = player.bX;
            dz pkt = new dz();
            pkt.a = "FML";
            pkt.c = FMLPacket.makePacket(FMLPacket.Type.GUIOPEN, windowId, nmh.getNetworkId(), modGuiId, x2, y, z);
            pkt.b = pkt.c.length;
            player.a.b((ex)pkt);
            player.bp = container;
            player.bp.d = windowId;
            player.bp.a((vd)player);
        }
    }

    void openLocalGui(ModContainer mc, ua player, int modGuiId, abr world, int x2, int y, int z) {
        IGuiHandler handler = this.clientGuiHandlers.get(mc);
        FMLCommonHandler.instance().showGuiScreen(handler.getClientGuiElement(modGuiId, player, world, x2, y, z));
    }

    public dl handleChat(ey handler, dl chat) {
        Side s = Side.CLIENT;
        if (handler instanceof jx) {
            s = Side.SERVER;
        }
        for (IChatListener listener : this.chatListeners) {
            chat = s.isClient() ? listener.clientChat(handler, chat) : listener.serverChat(handler, chat);
        }
        return chat;
    }

    public void handleTinyPacket(ey handler, dq mapData) {
        NetworkModHandler nmh = FMLNetworkHandler.instance().findNetworkModHandler(mapData.a);
        if (nmh == null) {
            FMLLog.info("Received a tiny packet for network id %d that is not recognised here", mapData.a);
            return;
        }
        if (nmh.hasTinyPacketHandler()) {
            nmh.getTinyPacketHandler().handle(handler, mapData);
        } else {
            FMLLog.info("Received a tiny packet for a network mod that does not accept tiny packets %s", nmh.getContainer().getModId());
        }
    }
}

