/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import java.util.ArrayList;
import java.util.EnumSet;

public class BiomeDictionary {
    private static final int BIOME_LIST_SIZE = 256;
    private static BiomeInfo[] biomeList = new BiomeInfo[256];
    private static ArrayList<acl>[] typeInfoList = new ArrayList[Type.values().length];

    public static boolean registerBiomeType(acl biome, Type ... types) {
        if (acl.a[biome.N] != null) {
            for (Type type : types) {
                if (typeInfoList[type.ordinal()] == null) {
                    BiomeDictionary.typeInfoList[type.ordinal()] = new ArrayList();
                }
                typeInfoList[type.ordinal()].add(biome);
            }
            if (biomeList[biome.N] == null) {
                BiomeDictionary.biomeList[biome.N] = new BiomeInfo(types);
            } else {
                for (Type type : types) {
                    BiomeDictionary.biomeList[biome.N].typeList.add(type);
                }
            }
            return true;
        }
        return false;
    }

    public static acl[] getBiomesForType(Type type) {
        if (typeInfoList[type.ordinal()] != null) {
            return typeInfoList[type.ordinal()].toArray(new acl[0]);
        }
        return new acl[0];
    }

    public static Type[] getTypesForBiome(acl biome) {
        BiomeDictionary.checkRegistration(biome);
        if (biomeList[biome.N] != null) {
            return BiomeDictionary.biomeList[biome.N].typeList.toArray(new Type[0]);
        }
        return new Type[0];
    }

    public static boolean areBiomesEquivalent(acl biomeA, acl biomeB) {
        int a2 = biomeA.N;
        int b2 = biomeB.N;
        BiomeDictionary.checkRegistration(biomeA);
        BiomeDictionary.checkRegistration(biomeB);
        if (biomeList[a2] != null && biomeList[b2] != null) {
            for (Type type : BiomeDictionary.biomeList[a2].typeList) {
                if (!BiomeDictionary.containsType(biomeList[b2], type)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isBiomeOfType(acl biome, Type type) {
        BiomeDictionary.checkRegistration(biome);
        if (biomeList[biome.N] != null) {
            return BiomeDictionary.containsType(biomeList[biome.N], type);
        }
        return false;
    }

    public static boolean isBiomeRegistered(acl biome) {
        return biomeList[biome.N] != null;
    }

    public static boolean isBiomeRegistered(int biomeID) {
        return biomeList[biomeID] != null;
    }

    public static void registerAllBiomes() {
        for (int i = 0; i < 256; ++i) {
            if (acl.a[i] == null) continue;
            BiomeDictionary.checkRegistration(acl.a[i]);
        }
    }

    public static void makeBestGuess(acl biome) {
        if (biome.I.z >= 3) {
            if (biome.e() && biome.F >= 1.0f) {
                BiomeDictionary.registerBiomeType(biome, Type.JUNGLE);
            } else if (!biome.e()) {
                BiomeDictionary.registerBiomeType(biome, Type.FOREST);
            }
        } else if (biome.E <= 0.3f && biome.E >= 0.0f && (!biome.e() || biome.D >= 0.0f)) {
            BiomeDictionary.registerBiomeType(biome, Type.PLAINS);
        }
        if (biome.e() && biome.D < 0.0f && biome.E <= 0.3f && biome.E >= 0.0f) {
            BiomeDictionary.registerBiomeType(biome, Type.SWAMP);
        }
        if (biome.D <= -0.5f) {
            BiomeDictionary.registerBiomeType(biome, Type.WATER);
        }
        if (biome.E >= 1.5f) {
            BiomeDictionary.registerBiomeType(biome, Type.MOUNTAIN);
        }
        if (biome.c() || biome.F < 0.2f) {
            BiomeDictionary.registerBiomeType(biome, Type.FROZEN);
        }
        if (!biome.e() && biome.F >= 1.0f) {
            BiomeDictionary.registerBiomeType(biome, Type.DESERT);
        }
    }

    private static void checkRegistration(acl biome) {
        if (!BiomeDictionary.isBiomeRegistered(biome)) {
            BiomeDictionary.makeBestGuess(biome);
        }
    }

    private static boolean containsType(BiomeInfo info, Type type) {
        return info.typeList.contains((Object)type);
    }

    private static void registerVanillaBiomes() {
        BiomeDictionary.registerBiomeType(acl.b, Type.WATER);
        BiomeDictionary.registerBiomeType(acl.c, Type.PLAINS);
        BiomeDictionary.registerBiomeType(acl.d, Type.DESERT);
        BiomeDictionary.registerBiomeType(acl.e, Type.MOUNTAIN);
        BiomeDictionary.registerBiomeType(acl.f, Type.FOREST);
        BiomeDictionary.registerBiomeType(acl.g, Type.FOREST, Type.FROZEN);
        BiomeDictionary.registerBiomeType(acl.u, Type.FOREST, Type.FROZEN);
        BiomeDictionary.registerBiomeType(acl.h, Type.SWAMP);
        BiomeDictionary.registerBiomeType(acl.i, Type.WATER);
        BiomeDictionary.registerBiomeType(acl.l, Type.WATER, Type.FROZEN);
        BiomeDictionary.registerBiomeType(acl.m, Type.WATER, Type.FROZEN);
        BiomeDictionary.registerBiomeType(acl.n, Type.FROZEN);
        BiomeDictionary.registerBiomeType(acl.o, Type.FROZEN);
        BiomeDictionary.registerBiomeType(acl.r, Type.BEACH);
        BiomeDictionary.registerBiomeType(acl.s, Type.DESERT);
        BiomeDictionary.registerBiomeType(acl.w, Type.JUNGLE);
        BiomeDictionary.registerBiomeType(acl.x, Type.JUNGLE);
        BiomeDictionary.registerBiomeType(acl.t, Type.FOREST);
        BiomeDictionary.registerBiomeType(acl.k, Type.END);
        BiomeDictionary.registerBiomeType(acl.j, Type.NETHER);
        BiomeDictionary.registerBiomeType(acl.p, Type.MUSHROOM);
        BiomeDictionary.registerBiomeType(acl.v, Type.MOUNTAIN);
        BiomeDictionary.registerBiomeType(acl.q, Type.MUSHROOM, Type.BEACH);
    }

    static {
        BiomeDictionary.registerVanillaBiomes();
    }

    private static class BiomeInfo {
        public EnumSet<Type> typeList = EnumSet.noneOf(Type.class);

        public BiomeInfo(Type[] types) {
            for (Type t2 : types) {
                this.typeList.add(t2);
            }
        }
    }

    public static enum Type {
        FOREST,
        PLAINS,
        MOUNTAIN,
        HILLS,
        SWAMP,
        WATER,
        DESERT,
        FROZEN,
        JUNGLE,
        WASTELAND,
        BEACH,
        NETHER,
        END,
        MUSHROOM,
        MAGICAL;

    }
}

