/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;

public class ForgeHooks {
    static final List<GrassEntry> grassList = new ArrayList<GrassEntry>();
    static final List<SeedEntry> seedList = new ArrayList<SeedEntry>();
    private static boolean toolInit = false;
    static HashMap<xx, List> toolClasses = new HashMap();
    static HashMap<List, Integer> toolHarvestLevels = new HashMap();
    static HashSet<List> toolEffectiveness = new HashSet();

    public static void plantGrass(abr world, int x2, int y, int z) {
        GrassEntry grass = (GrassEntry)mf.a((Random)world.s, grassList);
        if (grass == null || grass.block == null || !grass.block.f(world, x2, y, z)) {
            return;
        }
        world.f(x2, y, z, grass.block.cF, grass.metadata, 3);
    }

    public static xz getGrassSeed(abr world) {
        SeedEntry entry = (SeedEntry)mf.a((Random)world.s, seedList);
        if (entry == null || entry.seed == null) {
            return null;
        }
        return entry.seed.m();
    }

    public static boolean canHarvestBlock(aqs block, ua player, int metadata) {
        if (block.cU.l()) {
            return true;
        }
        xz stack = player.bn.h();
        if (stack == null) {
            return player.a(block);
        }
        List info = toolClasses.get(stack.b());
        if (info == null) {
            return player.a(block);
        }
        Object[] tmp = info.toArray();
        String toolClass = (String)tmp[0];
        int harvestLevel = (Integer)tmp[1];
        Integer blockHarvestLevel = toolHarvestLevels.get(Arrays.asList(block, metadata, toolClass));
        if (blockHarvestLevel == null) {
            return player.a(block);
        }
        return blockHarvestLevel <= harvestLevel;
    }

    public static boolean canToolHarvestBlock(aqs block, int metadata, xz stack) {
        if (stack == null) {
            return false;
        }
        List info = toolClasses.get(stack.b());
        if (info == null) {
            return false;
        }
        Object[] tmp = info.toArray();
        String toolClass = (String)tmp[0];
        int harvestLevel = (Integer)tmp[1];
        Integer blockHarvestLevel = toolHarvestLevels.get(Arrays.asList(block, metadata, toolClass));
        return blockHarvestLevel != null && blockHarvestLevel <= harvestLevel;
    }

    public static float blockStrength(aqs block, ua player, abr world, int x2, int y, int z) {
        int metadata = world.h(x2, y, z);
        float hardness = block.l(world, x2, y, z);
        if (hardness < 0.0f) {
            return 0.0f;
        }
        if (!ForgeHooks.canHarvestBlock(block, player, metadata)) {
            float speed = ForgeEventFactory.getBreakSpeed(player, block, metadata, 1.0f);
            return (speed < 0.0f ? 0.0f : speed) / hardness / 100.0f;
        }
        return player.getCurrentPlayerStrVsBlock(block, false, metadata) / hardness / 30.0f;
    }

    public static boolean isToolEffective(xz stack, aqs block, int metadata) {
        List toolClass = toolClasses.get(stack.b());
        return toolClass != null && toolEffectiveness.contains(Arrays.asList(block, metadata, toolClass.get(0)));
    }

    static void initTools() {
        if (toolInit) {
            return;
        }
        toolInit = true;
        MinecraftForge.setToolClass(xx.v, "pickaxe", 0);
        MinecraftForge.setToolClass(xx.z, "pickaxe", 1);
        MinecraftForge.setToolClass(xx.i, "pickaxe", 2);
        MinecraftForge.setToolClass(xx.K, "pickaxe", 0);
        MinecraftForge.setToolClass(xx.D, "pickaxe", 3);
        MinecraftForge.setToolClass(xx.w, "axe", 0);
        MinecraftForge.setToolClass(xx.A, "axe", 1);
        MinecraftForge.setToolClass(xx.j, "axe", 2);
        MinecraftForge.setToolClass(xx.L, "axe", 0);
        MinecraftForge.setToolClass(xx.E, "axe", 3);
        MinecraftForge.setToolClass(xx.u, "shovel", 0);
        MinecraftForge.setToolClass(xx.y, "shovel", 1);
        MinecraftForge.setToolClass(xx.h, "shovel", 2);
        MinecraftForge.setToolClass(xx.J, "shovel", 0);
        MinecraftForge.setToolClass(xx.C, "shovel", 3);
        for (aqs block : yi.c) {
            MinecraftForge.setBlockHarvestLevel(block, "pickaxe", 0);
        }
        for (aqs block : yt.c) {
            MinecraftForge.setBlockHarvestLevel(block, "shovel", 0);
        }
        for (aqs block : xv.c) {
            MinecraftForge.setBlockHarvestLevel(block, "axe", 0);
        }
        MinecraftForge.setBlockHarvestLevel(aqs.au, "pickaxe", 3);
        MinecraftForge.setBlockHarvestLevel(aqs.bW, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(aqs.aB, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(aqs.aC, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(aqs.L, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(aqs.am, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(aqs.M, "pickaxe", 1);
        MinecraftForge.setBlockHarvestLevel(aqs.an, "pickaxe", 1);
        MinecraftForge.setBlockHarvestLevel(aqs.S, "pickaxe", 1);
        MinecraftForge.setBlockHarvestLevel(aqs.T, "pickaxe", 1);
        MinecraftForge.setBlockHarvestLevel(aqs.aS, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(aqs.aT, "pickaxe", 2);
        MinecraftForge.removeBlockEffectiveness(aqs.aS, "pickaxe");
        MinecraftForge.removeBlockEffectiveness(aqs.au, "pickaxe");
        MinecraftForge.removeBlockEffectiveness(aqs.aT, "pickaxe");
    }

    public static int getTotalArmorValue(ua player) {
        int ret = 0;
        for (int x2 = 0; x2 < player.bn.b.length; ++x2) {
            xz stack = player.bn.b[x2];
            if (stack != null && stack.b() instanceof ISpecialArmor) {
                ret += ((ISpecialArmor)stack.b()).getArmorDisplay(player, stack, x2);
                continue;
            }
            if (stack == null || !(stack.b() instanceof wc)) continue;
            ret += ((wc)stack.b()).c;
        }
        return ret;
    }

    public static boolean onPickBlock(ast target, ua player, abr world) {
        int x2;
        xz result = null;
        boolean isCreative = player.bG.d;
        if (target.a == asu.a) {
            x2 = target.b;
            int y = target.c;
            int z = target.d;
            aqs var8 = aqs.s[world.a(x2, y, z)];
            if (var8 == null) {
                return false;
            }
            result = var8.getPickBlock(target, world, x2, y, z);
        } else {
            if (target.a != asu.b || target.g == null || !isCreative) {
                return false;
            }
            result = target.g.getPickedResult(target);
        }
        if (result == null) {
            return false;
        }
        for (x2 = 0; x2 < 9; ++x2) {
            xz stack = player.bn.a(x2);
            if (stack == null || !stack.a(result) || !xz.a((xz)stack, (xz)result)) continue;
            player.bn.c = x2;
            return true;
        }
        if (!isCreative) {
            return false;
        }
        int slot = player.bn.j();
        if (slot < 0 || slot >= 9) {
            slot = player.bn.c;
        }
        player.bn.a(slot, result);
        player.bn.c = slot;
        return true;
    }

    public static void onLivingSetAttackTarget(oc entity, oc target) {
        MinecraftForge.EVENT_BUS.post(new LivingSetAttackTargetEvent(entity, target));
    }

    public static boolean onLivingUpdate(oc entity) {
        return MinecraftForge.EVENT_BUS.post(new LivingEvent.LivingUpdateEvent(entity));
    }

    public static boolean onLivingAttack(oc entity, my src, float amount) {
        return MinecraftForge.EVENT_BUS.post(new LivingAttackEvent(entity, src, amount));
    }

    public static float onLivingHurt(oc entity, my src, float amount) {
        LivingHurtEvent event = new LivingHurtEvent(entity, src, amount);
        return MinecraftForge.EVENT_BUS.post(event) ? 0.0f : event.ammount;
    }

    public static boolean onLivingDeath(oc entity, my src) {
        return MinecraftForge.EVENT_BUS.post(new LivingDeathEvent(entity, src));
    }

    public static boolean onLivingDrops(oc entity, my source, ArrayList<sp> drops, int lootingLevel, boolean recentlyHit, int specialDropValue) {
        return MinecraftForge.EVENT_BUS.post(new LivingDropsEvent(entity, source, drops, lootingLevel, recentlyHit, specialDropValue));
    }

    public static float onLivingFall(oc entity, float distance) {
        LivingFallEvent event = new LivingFallEvent(entity, distance);
        return MinecraftForge.EVENT_BUS.post(event) ? 0.0f : event.distance;
    }

    public static boolean isLivingOnLadder(aqs block, abr world, int x2, int y, int z, oc entity) {
        return block != null && block.isLadder(world, x2, y, z, entity);
    }

    public static void onLivingJump(oc entity) {
        MinecraftForge.EVENT_BUS.post(new LivingEvent.LivingJumpEvent(entity));
    }

    public static sp onPlayerTossEvent(ua player, xz item) {
        player.captureDrops = true;
        sp ret = player.a(item, false);
        player.capturedDrops.clear();
        player.captureDrops = false;
        ItemTossEvent event = new ItemTossEvent(ret, player);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return null;
        }
        player.a(event.entityItem);
        return event.entityItem;
    }

    public static float getEnchantPower(abr world, int x2, int y, int z) {
        if (world.c(x2, y, z)) {
            return 0.0f;
        }
        aqs block = aqs.s[world.a(x2, y, z)];
        return block == null ? 0.0f : block.getEnchantPowerBonus(world, x2, y, z);
    }

    public static cu onServerChatEvent(jx net, String raw, cu comp) {
        ServerChatEvent event = new ServerChatEvent(net.c, raw, comp);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return null;
        }
        return event.component;
    }

    static {
        grassList.add(new GrassEntry((aqs)aqs.ai, 0, 20));
        grassList.add(new GrassEntry((aqs)aqs.aj, 0, 10));
        seedList.add(new SeedEntry(new xz(xx.U), 10));
        ForgeHooks.initTools();
    }

    static class SeedEntry
    extends mg {
        public final xz seed;

        public SeedEntry(xz seed, int weight) {
            super(weight);
            this.seed = seed;
        }
    }

    static class GrassEntry
    extends mg {
        public final aqs block;
        public final int metadata;

        public GrassEntry(aqs block, int meta, int weight) {
            super(weight);
            this.block = block;
            this.metadata = meta;
        }
    }
}

