/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launchwrapper;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.logging.Level;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraft.launchwrapper.LogWrapper;

public class Launch {
    private static final String DEFAULT_TWEAK = "net.minecraft.launchwrapper.VanillaTweaker";
    public static File minecraftHome;
    public static File assetsDir;
    private final LaunchClassLoader classLoader;

    public static void main(String[] args) {
        new Launch().launch(args);
    }

    private Launch() {
        URLClassLoader ucl = (URLClassLoader)this.getClass().getClassLoader();
        this.classLoader = new LaunchClassLoader(ucl.getURLs());
    }

    private void launch(String[] args) {
        OptionParser parser = new OptionParser();
        parser.allowsUnrecognizedOptions();
        ArgumentAcceptingOptionSpec profileOption = parser.accepts("version", "The version we launched with").withRequiredArg();
        ArgumentAcceptingOptionSpec gameDirOption = parser.accepts("gameDir", "Alternative game directory").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec assetsDirOption = parser.accepts("assetsDir", "Assets directory").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec tweakClassOption = parser.accepts("tweakClass", "Tweak class to load").withRequiredArg().defaultsTo((Object)DEFAULT_TWEAK, (Object[])new String[0]);
        NonOptionArgumentSpec nonOption = parser.nonOptions();
        OptionSet options = parser.parse(args);
        minecraftHome = (File)options.valueOf((OptionSpec)gameDirOption);
        assetsDir = (File)options.valueOf((OptionSpec)assetsDirOption);
        String profileName = (String)options.valueOf((OptionSpec)profileOption);
        String tweakClassName = (String)options.valueOf((OptionSpec)tweakClassOption);
        try {
            LogWrapper.log(Level.INFO, "Using tweak class name %s", tweakClassName);
            ITweaker tweaker = (ITweaker)Class.forName(tweakClassName, true, this.classLoader).newInstance();
            tweaker.acceptOptions(options.valuesOf((OptionSpec)nonOption), minecraftHome, assetsDir, profileName);
            tweaker.injectIntoClassLoader(this.classLoader);
            Class<?> clazz = Class.forName(tweaker.getLaunchTarget(), false, this.classLoader);
            Method mainMethod = clazz.getMethod("main", String[].class);
            LogWrapper.info("Launching wrapped minecraft", new Object[0]);
            mainMethod.invoke(null, new Object[]{tweaker.getLaunchArguments()});
        }
        catch (Exception e) {
            LogWrapper.log(Level.SEVERE, e, "Unable to launch", new Object[0]);
        }
    }
}

