achievements_window = achievements_window or {}
achievements_window.actions = achievements_window.actions or {}

achievements_window.params = 
{
	--    
	back_image = "achievements_achievements",
	--    
	back_image_completed = "achievements_achievements_completed",
		
	-- ,     
	chain_image = "achievements_chain",
	
	--   
	image_pos_center = sf.misc.FloatVector(85, 57),
		
	--   -  
	label_title_params = 
	{
		--   
		{
			font = "mpc_semibold_30_light_brown",
			color = sf.graphics.Color(255,255,255,255),
		},
		--   
		{
			font = "mpc_semibold_30_green",
			color = sf.graphics.Color(255,255,255,255),
		}
	},
	label_title_pos = sf.misc.FloatVector(158, 16),
	
	--   -  
	label_description_params = 
	{
		--   
		{
			font = "mpc_21_light_brown",
			color = sf.graphics.Color(255,255,255,255),
		},
		--   
		{
			font = "mpc_21_black",
			color = sf.graphics.Color(255,255,255,255),
		}
	},
	label_description_pos = sf.misc.FloatVector(158, 50),
	--      .      ,      
	label_description_width = 500,
	
	--   -  
	label_progress_params = 
	{
		--   
		{
			font = "mpc_21_brown",
			color = sf.graphics.Color(255,255,255,255),
		},
		--   
		{
			font = "mpc_21_brown",
			color = sf.graphics.Color(255,255,255,255),
		}
	},
	label_progress_pos = sf.misc.FloatVector(600, 25),
	
	--   -  
	label_score_params = 
	{
		--   
		{
			font = "na_gradient_44_grey",
			color = sf.graphics.Color(255,255,255,255),
		},
		--   
		{
			font = "na_gradient_44",
			color = sf.graphics.Color(255,255,255,255),
		}
	},
	label_score_pos = sf.misc.FloatVector(875, 33),
	
	--  -
	progress_image = "achievements_progress02",
	progress_frame_image = "achievements_progress02_frame",
	progress_pos = sf.misc.FloatVector(520, 25)
}

--       ,       achievements.xml.
--        .
if not achievements_window.params.achievements then
	local achs_info = sf.core.CSettings()

	local loaded = achs_info.LoadXml("properties\\achievements.xml")
	__assert(loaded, "    achievements.xml")
	
	local root = achs_info.GetFirstChild()
	__assert(root.GetId().c_str() == "Achievements", "   achievements.xml")

	achievements_window.params.achievements = {}
	
    local ach_settings = root.GetFirstChildRef()
	while ach_settings do
		__assert(ach_settings.GetId().c_str() == "ach", "   achievements.xml")
        __assert(ach_settings.IsValue("id"), "   achievements.xml")

		table.insert(achievements_window.params.achievements, ach_settings.GetValue("id").c_str())
		
		ach_settings = ach_settings.GetNextSiblingRef()
    end
end

function achievements_window.DoDraw(_this, _renderer)
	if game_background then
		game_background.Draw(_renderer)
	end
end

function achievements_window.DoUpdate(_this)
	if game_background then
		game_background.Update()
	end
end

function achievements_window.OnChar(_this, _char, _keyboard_state, _state, _broadcast)
    return _this.SuperOnChar(_char, _keyboard_state, _state, _broadcast)
end

function achievements_window.OnKeyDown(_this, _key, _keyboard_state, _state, _broadcast)
	return _this.SuperOnKeyDown( _key, _keyboard_state, _state, _broadcast)
end

function achievements_window.OnKeyUp(_this, _key, _keyboard_state, _state, _broadcast)
	return _this.SuperOnKeyUp( _key, _keyboard_state, _state, _broadcast)
end

function achievements_window.OnMouseMove(_this, _pos, _state, _broadcast)
	return _this.SuperOnMouseMove( _pos, _state, _broadcast) 
end

function achievements_window.OnMouseDown(_this, _pos, _button, _state, _broadcast)
	return _this.SuperOnMouseDown( _pos, _button, _state, _broadcast) 
end

function achievements_window.OnMouseUp(_this, _pos, _button, _state, _broadcast)
	return _this.SuperOnMouseUp( _pos, _button, _state, _broadcast) 
end

function achievements_window.OnDoubleClick(_this, _pos, _state, _broadcast)
	return _this.SuperOnDoubleClick( _pos, _state, _broadcast) 
end

function achievements_window.OnMouseWheel(_this, _pos, _delta, _state, _broadcast)
	return _this.SuperOnMouseWheel( _pos, _delta, _state, _broadcast)
end

function achievements_window.OnChildAction(_this, _action, _child)
	if not _child then return end
	local handler = achievements_window.actions[_child.GetId().c_str()]
	if handler then handler = handler[_action.c_str()] end
	if handler then handler(_this, _child) end
end
	
function achievements_window.Show(_window, _dont_show_recived)

	local dialog = sf.gui.CWindow()
	dialog.Load(g_App.GetSettings().GetChild("GUI", false).GetChildByAttribute("window", "id", "achievements_staticstics_window", true),
		g_App.GetSettings().GetChild("GUITemplates", false))
	
	achievements_window._InitWindow(dialog)
	achievements_window._parent = _window
	
	dialog.UpdateLayout()

	--      ,     (0, 0)
	local offset = sf.misc.FloatVector(0, 0)
	local parent = _window
	while parent do
		offset.X = offset.X - parent.GetOffset().X
		offset.Y = offset.Y - parent.GetOffset().Y
		parent = parent.GetParentWindow()
	end
	dialog.SetOffset(offset.X, offset.Y)
	
	if not _dont_show_recived then
		local tab_widget = get_child_widget(dialog, "achievements_tab_list", sf.gui.CTabWidget)
		if tab_widget then
			tab_widget.SelectPanel(1)
		end
	end
	--set_widget_flag_value(_window, sf.gui.CBaseWidget.FlagHidden, true)  
	
	s11.AddShowEffectToWidget(dialog, misc.hide_window_delay, misc.show_window_delay, misc.shift_before_hide, _window)
	
    _window.AddChildWindow(dialog)
end

--    ,      /   
-- _panel -   - scrollable_panel
-- _i -       .     .
-- _ach_id -  
function achievements_window._AddAchievementWidgets(_panel, _i, _ach_id)
	
	--       ,      
	local ach_settings = s11.g_Achievements.Instance().GetAchievementSettings(_ach_id)
	local ach_completed = achievements_window.achs.IsCompleted(_ach_id) ~= 0
	
	local label_param = 1
	if ach_completed then label_param = 2 end
	
	--  ,    
	local ach_chain = sf.gui.CImageWidget(achievements_window.params.chain_image, "", 0, 0)	
				
	--       ,    
	local back_image = achievements_window.params.back_image
	if ach_completed then
		back_image = achievements_window.params.back_image_completed
	end
	
	--   
	local ach_back = sf.gui.CImageWidget(back_image, "", 0, 0)	
		
	--   (y)  -    ,      
	--   (x)   0
	local top = (ach_back.GetSize().Y + ach_chain.GetSize().Y) * _i
	
	if _i > 0 then	
		--  ,    ,     
		ach_chain.SetOffset(0, top - ach_chain.GetSize().Y)
		local ach_chain_ptr = sf.gui.CImageWidgetPtrT(ach_chain)
		scrollable_panel.AddContentWidget(_panel, ach_chain_ptr, false)
	end
	
	--       
	ach_back.SetOffset(0, top)
	local ach_back_ptr = sf.gui.CImageWidgetPtrT(ach_back)
	scrollable_panel.AddContentWidget(_panel, ach_back_ptr, false)
	
	-- ,       
	local icon_image_id = ach_settings.Image
	if not ach_completed then
		icon_image_id = ach_settings.Image.."_uncompleted"
	end
	local ach_image = sf.gui.CImageWidget(icon_image_id, "", 0, 0)
	ach_image.SetOffset(
		achievements_window.params.image_pos_center.X - ach_image.GetSize().X / 2, 
		achievements_window.params.image_pos_center.Y - ach_image.GetSize().Y / 2 + top)
	local ach_image_ptr = sf.gui.CImageWidgetPtrT(ach_image)
	scrollable_panel.AddContentWidget(_panel, ach_image_ptr, false)
	
	-- ,       
	local ach_title = sf.gui.CLabelWidget(achievements_window.fonts_title[label_param], ach_settings.Title, "", 0, 0)
	ach_title.SetOffset(
		achievements_window.params.label_title_pos.X, 
		achievements_window.params.label_title_pos.Y + top)
	ach_title.SetColor(achievements_window.params.label_title_params[label_param].color)
	local ach_title_ptr = sf.gui.CLabelWidgetPtrT(ach_title)
	scrollable_panel.AddContentWidget(_panel, ach_title_ptr, false)
	
	-- ,       
	local ach_description = sf.gui.CLabelWidget(achievements_window.fonts_description[label_param], ach_settings.Description, "", 0, 0)
	ach_description.SetOffset(
		achievements_window.params.label_description_pos.X, 
		achievements_window.params.label_description_pos.Y + top)
	ach_description.SetColor(achievements_window.params.label_description_params[label_param].color)
	ach_description.SetWordBreak(true)
	ach_description.SetSize(achievements_window.params.label_description_width, 0)
	local ach_description_ptr = sf.gui.CLabelWidgetPtrT(ach_description)
	scrollable_panel.AddContentWidget(_panel, ach_description_ptr, false)
	
	-- ,         
	local ach_score = sf.gui.CLabelWidget(achievements_window.fonts_score[label_param], s11.StringFormat("%i", ach_settings.Score), "", 0, 0)
	ach_score.SetOffset(
		achievements_window.params.label_score_pos.X, 
		achievements_window.params.label_score_pos.Y + top)
	ach_score.SetColor(achievements_window.params.label_score_params[label_param].color)
	local ach_score_ptr = sf.gui.CLabelWidgetPtrT(ach_score)
	scrollable_panel.AddContentWidget(_panel, ach_score_ptr, false)
	
	--      ?
	if ach_settings.MaxProgress ~= 1 then
		
		--   
		local progress = achievements_window.achs.GetProgress(_ach_id)
		
		--  -
		local ach_progress_bar = sf.gui.CProgressBarWidget("", 0, 0)
		--   -
		local image_progress_frame = sf.graphics.CImage(achievements_window.params.progress_frame_image)
		--    -
		local image_progress = sf.graphics.CImage(achievements_window.params.progress_image)
		--    -
		ach_progress_bar.SetImages(image_progress_frame, image_progress)
		--    -       (    )
		ach_progress_bar.SetSize(image_progress.GetTextureSize().X, image_progress.GetTextureSize().Y)
		--  -:   /  
		ach_progress_bar.SetValue(progress / ach_settings.MaxProgress)
		--  -     
		ach_progress_bar.SetOffset(
			achievements_window.params.progress_pos.X, 
			achievements_window.params.progress_pos.Y + top)
		local ach_progress_bar_ptr = sf.gui.CProgressBarWidgetPtrT(ach_progress_bar)
		scrollable_panel.AddContentWidget(_panel, ach_progress_bar_ptr, false)
		
		-- ,         
		local ach_progress = sf.gui.CLabelWidget(achievements_window.fonts_progress[label_param], 
			s11.StringFormat("%i/%i", progress, ach_settings.MaxProgress), "", 0, 0)
		ach_progress.SetOffset(
			achievements_window.params.label_progress_pos.X, 
			achievements_window.params.label_progress_pos.Y + top)
		ach_progress.SetColor(achievements_window.params.label_progress_params[label_param].color)
		local ach_progress_ptr = sf.gui.CLabelWidgetPtrT(ach_progress)
		scrollable_panel.AddContentWidget(_panel, ach_progress_ptr, false)		
	end	
	
	scrollable_panel.UpdateSize(_panel)
end

--   
function achievements_window._InitWindow(_window)

	--  -  
	local current_score_label = get_child_widget(_window, "current_score", sf.gui.CLabelWidget)
	__assert(current_score_label, "   current_score")

	local tab_widget = get_child_widget(_window, "achievements_tab_list", sf.gui.CTabWidget)
	__assert(tab_widget, "   achievements_tab_list")

	--    -   3: ,   
	local panels_num = tab_widget.EnumPanels()
	__assert(panels_num == 3, "   achievements_tab_list   3")
	
	--    .
	--    -,    scrollable_panel
	local panels = 
	{
		tab_widget.GetPanelContent(0).GetWidget("panel", true).get(),
		tab_widget.GetPanelContent(1).GetWidget("panel", true).get(),
		tab_widget.GetPanelContent(2).GetWidget("panel", true).get()
	}
	
	local i = 0
	
	--      
	achievements_window.fonts_title = 
		{
			g_App.GetResourceManager().GetFont(achievements_window.params.label_title_params[1].font),
			g_App.GetResourceManager().GetFont(achievements_window.params.label_title_params[2].font)
		}
	achievements_window.fonts_description = 
		{
			g_App.GetResourceManager().GetFont(achievements_window.params.label_description_params[1].font),
			g_App.GetResourceManager().GetFont(achievements_window.params.label_description_params[2].font)
		}
	achievements_window.fonts_progress = 
		{
			g_App.GetResourceManager().GetFont(achievements_window.params.label_progress_params[1].font),
			g_App.GetResourceManager().GetFont(achievements_window.params.label_progress_params[2].font)
		}
	achievements_window.fonts_score = 
		{
			g_App.GetResourceManager().GetFont(achievements_window.params.label_score_params[1].font),
			g_App.GetResourceManager().GetFont(achievements_window.params.label_score_params[2].font)
		}
	
	--  
	local profile = s11.g_ProfileManager.Instance().GetCurrentProfile()
	__assert(profile)
		
	--     .
	--     2 :   ( 1,       )    
	--  , ..      ( 0,     )
	achievements_window.achs = s11.g_Achievements.Instance().GetProfileAchievements(profile)
	
	--         
	local current_score_text = 
		s11.StringFormat(current_score_label.GetText(), achievements_window.achs.GetScore())
	current_score_label.SetText(current_score_text)
	
	--    .  3 : ,   .
	-- "":     ,   ,        ,    
	--    achievements.xml
	-- "" -      ,     ()
	-- "" -      ,        achievements.xml
	
	-- achievements_window.params.achievements       ,        achievements.xml
	
	--     ,     ,          
	-- ,    ,       ,        achievements.xml.
	
	local achs = {}
	local sort_achs = {}
	
	--       achievements_window.params.achievements
	for i,a in ipairs(achievements_window.params.achievements) do
		table.insert(sort_achs, a)
		achs[a] = i
	end
	
	--  .
	--   . 
	--  true,       .
	--     ,  ,      achievements.xml  ,
	--   true,      .
	--      false
	-- _ach1 -   
	-- _ach2 -   
	local sort_func = 	
		function (_ach1, _ach2)
			--     (0,   )
			local completed1 = achievements_window.achs.IsCompleted(_ach1)
			--     (0,   )
			local completed2 = achievements_window.achs.IsCompleted(_ach2)
			
			--                   .
			if completed1 ~= completed2 then
				return completed1 > completed2
			end
			
			--    ,     .
			--  ,        achievements.xml.
			return achs[_ach1] < achs[_ach2]
		end 
		
	--  
	table.sort(sort_achs, sort_func)

	local i=0
	
	-- ,      
	local has_completed = achievements_window.achs.IsCompleted(sort_achs[1]) ~= 0
	
	--    ,         ""
	if has_completed then
		achievements_window._AddAchievementWidgets(panels[1], i, sort_achs[1])
		i = i + 1
	end
	
	--   "".
	--      ,       achievements.xml.
	--  ,    ( )
	for _,a in ipairs(achievements_window.params.achievements) do
		if not has_completed or a ~= sort_achs[1] then
			achievements_window._AddAchievementWidgets(panels[1], i, a)
			i = i + 1
		end
	end
	
	--   ""  ""
	--   sort_achs    ,  .       ,    
	--  ,      "".
	--     ,     ""        .
	local i = 0
	local p = 2 --   
	for _,a in ipairs(sort_achs) do
		if p == 2 then
			if achievements_window.achs.IsCompleted(a) == 0 then
				i = 0
				p = 3
			end
		end
		achievements_window._AddAchievementWidgets(panels[p], i, a)
		i = i + 1
	end
	
	if game_background then
		game_background.Init()
		game_background.SetUseClip(false)
	end
end

achievements_window.actions.close = 
{
	pressed = function(_window) 
		s11.AddHideEffectToWidget(_window, 300, 300, 300, achievements_window._parent)
	end
}

achievements = achievements or {}
achievements.statistics_window = achievements_window or {}