game_stat_window = game_stat_window or {}
game_stat_window.actions = game_stat_window.actions or {}
game_stat_window.object = nil

function game_stat_window.get_scores()
	return game_stat_window._scores
end

game_stat_window._res_images = {
	[0] = "screens_statistics_mask_green",
	[1] = "screens_statistics_mask_yellow",
	[2] = "screens_statistics_mask_blue"
}

game_stat_window._res_clips = {
	[0] = "mask_green_flight",
	[1] = "mask_yelow_flight",
	[2] = "mask_blue_flight"
}

--      
game_stat_window.effects_params = 
{
	default = 
	{
		delay = 0,
		duration = 300
	},
	items = 
	{
		{
			widgets = 
			{ 
				{ id = "label_score_text" }
			},
			particle = "StatLabelTextEffect"
		},
		{
			widgets = 
			{ 
				{ id = "score_label", counter = {max_value = game_stat_window.get_scores, str_format = "%i"} } 
			},
			delay = 100,
			particle = "StatLabelEffect"
		},
		
		{
			widgets = 
			{
				--[[{ id = "time_icon" },]]
				{ id = "time_label_text" }
			},
			delay = 70,
			particle = "StatLabelTextEffect"
		},
		
		{
			widgets = 
			{
				{ id = "mask_clip" }
				
			},
			delay = 0,
			particle = "StatLabelTextEffect03"
		},

		{
			widgets = 
			{
				{ id = "mask_image" }
				
			},
			particle = "StatLabelTextEffect03",
			duration = 0
		},
		
		{
			widgets = 
			{
				{ id = "time_label" }
			},
			delay = 70,
			particle = "StatLabelEffect"
		},
		
		{
			widgets = 
			{
				
				{id = "gold_label_text"}
			},
			particle = "StatLabelTextEffect"
		},
		
		{
			widgets = 
			{
				{id = "coin"},
				{ id = "gold_label" }
			},
			delay = 70,
			particle = "StatLabelTextGoldEffect"
		},
		
		{
			widgets = 
			{
				{ id = "best_combo_label_text" },
				{ id = "best_combo_label"}
			},
			delay = 300,
			particle = "StatLabelTextEffect02"
		},
		{
			widgets = 
			{
				{ id = "cup_destroy_label_text" },
				{ id = "cup_destroy_label" }
			},
			particle = "StatLabelTextEffect02"
		},

		{
			widgets = 
			{
				{ id = "used_bonus_label_text" },
				{ id = "used_bonus_label" }
			},
			particle = "StatLabelTextEffect02"
		},
		
		{
			widgets = 
			{
				{ id = "used_totems_label_text" },
				{ id = "used_totems_label" }
			},
			particle = "StatLabelTextEffect02"
		},
		
		{
			widgets = 
			{
				{ id = "achievements_button" }
			},
			delay = 600,
			particle = "StatLabelTextAchEffect",
			scale_koef = {X = 1, Y = 1}
		},
		
		{
			widgets = 
			{
				{ id = "replay_button" },
				{ id = "ok_button" }
			}
		}
	}
}

function game_stat_window.Show(_window)
	sf.core.g_Application.GetTimeManager().GetTimer("game_timer").SetK(1)
	local dialog = sf.gui.CWindow()
	dialog.Load(g_App.GetSettings().GetChild("GUI", false).GetChildByAttribute("window", "id", "game_stat_window", true),
		g_App.GetSettings().GetChild("GUITemplates", false))
	dialog.UpdateLayout()
	
	local profile_data = s11.g_ProfileManager.Instance().GetCurrentProfile().GetClassicData()
	
	local level_progrees = game_window.game_field.GetPrizeIndex()
	
	game_stat_window._mask_image = get_child_widget(dialog, "mask_image", sf.gui.CImageWidget, "" )
	game_stat_window._mask_image.SetImage(game_stat_window._res_images[level_progrees])
	
	game_stat_window._mask_clip = get_child_widget(dialog, "mask_clip", sf.gui.CClipWidget, "" )
	game_stat_window._mask_clip.GetClip().Load(game_stat_window._res_clips[level_progrees], true)
	
	game_stat_window.score_label = get_child_widget(dialog, "score_label", sf.gui.CLabelWidget, "" )
	game_stat_window.time_label = get_child_widget(dialog, "time_label", sf.gui.CLabelWidget, "" )
	game_stat_window.gold_label = get_child_widget(dialog, "gold_label", sf.gui.CLabelWidget, "" )
	
	game_stat_window.cup_destroy_label = get_child_widget(dialog, "cup_destroy_label", sf.gui.CLabelWidget, "" )
	game_stat_window.best_combo_label = get_child_widget(dialog, "best_combo_label", sf.gui.CLabelWidget, "" )
	game_stat_window.used_bonus_label = get_child_widget(dialog, "used_bonus_label", sf.gui.CLabelWidget, "" )
	game_stat_window.used_totems_label = get_child_widget(dialog, "used_totems_label", sf.gui.CLabelWidget, "" )
	game_stat_window.ach_recived_count = get_child_widget(dialog, "achievements_button", sf.gui.CButtonWidget, "" )
	
	game_stat_window.score_label.SetText(tostring(profile_data.GetScoreDelta()))
	game_stat_window.gold_label.SetText(tostring(game_window.game_field.GetMoneyPrize()))
	game_stat_window.time_label.SetText(TimeToString(game_window.game_field.GetGameTime()))

	game_stat_window.cup_destroy_label.SetText(tostring(game_window.game_info.GetDestroyedCapsCount()))
	game_stat_window.best_combo_label.SetText(tostring(game_window.game_info.GetBestCombo()))
	game_stat_window.used_bonus_label.SetText(tostring(game_window.game_info.GetBonusUsed()))
	game_stat_window.used_totems_label.SetText(tostring(game_window.game_info.GetTotemsUsedCount()))
	
	local ach_rec_count = game_window.game_info.GetAchievementRecivedCount()
	game_stat_window.ach_recived_count.SetText(s11.StringFormat(game_stat_window.ach_recived_count.GetText(), ach_rec_count))
	
	if ach_rec_count == 0 then
		__visible(game_stat_window.ach_recived_count, false)
	end
	
	game_stat_window._scores = profile_data.GetScoreDelta()
	
	dialog.SetOffset(
		game_window._game_field_center[1] - dialog.GetSize().X / 2, 
		game_window._game_field_center[2] - dialog.GetSize().Y / 2)

	stat_effects.Init(dialog, game_stat_window.effects_params)
		
	s11.g_TrackManager.Instance().UpdateCurrentTrack("town_map", false)
	
	__AddStatShoweffect(dialog)
	
    _window.AddChildWindow(dialog)
end

function game_stat_window.DoDraw(_this, _renderer) 
    return false 
end

function game_stat_window.DoUpdate(_this) 
	stat_effects.Update()
    return false 
end

function game_stat_window.OnChar(_this, _char, _keyboard_state, _state, _broadcast)
	return _this.SuperOnChar(_char, _keyboard_state, _state, _broadcast)
end

function game_stat_window.OnKeyDown(_this, _key, _keyboard_state, _state, _broadcast)
    return _this.SuperOnKeyDown( _key, _keyboard_state, _state, _broadcast)
end

function game_stat_window.OnKeyUp(_this, _key, _keyboard_state, _state, _broadcast)
	return _this.SuperOnKeyUp( _key, _keyboard_state, _state, _broadcast)
end

function game_stat_window.OnMouseMove(_this, _pos, _state, _broadcast)
	return _this.SuperOnMouseMove(_pos, _state, _broadcast) 
end

function game_stat_window.OnMouseDown(_this, _pos, _button, _state, _broadcast)
	stat_effects.End()
	return _this.SuperOnMouseDown( _pos, _button, _state, _broadcast) 
end

function game_stat_window.OnMouseUp(_this, _pos, _button, _state, _broadcast)
	return _this.SuperOnMouseUp( _pos, _button, _state, _broadcast) 
end

function game_stat_window.OnDoubleClick(_this, _pos, _state, _broadcast)
	return _this.SuperOnDoubleClick( _pos, _state, _broadcast) 
end

function game_stat_window.OnMouseWheel(_this, _pos, _delta, _state, _broadcast)
	return _this.SuperOnMouseWheel( _pos, _delta, _state, _broadcast)
end

function game_stat_window.OnChildAction(_this, _action, _child)
	if not _child then return end
	local handler = game_stat_window.actions[_child.GetId().c_str()]
	if handler then handler = handler[_action.c_str()] end
	if handler then handler(_this, _child) end
end

game_stat_window.actions.ok_button = 
{
	pressed = function(_window) 
		
		local current_profile = __cast(game_window.game_field.GetPlayerProfile(), s11.CProfileDataClassic)
		
		local level_progrees_info = current_profile.GetLevelProgress(game_window.current_game_dif_level, game_window.current_game_level_index)
		
		local level_progrees = level_progrees_info.GetProgress()
		local show_gems_clip = false
		if level_progrees == -1 then
			show_gems_clip = true
		end
		
		local new_level_progress = game_window.game_field.GetPrizeIndex() + 1
		if level_progrees == -1 or level_progrees > new_level_progress then
			level_progrees_info.SetProgress(new_level_progress)
		end
		
		--   
		local level_old_time = level_progrees_info.GetBestTime()
		local level_new_time = game_window.game_field.GetGameTime()
		if level_old_time < 0 or level_old_time > level_new_time then
			level_progrees_info.SetBestTime(level_new_time)
		end
		
		level_progrees_info.SetFinished(true)
		
		current_profile.SetLevelProgress(game_window.current_game_dif_level, game_window.current_game_level_index, level_progrees_info)
		
		current_profile.SetMoney(current_profile.GetMoney() + game_window.game_field.GetMoneyPrize())
		current_profile.SetPlayerLevel(current_profile.GetFinishedLevels())
		current_profile.DropSavedLevelInfo()

		current_profile.CreateTownSnapshot()
		game_window.current_profile.SaveGameType(s11.CGameStruct.GameTypeClassic)
		
		game_helpers.AddRecord(0)

		_window.AddFlags(_window.FlagDead)
		
		local curr_dif = game_window.current_game_dif_level
		local curr_lev = game_window.current_game_level_index
		local levels = s11.g_GameStruct.Instance().GetLevelsSystem(s11.CGameStruct.GameTypeClassic).GetLevelsCount(curr_dif)
		
		if curr_dif == 2 and curr_lev >= (levels-1) and not achievements.IsCompleted("all_levels") then
			end_window.Show(0)
		else
			if show_gems_clip then
				game_window.ShowEndLevelEffects()
			else
				map_window.Show()
			end
	    end 
	end
}

game_stat_window.actions.replay_button = 
{
	pressed = function(_window) 
		if dialog_do_modal("replay_dialog", _window) == 1 then
			game_window.Replay()
		end
	end
}

game_stat_window.actions.achievements_button = 
{
	pressed = function(_window) 
		achievements_window.Show(_window)
	end
}
