--    
lose_level_window = {}
lose_level_window.actions = {}

function lose_level_window.Show(_window)
	local dialog = sf.gui.CWindow()
	dialog.Load(g_App.GetSettings().GetChild("GUI", false).GetChildByAttribute("window", "id", "lose_level_window", true),
		g_App.GetSettings().GetChild("GUITemplates", false))
	dialog.UpdateLayout()
	
	dialog.SetOffset((_window.GetSize().X - dialog.GetSize().X)/2, (_window.GetSize().Y - dialog.GetSize().Y)/2)

	s11.g_TrackManager.Instance().UpdateCurrentTrack("town_map", false)
	
    _window.AddChildWindow(dialog)
end

function lose_level_window.DoDraw(_this, _renderer) 
    return false 
end

function lose_level_window.DoUpdate(_this) 
    return false 
end


function lose_level_window.OnChar(_this, _char, _keyboard_state, _state, _broadcast)
	return _this.SuperOnChar(_char, _keyboard_state, _state, _broadcast)
end

function lose_level_window.OnKeyDown(_this, _key, _keyboard_state, _state, _broadcast)
    return _this.SuperOnKeyDown( _key, _keyboard_state, _state, _broadcast)
end

function lose_level_window.OnKeyUp(_this, _key, _keyboard_state, _state, _broadcast)
	return _this.SuperOnKeyUp( _key, _keyboard_state, _state, _broadcast)
end

function lose_level_window.OnMouseMove(_this, _pos, _state, _broadcast)
	return _this.SuperOnMouseMove(_pos, _state, _broadcast) 
end

function lose_level_window.OnMouseDown(_this, _pos, _button, _state, _broadcast)
	return _this.SuperOnMouseDown( _pos, _button, _state, _broadcast) 
end

function lose_level_window.OnMouseUp(_this, _pos, _button, _state, _broadcast)
	return _this.SuperOnMouseUp( _pos, _button, _state, _broadcast) 
end

function lose_level_window.OnDoubleClick(_this, _pos, _state, _broadcast)
	return _this.SuperOnDoubleClick( _pos, _state, _broadcast) 
end

function lose_level_window.OnMouseWheel(_this, _pos, _delta, _state, _broadcast)
	return _this.SuperOnMouseWheel( _pos, _delta, _state, _broadcast)
end

function lose_level_window.OnChildAction(_this, _action, _child)
	if not _child then return end
	local handler = lose_level_window.actions[_child.GetId().c_str()]
	if handler then handler = handler[_action.c_str()] end
	if handler then handler(_this, _child) end
end

lose_level_window.actions.town_button = 
{
	pressed = function(_window) 
		game_window.profile_data.ReturnToTownSnapshot()
		town_window.Show()
	end
}

lose_level_window.actions.replay_button = 
{
	pressed = function(_window) 
		game_window.Replay()
	end
}
