--     
--              
game_time_counter = {}

game_time_counter._try_ach_interval = 60000  --         
game_time_counter._step_time = 3600  --              

--     
function game_time_counter.Init()
	game_time_counter._try_ach_time = 0

	local profile = s11.g_ProfileManager.Instance().GetCurrentProfile()
	__assert(profile)
		
	game_time_counter._profile = profile
	game_time_counter._time = profile.GetGameplayTime()
		
	local achs = s11.g_Achievements.Instance().GetProfileAchievements(profile)

	if achs.IsCompleted("5_hours_game") ~= 0 then 
		game_time_counter._disabled = true
	else
		game_time_counter._disabled = false
	end
end

--     
function game_time_counter.AddGameTime(_time)
	if game_time_counter._disabled then
		return
	end
	
	game_time_counter._time = game_time_counter._time + _time/1000
	game_time_counter._try_ach_time = game_time_counter._try_ach_time + _time
	game_time_counter._profile.SetGameplayTime(game_time_counter._time)
	
	if game_time_counter._try_ach_time > game_time_counter._try_ach_interval then
		game_time_counter._try_ach_time = 0
		achievements.RefreshAchievement("5_hours_game", math.floor(game_time_counter._time/game_time_counter._step_time))
		if achievements.IsCompleted("5_hours_game") then
			game_time_counter._disabled = true
		end
	end
end
