--       
end_window = {}
end_window.actions = {}

--   "  ...",      
end_window.press_any_key = {}
end_window.press_any_key.params = 
{
	--   ()
	anim = 
	{
		--   - ,            
		period = 3000,
		--    
		min_color = sf.graphics.Color(0,255,255,255),
		--    
		max_color = sf.graphics.Color(255,255,255,255)
	}
}

function end_window.press_any_key.Reset()
	end_window.press_any_key.timer = nil
	end_window.press_any_key.label = nil
end

function end_window.press_any_key.Init()
	end_window.press_any_key.timer = __create_timer()
	end_window.press_any_key.label = __cast(end_window._self.GetWidget("label", true), sf.gui.CLabelWidget)
end

function end_window.press_any_key.Update()
	if end_window.press_any_key.timer and end_window.press_any_key.label then
		local t = end_window.press_any_key.timer.Get().GetTime()
		local p = end_window.press_any_key.params.anim.period
		local k = (math.cos(2.0 * math.pi * ((t % p) / p)) + 1.0) / 2.0
		
		local min_color = end_window.press_any_key.params.anim.min_color
		local max_color = end_window.press_any_key.params.anim.max_color
		
		local color = sf.graphics.Color()
		color.Alpha = min_color.Alpha + k * (max_color.Alpha - min_color.Alpha)
		color.Red = min_color.Red + k * (max_color.Red - min_color.Red)
		color.Green = min_color.Green + k * (max_color.Green - min_color.Green)
		color.Blue = min_color.Blue + k * (max_color.Blue - min_color.Blue)
		color.Clamp()
		
		end_window.press_any_key.label.SetColor(color)
	end
end

function end_window.Close()
	main_menu.Show(false, end_window._game_mode)
end

function end_window.Show(_game_mode) -- _game_mode - 0(adventure)  2(puzzle)
	
	assert(_game_mode == 0 or _game_mode == 2)
	end_window._game_mode = _game_mode
	
	local game_modes = {"adventure", "", "puzzle"}
	
	local window = sf.gui.CWindow()
	end_window._self =  window

	window.Load(
		g_App.GetSettings().GetChild("GUI", false).GetChildByAttribute("window", "id", game_modes[_game_mode+1].."_end_window", true), 
		g_App.GetSettings().GetChild("GUITemplates", false))
	window.SetSize(g_App.GetRenderer().GetWidth(), g_App.GetRenderer().GetHeight())
	window.UpdateLayout()

	local clip = __cast(window.GetWidget("clip", true), sf.gui.CClipWidget)
	end_window._clip_duration = qe.GetClipTime(clip.GetClip())
	
	local end_mode_info =  g_App.GetSettings().GetChild(_T("Constants"), false).GetChildRef(_T("end_mode"), false)
	if end_mode_info then
		end_window._clip_duration = tonumber(end_mode_info.GetValue(game_modes[_game_mode+1].."_clip_duration").c_str()) or end_window._clip_duration		
	end

	end_window._timer = __create_timer()
	end_window._can_close = false
	end_window._need_close = false
	
	end_window.press_any_key.Reset()
	
	g_App.SetMainWindow(window)
	
	if _game_mode == 2 then
		achievements.GetAchievement("puzzle_all_levels")
	elseif _game_mode == 0 then
		achievements.GetAchievement("all_levels")
	end
    
	window = 0
	collectgarbage()
end

function end_window.DoDraw(_this, _renderer)
	return false
end

function end_window.DoUpdate(_this)
	if end_window._need_close then
		end_window.Close()
	end
	if not end_window._can_close and end_window._timer.Get().GetTime() >= end_window._clip_duration then
		end_window.press_any_key.Init()
		end_window._can_close = true
	end
	end_window.press_any_key.Update()
	return false
end

function end_window.OnChar(_this, _char, _keyboard_state, _state, _broadcast)
    return _this.SuperOnChar(_char, _keyboard_state, _state, _broadcast) 
end

function end_window.OnKeyDown(_this, _key, _keyboard_state, _state, _broadcast)
	if end_window._can_close then
		end_window._need_close = true
	end
	return _this.SuperOnKeyDown( _key, _keyboard_state, _state, _broadcast)
end

function end_window.OnKeyUp(_this, _key, _keyboard_state, _state, _broadcast)
	return _this.SuperOnKeyUp( _key, _keyboard_state, _state, _broadcast)
end

function end_window.OnMouseMove(_this, _pos, _state, _broadcast)
	return _this.SuperOnMouseMove( _pos, _state, _broadcast) 
end

function end_window.OnMouseDown(_this, _pos, _button, _state, _broadcast)
	if end_window._can_close then
		end_window._need_close = true
	end
	return _this.SuperOnMouseDown( _pos, _button, _state, _broadcast)
end

function end_window.OnMouseUp(_this, _pos, _button, _state, _broadcast)
	return _this.SuperOnMouseUp( _pos, _button, _state, _broadcast) 
end

function end_window.OnDoubleClick(_this, _pos, _state, _broadcast)
	return _this.SuperOnDoubleClick( _pos, _state, _broadcast) 
end

function end_window.OnMouseWheel(_this, _pos, _delta, _state, _broadcast)
	return _this.SuperOnMouseWheel( _pos, _delta, _state, _broadcast)
end

function end_window.OnChildAction(_this, _action, _child)
	if not _child then return end
	local handler = end_window.actions[_child.GetId().c_str()]
	if handler then handler = handler[_action.c_str()] end
	if handler then handler(_this, _child) end
end
