--     
avatar_widget = {}

avatar_widget._count = 0

__inherite(avatar_widget, null_lua_widget_handler())

function avatar_widget.__CreateInstance()
    return "avatar_widget"
end

avatar_widget._current_clip = nil  --   

avatar_widget._new_clip = nil      --       
avatar_widget._change_count = 0    --     

avatar_widget._change_time = 220  --   

avatar_widget._draw_mode_bar = false --    

avatar_widget._changes = {
	-- delta -  
	-- limit -    
	-- happy - ,       (      )
	
	town_no_res =    {delta = -10, limit = -50},  --       
	town_sell =      {delta = -45, limit = -60},  --   
	town_buy =       {delta = 100, limit = 70},  --  
	
	no_moves_classic = {delta = -70, limit = -50}, 	--      classic (    ) 4 -     
	no_moves_endless = {delta = -90, limit = -70},	--     endless (    ) 9 -     
	
	no_moves_puzzle =  {delta = -60, limit = -50},   --     Puzzle (       , undo  ) 6      
	no_moves_puzzle_turn_off = {delta = 90, limit = 40},   --     , undo  ,       puzzle
	
	no_moves_puzzle =  {delta = -70, limit = -50},   --     Puzzle (       , undo  ) 6      
	no_moves_puzzle_turn_off = {delta = 80, limit = 20},   --     , undo  ,       puzzle
	finish_level =     {delta = 150, limit = 90}, --     classic  puzzle (       ) 5      
	endless_finish_session = {delta = 70, limit = 60}, --     endless (    ) 5      
	on_score_frenzy =  {delta = 100, limit = 100}, --  -,      
	on_add_time =      {delta = 20, limit = 70}, --  -,      
	
	combo_good =     {delta = 5, limit = 60, happy = 10}, --  ,      
	combo_great =    {delta = 7, limit = 65, happy = 10}, -- ,       
	combo_incr =     {delta = 9, limit = 70, happy = 15}, -- ,      
	bonus_destroy =  {delta = 10, limit = 70, happy = 15}, --     
	row_destroy =    {delta = 5, limit = 50}, --   
	totem_use_1 =    {delta = 10, limit = 60, happy = 20}, --   (  )
	totem_use_2 =    {delta = 12, limit = 60, happy = 5}, --    (  )
	no_moves_delay = {delta = -70, limit = -60}, --     
	bad_moves =      {delta = -40, limit = -70}, --    
	bad_moves_turn_off = {delta = 120, limit = 30, happy  = 1 }, --       
	time_limit =     {delta = -200, limit = -60 }, --    
	
	test_down =      {delta = -10, limit = -100},  --    
	test_up =        {delta = 10, limit = -100},   
}

avatar_widget._mood = 0 -- 

avatar_widget._happy_min_mood = -30 ---       

avatar_widget._max_mood = 100 -- 
avatar_widget._min_mood = -100 -- 

avatar_widget._bad_mood_start = -40 --  
avatar_widget._good_mood_start = 40 --    

avatar_widget._bad_mood_fading = 3 --    
avatar_widget._good_mood_fading = 3 --    

avatar_widget._test_bar_offset = sf.misc.FloatVector(-50, -50) --  

avatar_widget._test_bar_width = 120 --    

avatar_widget._happy_time = 0 --   ( )
avatar_widget._max_happy_time = 2400 --   
avatar_widget._min_happy_time = 1100 --   

-- id   
avatar_widget._clip_ids = {
	woman = {
		neutral = "avatar_woman_neutral",
		happy   = "avatar_woman_happy",
		sad     = "avatar_woman_sad"
	},
	
	man = {
		neutral = "avatar_man_neutral",
		happy   = "avatar_man_happy",
		sad     = "avatar_man_sad"
	}
}

--    
function avatar_widget.AddHappy(_time)
	if avatar_widget._mood > avatar_widget._happy_min_mood then
	
		if avatar_widget._happy_time + _time <= avatar_widget._max_happy_time then
			avatar_widget._happy_time = avatar_widget._happy_time + _time
		else
			avatar_widget._happy_time = avatar_widget._max_happy_time
		end
		if avatar_widget._happy_time < avatar_widget._min_happy_time then
			avatar_widget._happy_time = avatar_widget._min_happy_time
		end
	end
	avatar_widget._CheckMoodState()
end

--  
function avatar_widget.ChangeMood(_id)
	local change_info = avatar_widget._changes[_id] 
	--       
	if not change_info then
		__message("unknow mod change id "..tostring(_id))
	else
		--     
		if change_info.happy then
			avatar_widget.AddHappy(change_info.happy)
		end
		
		--     
		local delta = change_info.delta
		if delta > 0 then
			--  
			if avatar_widget._mood + delta < change_info.limit then
				avatar_widget._mood = avatar_widget._mood + delta
			elseif avatar_widget._mood < change_info.limit then
				avatar_widget._mood = change_info.limit
			end
			if avatar_widget._mood > avatar_widget._good_mood_start then
				avatar_widget.ChangeSate("happy")	
			end
		
		else
			--  
			if avatar_widget._mood + delta > change_info.limit then
				avatar_widget._mood = avatar_widget._mood + delta
			elseif avatar_widget._mood > change_info.limit then
				avatar_widget._mood = change_info.limit
			end
			if avatar_widget._mood < avatar_widget._bad_mood_start then
				avatar_widget.ChangeSate("sad")	
			end
		end
	end
end

--   
function avatar_widget.ChangeSate(_id)
	--     ,     
	if avatar_widget._happy_time > 0 then
		_id = "happy"
	end

	--  ,     
	local target_clip  = avatar_widget._clip_list[_id]
	--     
	if avatar_widget._new_clip then
		
		if avatar_widget._new_clip == target_clip then
			--           
			return
		elseif avatar_widget._current_clip == target_clip then
			--          
			--      
			avatar_widget._current_clip = avatar_widget._new_clip
			avatar_widget._new_clip = target_clip
			avatar_widget._change_count = avatar_widget._change_time - avatar_widget._change_count
			return 
		end
	else
		--     
		if avatar_widget._current_clip == target_clip then
			-- 
			return
		end
	end
	--          
	avatar_widget._change_count = avatar_widget._change_time
	avatar_widget._new_clip = target_clip
end

function avatar_widget.Load(_this, _info, _templates)
	avatar_widget._timer = sf.core.CTimerWrapper(sf.core.g_Application.GetTimeManager().GetTimer("game_timer").AttachTimer(""))
	return true
end

--      
function avatar_widget._CheckMoodState()
	if avatar_widget._mood < avatar_widget._bad_mood_start then
		avatar_widget.ChangeSate("sad")
	elseif avatar_widget._mood > avatar_widget._good_mood_start then
		avatar_widget.ChangeSate("happy")
	else
		avatar_widget.ChangeSate("neutral")	
	end
end

--    
function avatar_widget.InitAvatar(_is_female, _do_not_drop_mood)
	local clips_id = "man"
	if _is_female then
		clips_id = "woman"
	end
	avatar_widget._clip_list  = {}
	for id, clip_id in pairs(avatar_widget._clip_ids[clips_id]) do
		local new_clip = sf.misc.anim.CClip()
		new_clip.Load(clip_id, true)
		avatar_widget._clip_list[id] = new_clip
	end
	--      
	if not _do_not_drop_mood then
		avatar_widget._mood = 0
		avatar_widget._current_clip = avatar_widget._clip_list["neutral"]
	else 
		avatar_widget._CheckMoodState()
	end
end

function avatar_widget.DoUpdate(_this)

	avatar_widget._current_clip.Update()	
	local frame_delta = avatar_widget._timer.Get().GetFrameDelta()
	--   
	if avatar_widget._happy_time > 0 then
		avatar_widget._happy_time = avatar_widget._happy_time - frame_delta
		if avatar_widget._happy_time <= 0 then
			avatar_widget._happy_time = 0
			avatar_widget._CheckMoodState()
		end
	end
	
	--    
	if avatar_widget._change_count > 0 then
		
		avatar_widget._change_count = avatar_widget._change_count - frame_delta
		avatar_widget._new_clip_alpha_koef = 1 - (avatar_widget._change_count/avatar_widget._change_time)
		if avatar_widget._change_count <= 0 then
			avatar_widget._current_clip = avatar_widget._new_clip
			avatar_widget._new_clip = nil
		end
	end
	
	--   
	local mood = avatar_widget._mood
	if math.abs(mood) > 0.1 then
		if mood > 0 then
		   mood = mood - (avatar_widget._good_mood_fading * frame_delta)/1000
		   if mood < avatar_widget._good_mood_start then
				avatar_widget.ChangeSate("neutral")	
		   end
		else
		   mood = mood + (avatar_widget._bad_mood_fading * frame_delta)/1000
		   if mood > avatar_widget._bad_mood_start then
				avatar_widget.ChangeSate("neutral")	
		   end
		end
		avatar_widget._mood = mood
	end
	
	return false
end

--      
function avatar_widget.DrawMood( _renderer, _mood, _color)
	
	local max_len = math.abs(avatar_widget._max_mood - avatar_widget._min_mood)
	local _mood_len = math.abs(_mood - avatar_widget._min_mood)
	
	local _dist = (_mood_len * avatar_widget._test_bar_width)/max_len
	
	avatar_widget.DrawBar( _renderer, _dist, _color)
end

function avatar_widget.DrawBar( _renderer, _dist, _color)
	_renderer.RenderLine(avatar_widget._test_bar_offset + sf.misc.FloatVector(_dist, -10),avatar_widget._test_bar_offset  + sf.misc.FloatVector(_dist,10), _color)
end

function avatar_widget.DoDraw(_this, _renderer)

	avatar_widget._current_clip.Draw(_renderer)
	
	if avatar_widget._new_clip and avatar_widget._new_clip_alpha_koef then
		local color = sf.graphics.Color(_renderer.GetColor())
		color.Alpha = color.Alpha * avatar_widget._new_clip_alpha_koef
		_renderer.SetColor(color)
		avatar_widget._new_clip.Draw(_renderer)
	end
	if avatar_widget._draw_mode_bar then
		if sf.core.g_Application.GetDebugLevel() >= sf.core.g_Application.DebugCheats then
			avatar_widget.DrawBar(_renderer, 0, 0xffffffff)
			avatar_widget.DrawBar(_renderer, avatar_widget._test_bar_width, 0xffffffff)
			
			avatar_widget.DrawMood( _renderer, avatar_widget._bad_mood_start, 0xff8888ff)
			avatar_widget.DrawMood( _renderer, avatar_widget._good_mood_start, 0xff8888ff)
			avatar_widget.DrawMood( _renderer, 0, 0xffff8888)
			
			avatar_widget.DrawMood( _renderer, avatar_widget._mood, 0xffff00ff)
		end
	end
    return false
end

function avatar_widget.OnMouseMove(_this, _pos, _state, _broadcast)
    return false
end

function avatar_widget.OnMouseUp(_this, _pos, _button, _state, _broadcast)
    return false
end

function avatar_widget.OnMouseDown(_this, _pos, _button, _state, _broadcast)
    return false
end

function avatar_widget.OnDoubleClick(_this, _pos, _state, _broadcast)
    return true
end
