blinking_progress_widget = blinking_progress_widget or {}

__inherite(blinking_progress_widget, null_lua_widget_handler())

function blinking_progress_widget.__CreateInstance()
    return "blinking_progress_widget"
end

blinking_progress_widget.params = 
{
	period = 3500,
	max_alpha = 100
}

function blinking_progress_widget.Stop()
	blinking_progress_widget._stopped = true
end

function blinking_progress_widget.Load(_this, _info, _templates)
	blinking_progress_widget._stopped = false
	blinking_progress_widget._alpha = 0
	blinking_progress_widget._frame_texture = sf.core.g_Application.GetResourceManager().GetTexture("screens_game_progress_frame")
	blinking_progress_widget._progress_texture = sf.core.g_Application.GetResourceManager().GetTexture("screens_game_progress")	
	assert(blinking_progress_widget._progress_texture)
	assert(blinking_progress_widget._frame_texture)
	blinking_progress_widget._timer = __create_timer()
end

function blinking_progress_widget.DoUpdate(_this)
	if not blinking_progress_widget._stopped then
		local t1 = blinking_progress_widget._timer.Get().GetTime()
		local t2 = blinking_progress_widget.params.period
		local a = blinking_progress_widget.params.max_alpha * ((math.cos (2 * math.pi * ((t1 % t2) / t2)) + 1) / 2)
		blinking_progress_widget._alpha = a
	end
	return false
end

function blinking_progress_widget.DoDraw(_this, _renderer)
	
	_renderer.PushState()
	
	_renderer.SetBlendMode(_renderer.BlendAdditive)
	_renderer.SetColor(sf.graphics.Color(blinking_progress_widget._alpha * (_this.GetColor().Alpha / 255), 255, 255, 255))
	
	local r1 = blinking_progress_widget._frame_texture.GetTexture(0).GetRect()
	local dst1 = sf.misc.FloatRect(0, 0, r1.Width, r1.Height)
	local src1 = sf.misc.IntRect(0, 0, r1.Width, r1.Height)
	_renderer.RenderTextureBox(blinking_progress_widget._frame_texture.GetTexture(0), dst1, src1, sf.graphics.Color(255,255,255,255))
	
	local r2 = blinking_progress_widget._progress_texture.GetTexture(0).GetRect()
	local dst2 = sf.misc.FloatRect(0, 0, r2.Width, r2.Height)
	local src2 = sf.misc.IntRect(0, 0, r2.Width, r2.Height)
	_renderer.RenderTextureBox(blinking_progress_widget._progress_texture.GetTexture(0), dst2, src2, sf.graphics.Color(255,255,255,255))
	
	_renderer.PopState()
	
    return false
end

function blinking_progress_widget.OnMouseMove(_this, _pos, _state, _broadcast)
    return false
end

function blinking_progress_widget.OnMouseUp(_this, _pos, _button, _state, _broadcast)
    return false
end

function blinking_progress_widget.OnMouseDown(_this, _pos, _button, _state, _broadcast)
    return false
end

function blinking_progress_widget.OnDoubleClick(_this, _pos, _state, _broadcast)
    return true
end
