--     
drop_buttons = {}

drop_buttons._disabled = nil

function drop_buttons.Init(_window, _game_info)
	drop_buttons._game_info = _game_info

	drop_buttons._drops_buttons = {}
	drop_buttons._drops_buttons[1] = get_child_widget(_window, "drop_button", sf.gui.CButtonWidget)
	drop_buttons._drops_buttons[2] = get_child_widget(_window, "drop_button02", sf.gui.CButtonWidget)

	drop_buttons.UpdateButtons()
end

function drop_buttons.DropToolTips()
	for _,o in pairs(drop_buttons._drops_buttons) do
		local tool_tip_helper = get_child_widget(o, "ToolTipHelperWidget", sf.gui.CToolTipHelperWidget, "  ") 
		tool_tip_helper.StopShowToolTip()
	end
end

function drop_buttons.SetDisable(_value)
	drop_buttons._disabled = _value
	drop_buttons.UpdateButtons()
end

function drop_buttons._disable_button(_button, _value)
	set_widget_flag_value(_button, sf.gui.CBaseWidget.FlagDisabled, _value)
	_button.DisableButton(_value)
end

function drop_buttons.GetDropsCount()
	return drop_buttons._game_info.GetPlayersDropsCount()
end

function drop_buttons.UpdateButtons()
	
	local drop_count = drop_buttons._game_info.GetPlayersDropsCount()
	if drop_count < 2 then
		drop_buttons._disable_button(drop_buttons._drops_buttons[1], true)
		set_widget_flag_value(drop_buttons._drops_buttons[1], sf.gui.CBaseWidget.FlagHidden, true)
		if drop_count < 1 then
			drop_buttons._disable_button(drop_buttons._drops_buttons[2], true)
		else
			drop_buttons._disable_button(drop_buttons._drops_buttons[2], false)
		end
	else
		drop_buttons._disable_button(drop_buttons._drops_buttons[1], false)
		set_widget_flag_value(drop_buttons._drops_buttons[1], sf.gui.CBaseWidget.FlagHidden, false)
	end
	if drop_buttons._disabled then
		drop_buttons._disable_button(drop_buttons._drops_buttons[1], true)
		drop_buttons._disable_button(drop_buttons._drops_buttons[2], true)
	end
end

function drop_buttons.SetDropButtonsCount(_value)
	drop_buttons._game_info.SetPlayersDropsCount(_value)
	drop_buttons.UpdateButtons()
end
