---     (      )
gems_bar_widget = gems_bar_widget or {}

__inherite(gems_bar_widget, null_lua_widget_handler())

function gems_bar_widget.__CreateInstance()
    return "gems_bar_widget"
end

gems_bar_widget._gem_size = sf.misc.FloatVector(48, 48)

--        
function gems_bar_widget.add_gem(_color, _add_visible)
	gems_bar_widget._drawer.AddGem(_add_visible, _color)
	if _add_visible then
		gems_bar_widget.visible_gem_count = gems_bar_widget._drawer.GetVisibleGemsCount()
		game.OnGemAddToGemBar()
		gems_bar_widget.InitLabels(true)
		if gems_bar_widget.visible_gem_count == gems_bar_widget.gem_target then
			game.OnLastGemAdd()
		end
	else
		if gems_bar_widget.gems_count < gems_bar_widget.gem_target then
			game.OnGemAdd()
			return
		end
	end
end
--      -
function gems_bar_widget.get_next_gem_pos()
	return gems_bar_widget._drawer.GetNextGemPos()
end

gems_bar_widget.gems_images = {}

function gems_bar_widget.InitLabels(_only_visible)
	if gems_bar_widget.gems_count_label then
		gems_bar_widget.gems_count_label.SetText(tostring(gems_bar_widget.visible_gem_count))
	end
	if not _only_visible then
		if gems_bar_widget.gems_target_label then
			gems_bar_widget.gems_target_label.SetText(tostring(gems_bar_widget.gem_target))
		end
	end
end

function gems_bar_widget.Init(_game_field, _parent_window)
	local game_play_settings = _game_field.GetGameplaySettings()
    --        
	gems_bar_widget.gems_count_label = get_child_widget(_parent_window, "gems_count_label", sf.gui.CLabelWidget, "  gems_label" )
	
	gems_bar_widget.gems_target_label = get_child_widget(_parent_window, "gems_target_label", sf.gui.CLabelWidget, "  gems_label" )

	gems_bar_widget.gem_list = {}
	gems_bar_widget.gem_target = game_play_settings.GetGemTarget()
	
	local taked_gems = _game_field.GetDestroyedGems()
	
	gems_bar_widget._drawer = s11.CGemBarDrawer(_game_field.GetGameInfo())
	gems_bar_widget._drawer.Init(taked_gems, gems_bar_widget.gem_target, _game_field, gems_bar_widget.size)


	gems_bar_widget.gems_count = taked_gems
	gems_bar_widget.visible_gem_count = taked_gems
	
	gems_bar_widget.InitLabels()
end

function gems_bar_widget.Load(_this, _info, _templates)
	gems_bar_widget.size = _this.GetSize()
	gems_bar_widget.offset = _this.GetOffset()
end

function gems_bar_widget.DoUpdate(_this)
	gems_bar_widget._drawer.Update()
	return false
end

function gems_bar_widget.DoDraw(_this, _renderer)
	gems_bar_widget._drawer.Draw(_renderer)

    return false
end

function gems_bar_widget.OnMouseMove(_this, _pos, _state, _broadcast)
    return false
end

function gems_bar_widget.OnMouseUp(_this, _pos, _button, _state, _broadcast)
    return false
end

function gems_bar_widget.OnMouseDown(_this, _pos, _button, _state, _broadcast)
    return false
end

function gems_bar_widget.OnDoubleClick(_this, _pos, _state, _broadcast)
    return true
end
