--       ,    
--            
--        

--      FormHintButton      
--      ,    ,      
--       

--       hint_button.StartHintButtonResume()
--        ,    
-- hint_button.UpdateHintButton(_progress_time) _progress_time   0  1    
--     1      

--        ,   hint_button.StartBonusHintTimer()
--        ,    hint_button.UpdateHintButton(_progress_time)
-- _progress_time   .  _progress_time   0   .

--       ,        

hint_button = {}

__inherite(hint_button, null_lua_widget_handler()) 

function hint_button.__CreateInstance()
    return "hint_button"
end

hint_button._show_hint_timer_mode = false   --      
                                            --  ,      

hint_button._image_id = "screens_game_progress_hint"          -- ,    
hint_button._image_offset = sf.misc.FloatVector(0, 0)         --      
hint_button._font_id = "mpc_gradient_30"                      -- ,     
hint_button._text_offset = sf.misc.FloatVector(40, 18)        --    
hint_button.effect_fly_target = sf.misc.FloatVector(0, 0)     --     (    )

--      
function hint_button.StartBonusHintTimer()
	hint_button._show_hint_timer_mode = true
	hint_button.SetHintButtonDisabled(true)
end

--     
function hint_button.StartHintButtonResume()
	--hint_button._hint_resume_time = _resume_time
	hint_button._show_hint_timer_mode = false
	hint_button.SetHintButtonDisabled(true)
end

--      
function hint_button.IsHintButtonDisabled()
	return hint_button._hint_button_widget.GetButtonState() == sf.gui.CButtonWidget.StateDisabled
end

-- ,      
function hint_button.SetHintButtonDisabled(_is_disable)
	hint_button._show = _is_disable
	hint_button._hint_button_widget.DisableButton(_is_disable)
	hint_button._hint_button_widget.OnMouseMove(sf.misc.FloatVector(-1000, -1000), 0, true)
end

--        
function hint_button.UpdateHintButton(_progress_time)
	--       
	if hint_button._show_hint_timer_mode then
		--        
		if _progress_time > 1 then
			--   
			hint_button._text = tostring(math.ceil(_progress_time/1000))
		else
			--   
			hint_button._text = nil
			--      
			hint_button._show_hint_timer_mode = false
			hint_button.SetHintButtonDisabled(false)
		end
		
	else
		--      , 
		--        
		if 1 - _progress_time > 0.01 then
			--      
			hint_button.UpdateProgressImage(_progress_time)
			hint_button._need_finish_sound = true
		else
			--        
			if hint_button._need_finish_sound then
				hint_button._need_finish_sound = nil
				__sound("hint_add")
			end
			hint_button.SetHintButtonDisabled(false)
		end
	end
end

--        
function hint_button.FormHintButton(_hint_button_widget, _restore_image)
	--     
	local restore_image = _restore_image
	if not restore_image then
		restore_image = hint_button._image_id
	end
	
	hint_button._need_finish_sound = nil
	--     ,    
	local button_widget = _hint_button_widget
	
	--   ,     
	local resume_widget = sf.gui.CLuaWidget("hint_button_widget", 50, 0)

	--      
	resume_widget.SetOffset(0, 0)
	resume_widget.SetLua(g_Lua.GetId())
	resume_widget.SetOverloadTable("hint_button")
	
	--    
	button_widget.AddWidget(resume_widget)
	
					 
	--        
	hint_button._show = true

	--  -
	hint_button._parent_size = button_widget.GetSize()

	--  
	hint_button._image = sf.graphics.CImage(restore_image)

	local image_rect = hint_button._image.GetRect()

	--   
	hint_button._image_size = sf.misc.FloatVector(image_rect.Width, image_rect.Height )
	
	--    
	hint_button._font = sf.core.g_Application.GetResourceManager().GetFont(hint_button._font_id)
	
	--  
	hint_button._text_offset = hint_button._text_offset
					 
	--  
	hint_button._hint_button_widget = button_widget
	hint_button._hint_resume_widget = resume_widget
	
	hint_button.SetHintButtonDisabled(false)
	hint_button._show_hint_timer_mode = false
	hint_button._text = nil
end	

--    
function hint_button.UpdateProgressImage(_koef)
    hint_button._image.SetRect(sf.misc.FloatRect(0, 
												 0, 
												 hint_button._parent_size.X * _koef, 
												 hint_button._parent_size.Y) )
    hint_button._image.SetSourceRect(sf.misc.FloatRect(0, 
													   0, 
													   hint_button._image_size.X * _koef, 
													   hint_button._image_size.Y) )
end

--      
function hint_button.DoDraw(_this, _renderer)
    if hint_button._show then
		if hint_button._text and hint_button._font then
			_renderer.RenderString(hint_button._font, 
			                       hint_button._text, 
								   hint_button._text_offset.X, 
								   hint_button._text_offset.Y, 
								   0, 
								   0, 
								   1, 
								   sf.graphics.Color(255, 255, 255, 255), 0)
		else
			_renderer.PushState()
			_renderer.ApplyMatrix( sf.misc.MatrixTranslation(hint_button._image_offset.X, hint_button._image_offset.Y))
			hint_button._image.Draw(_renderer) 
			_renderer.PopState()
		end
	end
    return false
end
