--         
start_level_effect = {}

start_level_effect._widget_list = {} --  ,     
start_level_effect._fast_show_list = {} --  ,     

start_level_effect._clip = nil --     

start_level_effect._widgets_show_time = 200 --     
start_level_effect._after_clip_delay = 50 --    
start_level_effect._pre_field_effect_delay = nil --      

start_level_effect._ignore_widgets = {

game_widget = true

}

start_level_effect._clips_chache = {}

--      
function start_level_effect.IsDead()
	if start_level_effect._stage == 4 then
		return true
	end
	return false
end

--   
function start_level_effect.InstantApply()
	if start_level_effect._stage ~= 4 then
	
		for _, widget in pairs(start_level_effect._widget_list) do
			widget.SetColor(sf.graphics.Color(255,255,255,255))
		end
		for _, widget in pairs(start_level_effect._fast_show_list) do
			widget.SetColor(sf.graphics.Color(255,255,255,255))
		end

		start_level_effect._stage = 4
		start_level_effect._start_clip = nil
		start_level_effect._show_time=  nil
		start_level_effect._pre_field_effect_delay = nil
		
		start_level_effect._game_widget.GetGameField().ForceFinishOfStartLevel()
		
		set_widget_flag_value(start_level_effect._game_widget, sf.gui.CBaseWidget.FlagDisabled, false)
		if start_level_effect._on_form_level_event then
			start_level_effect._on_form_level_event()
		end
	end
end

--   ,        
function start_level_effect.FormStartClipsChache()
	start_level_effect.AddClipToCache("level_begin03")
end

function start_level_effect.AddClipToCache(_start_clip_id)
	if start_level_effect._clips_chache[_start_clip_id] then
		return
	end
	local new_clip = sf.misc.anim.CClip()
	new_clip.Load(_start_clip_id, true)
	new_clip.SetPos(sf.misc.FloatVector(512, 384))
	new_clip.Stop()
	
	start_level_effect._clips_chache[_start_clip_id] = new_clip
end

function start_level_effect.CreateClip(_start_clip_id)
	
	local chache_clip = start_level_effect._clips_chache[_start_clip_id]
	if not chache_clip then
		start_level_effect.AddClipToCache(_start_clip_id)
		chache_clip = start_level_effect._clips_chache[_start_clip_id]
	end
	return sf.misc.anim.CClip(chache_clip)
end

---    
-- _level_name -    
-- _field_effect_delay -      
function start_level_effect.InitStartEffect(_window, _start_clip_id, _game_field_widget, _fast_show_widgets, _level_name, _field_effect_delay, _on_form_level_event)
	start_level_effect._caps_formed = nil
	start_level_effect._on_form_level_event = _on_form_level_event
	start_level_effect._pre_field_effect_delay = _field_effect_delay
	start_level_effect._stage = 1   -- 1 - show clip       2 - show widgets
	start_level_effect._show_time=  nil
	
	_game_field_widget.GetGameField().InitStartLevel(_level_name)
	set_widget_flag_value(_game_field_widget, sf.gui.CBaseWidget.FlagDisabled, true)
	
	start_level_effect._game_widget = _game_field_widget
	start_level_effect._start_clip = start_level_effect.CreateClip(_start_clip_id)
	
	start_level_effect._clip_time = qe.GetClipTime(start_level_effect._start_clip) + start_level_effect._after_clip_delay

	start_level_effect._widget_list = {}
	start_level_effect._fast_show_list = {}
	local widget = _window.GetWidgets()
    while not widget.IsEnd() do
		local cur_widget = widget.Get()
		
		local id = cur_widget.GetId().c_str()
		if not start_level_effect._ignore_widgets[id] then
			if _fast_show_widgets[id] then
				table.insert(start_level_effect._fast_show_list, cur_widget)
			else
				table.insert(start_level_effect._widget_list, cur_widget)
			end
		end
		
        widget.Next()
    end
end

---    
function start_level_effect.HideWidgets()
	for _, widget in pairs(start_level_effect._widget_list) do
		widget.SetColor(sf.graphics.Color(0,0,0,0))
	end
	for _, widget in pairs(start_level_effect._fast_show_list) do
		widget.SetColor(sf.graphics.Color(0,0,0,0))
	end
end

---    
function start_level_effect.StartBeginLevelEffect()
	start_level_effect._timer = __create_timer()
	start_level_effect._timer.Get().SetTime(0)
	
	local time_ = start_level_effect._timer.Get().GetTime()
	start_level_effect._show_time = start_level_effect._clip_time 

	start_level_effect._start_clip.Play()
end

function start_level_effect.OnFormFieldCaps()
	start_level_effect._caps_formed = true
end

function start_level_effect.Update()
	
	if start_level_effect._show_time then
		local time_ = start_level_effect._timer.Get().GetTime()
		local effect_koef = -1
		
		if start_level_effect._pre_field_effect_delay then
			effect_koef = time_ / start_level_effect._pre_field_effect_delay
		end

		if effect_koef > 1 then
			start_level_effect._pre_field_effect_delay = nil
			set_widget_flag_value(start_level_effect._game_widget, sf.gui.CBaseWidget.FlagDisabled, false)
		end

		local koef = time_ / start_level_effect._show_time
		if koef > 1 then
			koef = 1
		end
		
		if start_level_effect._stage == 1 then

			if koef >= 1 then
				start_level_effect._stage = 2
				start_level_effect._show_time = start_level_effect._widgets_show_time
				start_level_effect._timer.Get().SetTime(0)
				start_level_effect._start_clip = nil

				for _, widget in pairs(start_level_effect._fast_show_list) do
					widget.SetColor(sf.graphics.Color(255,255,255,255))
				end
			end
		elseif start_level_effect._stage == 2 then
			if koef < 1 then
				for _, widget in pairs(start_level_effect._widget_list) do
					widget.SetColor(sf.graphics.Color(255*koef, 255, 255, 255))
				end
			else
				for _, widget in pairs(start_level_effect._widget_list) do
					widget.SetColor(sf.graphics.Color(255,255,255,255))
				end
				start_level_effect._stage = 3
			end
		elseif start_level_effect._stage == 3 and start_level_effect._caps_formed then		
			start_level_effect._stage = 4
			if start_level_effect._on_form_level_event then
				start_level_effect._on_form_level_event()
			end
			--   
		elseif start_level_effect._stage == 4 then		
			start_level_effect._show_time=  nil
		end
	end
	if start_level_effect._start_clip then
		start_level_effect._start_clip.Update()
	end
	---        
	---         
end

function start_level_effect.Draw(_render)
	if start_level_effect._start_clip then
		start_level_effect._start_clip.Draw(_render)
	end
	---        
end
