totems = totems or {}

--  
totems.params = 
{
	--   
	center = {135,135},
	
	-- ,     (   )
	activate_time =	200,
	-- ,     (   )
	deactivate_time = 400,
	--      
	delay_before_deactivate = 600,
	--   
	demonstrate_time = 1000,
	
	-- ,       
	small_scale = {0.3, 0.3},
	
	--   
	yellow_totem = 
	{
		-- 1- 
		{
			contour = "screens_game_totems_yellow_contur_state1",
			small = "screens_game_totems_yellow_small_state1",
			big = "screens_game_totems_yellow_state1",
			-- ,        
			clips = 
			{
				---  1- 
				{"totem_yellow_state01" ,"totem_yellow_left-eye"},
				--  2- 
				{"totem_yellow_state01","totem_yellow_left-eye", "totem_yelow_right-eye"},
				--  3- 
				{}
			}
		},
		-- 2- 
		{
			contour = "screens_game_totems_yellow_contur_state2",
			small = "screens_game_totems_yellow_small_state2",
			big = "screens_game_totems_yellow_state2",
			-- ,        
			clips = 
			{
				--  1- 
				{"totem_yellow_state02" , "totem_yellow_left-eye" },
				--  2- 
				{"totem_yellow_state02" ,"totem_yellow_left-eye", "totem_yelow_right-eye"},
				--  3- 
				{}
			}
		},
		-- 3- 
		{
			contour = "screens_game_totems_yellow_contur_state3",
			small = "screens_game_totems_yellow_small_state3",
			big = "screens_game_totems_yellow_state3",
			-- ,        
			clips = 
			{
				--  1- 
				{"totem_yellow_state03", "totem_yellow_left-eye" },
				--  2- 
				{"totem_yellow_state03","totem_yellow_left-eye", "totem_yelow_right-eye"},
				--  3- 
				{"totem_yellow_state03","totem_yellow_left-eye", "totem_yelow_right-eye", "totem_yelow_mouth"}
			}
		},
		-- 4- 
		{
			contour = "screens_game_totems_yellow_contur_state3",
			small = "screens_game_totems_yellow_small_state3",
			big = "screens_game_totems_yellow_state3",
			-- ,        
			clips = 
			{
				--  1- 
				{"totem_yellow_state04","totem_yellow_left-eye" },
				--  2- 
				{"totem_yellow_state04" ,"totem_yellow_left-eye", "totem_yelow_right-eye"},
				--  3- 
				{"totem_yellow_state04","totem_yellow_left-eye", "totem_yelow_right-eye", "totem_yelow_mouth"}
			}
		},
		--  
		contour_pos = {155, 20},
		--   
		small_pos = {155, 20},
		-- ,       
		activation_start_pos = {155, 22},
		--     (    )
		feature_clips = {},
		--    
		sound = "totem_yellow_use01"
	},
	--   
	orange_totem = 
	{
		-- 1- 
		{
			contour = "screens_game_totems_orange_contur_state1",
			small = "screens_game_totems_orange_small_state1",
			big = "screens_game_totems_orange_state1",
			-- ,        
			clips = 
			{
				--  1- 
				{"totem_orange_left-eye"},
				--  2- 
				{"totem_orange_left-eye", "totem_orange_right-eye"},
				--  3- 
				{"totem_orange_left-eye", "totem_orange_right-eye", "totem_orange_mouth"}
			}
		},
		-- 2- 
		{
			contour = "screens_game_totems_orange_contur_state1",
			small = "screens_game_totems_orange_small_state1",
			big = "screens_game_totems_orange_state1",
			-- ,        
			clips = 
			{
				--  1- 
				{"totem_orange_left-eye"},
				--  2- 
				{"totem_orange_left-eye", "totem_orange_right-eye"},
				--  3- 
				{"totem_orange_left-eye", "totem_orange_right-eye", "totem_orange_mouth"}
			}
		},
		-- 3- 
		{
			contour = "screens_game_totems_orange_contur_state1",
			small = "screens_game_totems_orange_small_state2",
			big = "screens_game_totems_orange_state2",
			-- ,        
			clips = 
			{
				--  1- 
				{"totem_orange_left-eye"},
				--  2- 
				{"totem_orange_left-eye", "totem_orange_right-eye"},
				--  3- 
				{"totem_orange_left-eye", "totem_orange_right-eye", "totem_orange_mouth"}
			}
		},
		-- 4- 
		{
			contour = "screens_game_totems_orange_contur_state1",
			small = "screens_game_totems_orange_small_state2",
			big = "screens_game_totems_orange_state2",
			-- ,        
			clips = 
			{
				--  1- 
				{"totem_orange_left-eye"},
				--  2- 
				{"totem_orange_left-eye", "totem_orange_right-eye"},
				--  3- 
				{"totem_orange_left-eye", "totem_orange_right-eye", "totem_orange_mouth"}
			}
		},
		--  
		contour_pos = {210, 95},
		--   
		small_pos = {210, 95},
		-- ,       
		activation_start_pos = {190, 93},
		--     (    )
		feature_clips = {},
		--    
		sound = "totem_orange_use01"
	},
	--   
	white_totem = 
	{
		-- 1- 
		{
			contour = "screens_game_totems_white_contur_state1",
			small = "screens_game_totems_white_small_state1",
			big = "screens_game_totems_white_state1",
			-- ,        
			clips = 
			{
				--  1- 
				{"totem_white_state1", "totem_white_state01_02_water", "totem_white_left-eye"},
				--  2- 
				{"totem_white_state1", "totem_white_state01_02_water", "totem_white_left-eye", "totem_white_right-eye"},
				--  3- 
				{}
			}
		},
		-- 2- 
		{
			contour = "screens_game_totems_white_contur_state1",
			small = "screens_game_totems_white_small_state1",
			big = "screens_game_totems_white_state1",
			-- ,        
			clips = 
			{
				--  1- 
				{"totem_white_state2", "totem_white_state01_02_water", "totem_white_left-eye"},
				--  2- 
				{"totem_white_state2", "totem_white_state01_02_water", "totem_white_left-eye", "totem_white_right-eye"},
				--  3- 
				{"totem_white_state2", "totem_white_state01_02_water", "totem_white_left-eye", "totem_white_right-eye", "totem_white_mouth"}
			}
		},
		-- 3- 
		{
			contour = "screens_game_totems_white_contur_state2",
			small = "screens_game_totems_white_small_state2",
			big = "screens_game_totems_white_state2",
			-- ,        
			clips = 
			{
				--  1- 
				{"totem_white_state3", "totem_white_state03_04_water", "totem_white_left-eye"},
				--  2- 
				{"totem_white_state3", "totem_white_state03_04_water", "totem_white_left-eye", "totem_white_right-eye"},
				--  3- 
				{"totem_white_state3", "totem_white_state03_04_water", "totem_white_left-eye", "totem_white_right-eye", "totem_white_mouth"}
			}
		},
		-- 4- 
		{
			contour = "screens_game_totems_white_contur_state2",
			small = "screens_game_totems_white_small_state2",
			big = "screens_game_totems_white_state2",
			-- ,        
			clips = 
			{
			    --  1- 
				{"totem_white_state4", "totem_white_state03_04_water", "totem_white_left-eye"},
				--  2- 
				{"totem_white_state4", "totem_white_state03_04_water", "totem_white_left-eye", "totem_white_right-eye"},
				--  3- 
				{"totem_white_state4", "totem_white_state03_04_water", "totem_white_left-eye", "totem_white_right-eye", "totem_white_mouth"}
			}
		},
		--  
		contour_pos = {55, 20},
		--   
		small_pos = {55, 20},
		-- ,       
		activation_start_pos = {32, 19},
		--     (    )
		feature_clips = {},
		--    
		sound = "totem_white_use01"
	},
	--   
	violet_totem = 
	{
		-- 1- 
		{
			contour = "screens_game_totems_violet_contur_state1",
			small = "screens_game_totems_violet_small_state1",
			big = "screens_game_totems_violet_state1",
			-- ,        
			clips = 
			{
				--  1- 
				{"totem_violet_state1" , "totem_violet_left-eye"},
				--  2- 
				{"totem_violet_state1" , "totem_violet_left-eye", "totem_violet_right-eye"},
				--  3- 
				{}
			}
		},
		-- 2- 
		{
			contour = "screens_game_totems_violet_contur_state1",
			small = "screens_game_totems_violet_small_state1",
			big = "screens_game_totems_violet_state1",
			-- ,        
			clips = 
			{
				--  1- 
				{"totem_violet_state2" , "totem_violet_left-eye"},
				--  2- 
				{"totem_violet_state2" , "totem_violet_left-eye", "totem_violet_right-eye"},
				--  3- 
				{}
			}
		},
		-- 3- 
		{
			contour = "screens_game_totems_violet_contur_state2",
			small = "screens_game_totems_violet_small_state2",
			big = "screens_game_totems_violet_state2",
			-- ,        
			clips = 
			{
				--  1- 
				{"totem_violet_state3" , "totem_violet_left-eye"},
				--  2- 
				{"totem_violet_state3" , "totem_violet_left-eye", "totem_violet_right-eye"},
				--  3- 
				{"totem_violet_state3" , "totem_violet_left-eye", "totem_violet_right-eye","totem_violet_mouth"}
			}
		},
		-- 4- 
		{
			contour = "screens_game_totems_violet_contur_state2",
			small = "screens_game_totems_violet_small_state2",
			big = "screens_game_totems_violet_state2",
			-- ,        
			clips = 
			{
				--  1- 
				{"totem_violet_state3" , "totem_violet_left-eye"},
				--  2- 
				{"totem_violet_state4" , "totem_violet_left-eye", "totem_violet_right-eye"},
				--  3- 
				{"totem_violet_state4" , "totem_violet_left-eye", "totem_violet_right-eye", "totem_violet_mouth"}
			}
		},
		--  
		contour_pos = {5, 80},
		--   
		small_pos = {5, 80},
		-- ,       
		activation_start_pos = {-8, 83},
		--     (    )
		feature_clips = {},
		--    
		sound = "totem_violet_use01"
	},
	--   
	green_totem = 
	{
		-- 1- 
		{
			contour = "screens_game_totems_green_contur_state1",
			small = "screens_game_totems_green_small_state1",
			big = "screens_game_totems_green_state1",
			-- ,        
			clips = 
			{
				--  1- 
				{"totem_green_left-eye"},
				--  2- 
				{"totem_green_left-eye", "totem_green_right-eye"},
				--  3- 
				{"totem_green_left-eye", "totem_green_right-eye", "totem_green_mouth"}
			}
		},
		-- 2- 
		{
			contour = "screens_game_totems_green_contur_state2",
			small = "screens_game_totems_green_small_state2",
			big = "screens_game_totems_green_state2",
			-- ,        
			clips = 
			{
				--  1- 
				{"totem_green_state01" , "totem_green_left-eye"},
				--  2- 
				{"totem_green_state01" ,"totem_green_left-eye", "totem_green_right-eye"},
				--  3- 
				{"totem_green_state01" ,"totem_green_left-eye", "totem_green_right-eye", "totem_green_mouth"}
			}
		},
		-- 3- 
		{
			contour = "screens_game_totems_green_contur_state2",
			small = "screens_game_totems_green_small_state2",
			big = "screens_game_totems_green_state2",
			-- ,        
			clips = 
			{
				--  1- 
				{"totem_green_state02" ,"totem_green_left-eye"},
				--  2- 
				{"totem_green_state02" ,"totem_green_left-eye", "totem_green_right-eye"},
				--  3- 
				{"totem_green_state02" ,"totem_green_left-eye", "totem_green_right-eye", "totem_green_mouth"}
			}
		},
		-- 4- 
		{
			contour = "screens_game_totems_green_contur_state2",
			small = "screens_game_totems_green_small_state2",
			big = "screens_game_totems_green_state2",
			-- ,        
			clips = 
			{
				--  1- 
				{"totem_green_state03" ,"totem_green_left-eye"},
				--  2- 
				{"totem_green_state03" ,"totem_green_left-eye", "totem_green_right-eye"},
				--  3- 
				{"totem_green_state03" ,"totem_green_left-eye", "totem_green_right-eye", "totem_green_mouth"}
			}
		},
		--  
		contour_pos = {180, 182},
		--   
		small_pos = {180, 182},
		-- ,       
		activation_start_pos = {178, 180},
		--     (    )
		feature_clips = {},
		--      
		delay_before_deactivate = 1400
	},
	--   
	blue_totem = 
	{
		-- 1- 
		{
			contour = "screens_game_totems_blue_contur_state1",
			small = "screens_game_totems_blue_small_state1",
			big = "screens_game_totems_blue_state1",
			-- ,        
			clips = 
			{
				--  1- 
				{"totem_blue_left-eye"},
				--  2- 
				{"totem_blue_left-eye", "totem_blue_right-eye"},
				--  3- 
				{}
			}
		},
		-- 2- 
		{
			contour = "screens_game_totems_blue_contur_state2",
			small = "screens_game_totems_blue_small_state2",
			big = "screens_game_totems_blue_state2",
			-- ,        
			clips = 
			{
				--  1- 
				{"totem_blue_left-eye"},
				--  2- 
				{"totem_blue_left-eye", "totem_blue_right-eye"},
				--  3- 
				{},
			}
		},
		-- 3- 
		{
			contour = "screens_game_totems_blue_contur_state3",
			small = "screens_game_totems_blue_small_state3",
			big = "screens_game_totems_blue_state3",
			-- ,        
			clips = 
			{
				--  1- 
				{"totem_blue_left-eye"},
				--  2- 
				{"totem_blue_left-eye", "totem_blue_right-eye"},
				--  3- 
				{"totem_blue_left-eye", "totem_blue_right-eye","totem_blue_mouth"},
			}
		},
		-- 4- 
		{
			contour = "screens_game_totems_blue_contur_state3",
			small = "screens_game_totems_blue_small_state4",
			big = "screens_game_totems_blue_state4",
			-- ,        
			clips = 
			{
				--  1- 
				{"totem_blue_left-eye"},
				--  2- 
				{"totem_blue_left-eye", "totem_blue_right-eye"},
				--  3- 
				{"totem_blue_left-eye", "totem_blue_right-eye","totem_blue_mouth"},
			}
		},
		--  
		contour_pos = {110, 7},
		--   
		small_pos = {110, 7},
		-- ,       
		activation_start_pos = {90, 9},
		--     (  -     )
		feature_clips = {"totem_blue_glow"},
		--    
		sound = "totem_blue_use01"
	},
	--   
	red_totem = 
	{
		-- 1- 
		{
			contour = "screens_game_totems_red_contur_state1",
			small = "screens_game_totems_red_small_state1",
			big = "screens_game_totems_red_state1",
			-- ,        
			clips = 
			{
				--  1- 
				{"totem_red_state01_left-eye", "totem_red_state02"},
				--  2- 
				{"totem_red_state01_left-eye", "totem_red_right_eye"},
				--  3- 
				{}
			}
		},
		-- 2- 
		{
			contour = "screens_game_totems_red_contur_state2",
			small = "screens_game_totems_red_small_state2",
			big = "screens_game_totems_red_state2",
			-- ,        
			clips = 
			{
				--  1- 
				{"totem_red_state01_left-eye","totem_red_state03_fireballs00"},
				--  2- 
				{"totem_red_state01_left-eye" ,"totem_red_state03_fireballs00", "totem_red_right_eye"},
				--  3- 
				{}
			}
		},
		-- 3- 
		{
			contour = "screens_game_totems_red_contur_state2",
			small = "screens_game_totems_red_small_state2",
			big = "screens_game_totems_red_state2",
			-- ,        
			clips = 
			{
				--  1- 
				{"totem_red_state01_left-eye","totem_red_state03_fireballs01"},
				--  2- 
				{"totem_red_state01_left-eye", "totem_red_state03_fireballs02", "totem_red_right_eye"},
				--  3- 
				{"totem_red_state01_left-eye", "totem_red_state03_fireballs02", "totem_red_right_eye", "totem_red_mouth"},
			}
		},
		-- 4- 
		{
			contour = "screens_game_totems_red_contur_state2",
			small = "screens_game_totems_red_small_state2",
			big = "screens_game_totems_red_state2",
			-- ,        
			clips = 
			{
				--  1- 
				{"totem_red_state01_left-eye","totem_red_state03_fireballs02"},
				--  2- 
				{"totem_red_state01_left-eye", "totem_red_state03_fireballs02", "totem_red_right_eye"},
				--  3- 
				{"totem_red_state01_left-eye", "totem_red_state03_fireballs02", "totem_red_right_eye", "totem_red_mouth"},
			}
		},
		--  
		contour_pos = {5, 180},
		--   
		small_pos = {5, 180},
		-- ,       
		activation_start_pos = {5, 180},
		--     (    )
		feature_clips = {},
		--    
		sound = "totem_red_use01"
	}
}

--   /    .
-- _totem -  CTotem;
-- _pos1 -  ;
-- _pos2 -  ;
-- _scale1 -  ;
-- _scale2 -  ;
-- _time -  ;
-- _delay -    ;
-- _pre_func - ,      ;
-- _post_func - ,      .
function totems.CFadeEffect(_totem, _pos1, _pos2, _scale1, _scale2, _time, _delay, _pre_func, _post_func)
	return
	{
		_totem = _totem,
		_pos1 = _pos1,
		_pos2 = _pos2,
		_scale1 = _scale1,
		_scale2 = _scale2,
		_time = _time,
		_delay = _delay,
		_pre_func = _pre_func,
		_post_func = _post_func,
		
		--   
		_start_time = _totem._timer.Get().GetTime(),
		--   
		_pos = {_pos1[1], _pos1[2]},
		--   
		_scale = {_scale1[1], _scale1[2]},
		--  ,   
		_is_dead = false,
		
		--    
		Update = function(_self)
			local dt = _self._totem._timer.Get().GetTime() - _self._start_time - _self._delay
			--     ,   
			if dt <= 0 then
				return false
			end
			--  _pre_func
			if _self._pre_func then
				_self._pre_func()
				_self._pre_func = nil
			end
			-- 
			local k = dt / _self._time
			if k > 1.0 then
				--  .   .
				_self._is_dead = true
				--  _post_func
				if _self._post_func then
					_self._post_func()
					_self._post_func = nil
				end
				return false
			end
			--  
			_self._pos[1] = _self._pos1[1] + k * (_self._pos2[1] - _self._pos1[1])
			_self._pos[2] = _self._pos1[2] + k * (_self._pos2[2] - _self._pos1[2])
			--  
			_self._scale[1] = _self._scale1[1] + k * (_self._scale2[1] - _self._scale1[1])
			_self._scale[2] = _self._scale1[2] + k * (_self._scale2[2] - _self._scale1[2])
		end,
		
		--  .
		--    .
		--    .
		--         .
		--      (  )      ,    .
		Draw = function(_self, _renderer)
			_renderer.PushState()
			_renderer.ApplyMatrix(sf.misc.MatrixTranslation(_self._totem._contour_pos[1], _self._totem._contour_pos[2]))
			_self._totem._contour.Draw(_renderer)
			_renderer.PopState()
			
			local m = sf.misc.MatrixScale(_self._scale[1], _self._scale[2])
			m = m * sf.misc.MatrixTranslation(_self._pos[1], _self._pos[2])
			_renderer.PushState()
			_renderer.ApplyMatrix(m)
			
			_self._totem._big.Draw(_renderer)
			
			if _self._totem._extra_feature then
				for _,c in ipairs(_self._totem._feature_clips) do
					c.Draw(_renderer)
				end
			end
			
			_renderer.PopState()
		end,
		
		IsDead = function(_self)
			return _self._is_dead
		end
	}
end

CWaterColorChanger = function(_totem)
	
	return
	{
		_totem = _totem,
		_water = _totem._clips[1][2],
		
		SetTargetColor = function(_self, _color, _change_time)
			_self._totem._bonus_color = _color
			_self._start_time = _self._totem._timer.Get().GetTime()
			_self._end_time = _self._totem._timer.Get().GetTime() + (_change_time or totems_widget._white_totem_options.paint_water_time)
			_self._start_color = sf.graphics.Color(_self._water.GetColor())
			_self._end_color = sf.graphics.Color(totems_widget._white_totem_options.colors_map[_color])
		end,
		
		Update = function(_self)
			if not _self._totem._bonus_color then
				return
			end			
			local t = _self._totem._timer.Get().GetTime()
			local k = 1
			if _self._end_time ~= _self._start_time then
				k = (t - _self._start_time) / (_self._end_time - _self._start_time)
			end
			if k > 1 then k = 1 end
			if k < 0 then k = 0 end
			local c = sf.graphics.Color()
			c.Alpha = _self._start_color.Alpha + (_self._end_color.Alpha - _self._start_color.Alpha) * k
			c.Red = _self._start_color.Red + (_self._end_color.Red - _self._start_color.Red) * k
			c.Green = _self._start_color.Green + (_self._end_color.Green - _self._start_color.Green) * k
			c.Blue = _self._start_color.Blue + (_self._end_color.Blue - _self._start_color.Blue) * k
			c.Clamp()
			_self._water.SetColor(c)
		end
	}
end

-- .
-- _color - .
-- _id -   .
-- _level -   . 0 -   . 1 - 1   ....
-- _timer -  -    /.
-- _extra_feature_functions -   {get, set}        (  -   ).
function totems.CTotem(_color, _id, _level, _timer, _extra_feature_functions)
	totem = 
	{
		_color = _color,
		_id = _id,
		_level = _level,
		--  . 0 -   . 1 -  . 2 -    . 3 -    .
		_state = 0,
		_timer = _timer,
		
		_extra_feature = false,
		_extra_feature_functions = _extra_feature_functions,
		
		--  
		_contour,
		--   
		_small,
		--   
		_big,
		--  ,     .   (_state)    
		_clips,
		--      
		_active_clips = {},
		--    
		_feature_clips = {},
		
		--  
		_contour_pos = {0, 0},
		--   
		_small_pos = {0, 0},
		-- -- ,       
		_activation_start_pos = {0,0},
		
		--  ,      / 
		IsFade = function(_self)
			return _self._fade_effect ~= nil
		end,
		
		--   .
		--         .
		SetState = function(_self, _state)
			_self._state = _state
			_self:_UpdateClips()
			if _self._water_changer and (_state == 1 or (_state == 2 and _self._level > 2)) and not _self._bonus_color then
				_self._water_changer:SetTargetColor(game_window.game_field.GetRandomColor(), 0)
			end
		end,
		
		--   /,      ,  
		Update = function(_self)
			if _self._fade_effect then
				_self._fade_effect:Update()
				if _self._fade_effect:IsDead() then
					_self._fade_effect = nil
				end
			end
			if _self._state > 0 then
				for _,c in ipairs(_self._active_clips) do
					c.Update()
				end
			end
			if _self._extra_feature then
				for _,c in ipairs(_self._feature_clips) do
					c.Update()
				end
			end
			if _self._water_changer then
				_self._water_changer:Update()
			end
			if _self._demonstrate_end_time then
				if _self._demonstrate_end_time <= _self._timer.Get().GetTime() then
					_self._demonstrate_end_time = nil
					if _self._active_totem then
						for _,t in pairs(totems_widget._totems) do
							t:OnMatch(_self._active_totem._color)
						end
					else
						_self:_Deactivate(0)
					end
				end
			end
		end,
		
		--  .
		--       /,       .
		Draw = function(_self, _renderer)
			if _self._fade_effect then
				_self._fade_effect:Draw(_renderer)
			else
				--  ,          
				if _self._level == 0 or _self._state > 0 then
					_renderer.PushState()
					_renderer.ApplyMatrix(sf.misc.MatrixTranslation(_self._contour_pos[1], _self._contour_pos[2]))
					_self._contour.Draw(_renderer)
					_renderer.PopState()
				end

				--   ,     .
				--    ,       .      
				--  
				if _self._level > 0 and _self._state == 0 then
					_renderer.PushState()
					_renderer.ApplyMatrix(sf.misc.MatrixTranslation(_self._small_pos[1], _self._small_pos[2]))
					_self._small.Draw(_renderer)
					_renderer.PopState()
					
					if _self._extra_feature then
						local m = sf.misc.MatrixScale(totems.params.small_scale[1], totems.params.small_scale[2])
						m = m * sf.misc.MatrixTranslation(_self._activation_start_pos[1], _self._activation_start_pos[2])
						
						_renderer.PushState()
						_renderer.ApplyMatrix(m)
						
						for _,c in ipairs(_self._feature_clips) do
							c.Draw(_renderer)
						end
						
						_renderer.PopState()
					end
				end

				--   ,   .
				--    ,       
				if _self._state > 0 then
					_self._big.Draw(_renderer)
					
					if _self._extra_feature then
						for _,c in ipairs(_self._feature_clips) do
							c.Draw(_renderer)
						end
					end
				end
			end
			
			--   ,  ,     .
			if _self._state > 0 then
				for _,c in ipairs(_self._active_clips) do
					c.Draw(_renderer)
				end
			end
		end,
		
		--   
		OnMatch = function(_self, _color)
			--    ,    
			if _self._level == 0 then
				return
			end
			--       , ...
			if _self._color == _color then
				--       ,   
				if _self._state == 0 then
					_self:_Activate()
				--      ,      
				elseif _self._state == 1 then
					_self:_Use1()
				--     ,     
				elseif _self._state == 2 then
					_self:_Use2()
				end
			else
				--      ,  
				if _self._state ~= 0 then
					_self:_Deactivate(0)
				end
			end
		end,
		
		--  
		Demonstrate = function(_self)
			if totems_widget.active_totem and totems_widget.active_totem == _self then
				return
			end
			for _,t in pairs(totems_widget._totems) do
				t._active_totem = nil
				t._demonstrate_end_time = nil
				t:OnMatch(_self._color)
			end
			_self._active_totem = totems_widget.active_totem
			_self._demonstrate_end_time = _self._timer.Get().GetTime() + totems.params.demonstrate_time
		end,
		
		--  
		_Activate = function(_self)
			-- 
			totems_widget.ActivateTotem(_self)
			--         .
			--       ""
			local post_func = function()
					_self:SetState(1)
					__sound("totem_activation")
				end
			_self._fade_effect = totems.CFadeEffect(
											_self, 
											totems.params[_self._id].activation_start_pos, {0,0},
											totems.params.small_scale, {1,1},
											totems.params.activate_time, 0,
											nil, post_func)
			if _self._water_changer then
				_self._water_changer:SetTargetColor(game_window.game_field.GetRandomColor(), 0)
			end
		end,
		
		--    
		_Use1 = function(_self)
			-- 
			avatar_widget.ChangeMood("totem_use_1")
			totems_widget.UseTotem(_self, 1)
			--     "  "
			_self:SetState(2)
			__sound("totem_activation")
			--    ,     
			__sound(_self._sound)
			--       3,    
			if _self._level <= 2 then
				_self:_Deactivate(_self._delay_before_deactivate)
			else
				if _self._water_changer then
					_self._water_changer:SetTargetColor(game_window.game_field.GetRandomColor())
				end
			end
		end,
		
		--    
		_Use2 = function(_self)
			avatar_widget.ChangeMood("totem_use_2")
			-- 
			totems_widget.UseTotem(_self, 2)
			--     "  "
			_self:SetState(3)
			__sound("totem_activation")
			--    
			__sound(_self._sound)
			--          ,   
			if not _self._extra_feature and #_self._feature_clips > 0 then
				_self._extra_feature = true
				
				--   
				for _,c in ipairs(_self._feature_clips) do
					c.Stop()
					c.Play()
				end
				
				--       true
				if _self._extra_feature_functions then
					_self._extra_feature_functions.set(true)
				end
			end
			--    
			_self:_Deactivate(_self._delay_before_deactivate)
		end,
		
		--  
		_Deactivate = function(_self, _delay)
			-- 
			totems_widget.DeactivateTotem(_self)
			--           .
			--        " "
			local pre_func = function()
					_self:SetState(0)
				end
			_self._fade_effect = totems.CFadeEffect(
										_self, 
										{0,0}, totems.params[_self._id].activation_start_pos,
										{1,1}, totems.params.small_scale,
										totems.params.deactivate_time, _delay,
										pre_func)
		end,
		
		--            
		_UpdateClips = function(_self)
			--    .
			--    ,     .
			local active_clips = {}
			--   , ...
			if _self._state > 0 then
				--       
				for _,c in ipairs(_self._clips[_self._state]) do
					--       ,   ,    0  .
					--       .
					--     ,        ,  .
					local new_clip = true
					for _,ac in ipairs(_self._active_clips) do
						if ac == c then
							table.insert(active_clips, c)
							new_clip = false
							break
						end
					end
					if new_clip then
						c.Stop()
						c.Play()
						table.insert(active_clips, c)
					end
				end
			end
			_self._active_clips = active_clips
		end
	}
	
	--   .
	
	--  
	local rm = g_App.GetResourceManager()
		
	--     ,      .
	if _level == 0 then
		totem._contour =  sf.graphics.CImage(totems.params[_id][1].contour)
		totem._contour_pos = totems.params[_id].contour_pos
	else
		--  
		local params = totems.params[_id][_level]
		
		--  
		-- 
		totem._contour = sf.graphics.CImage(params.contour)
		--  
		totem._small = sf.graphics.CImage(params.small)
		--  
		totem._big = sf.graphics.CImage(params.big)
		
		--  
		totem._clips = {}
		
		local clips = {}
		
		--   2 ,      (,   ,   ).
		--       .
		for i=1,3 do
			totem._clips[i] = {}
			if params.clips and params.clips[i] then
				for _,clip_id in ipairs(params.clips[i]) do
					local clip = clips[clip_id]
					--        ,   ,        .
					--       ,        ,    , 
					--   
					if not clip then
						clip = sf.misc.anim.CClip()
						clip.Load(clip_id, true)
						clip.SetPos(sf.misc.FloatVector(totems.params.center[1], totems.params.center[2]))
						clips[clip_id] = clip
					end
					table.insert(totem._clips[i], clip)
				end
			end
		end
		
		--    
		totem._feature_clips = {}
		if totems.params[_id].feature_clips then
			for _,clip_id in ipairs(totems.params[_id].feature_clips) do
				local clip = sf.misc.anim.CClip()
				clip.Load(clip_id, true)
				clip.SetPos(sf.misc.FloatVector(totems.params.center[1], totems.params.center[2]))
				table.insert(totem._feature_clips, clip)
			end
		end
		
		totem._contour_pos = totems.params[_id].contour_pos
		totem._small_pos = totems.params[_id].small_pos
		totem._activation_start_pos = totems.params[_id].activation_start_pos
		
		--      
		if totem._extra_feature_functions then
			totem._extra_feature = totem._extra_feature_functions.get()
		end
		
		totem._sound = totems.params[_id].sound
		totem._delay_before_deactivate = totems.params[_id].delay_before_deactivate or totems.params.delay_before_deactivate
		
		if _id == "white_totem" then
			totem._water_changer = CWaterColorChanger(totem)
		end
	end
	
	return totem
end
