--        
help_window = help_window or {}
help_window.actions = help_window.actions or {}
help_window.object = nil

function help_window.Show(_window)
	local dialog = sf.gui.CWindow()
	dialog.Load(g_App.GetSettings().GetChild("GUI", false).GetChildByAttribute("window", "id", "help_window", true),
		g_App.GetSettings().GetChild("GUITemplates", false))

	dialog.UpdateLayout()
	dialog.SetOffset(0,0)

	help_window._buttons = {}
	help_window._buttons["page1_button"] = get_child_widget(dialog, "page1_button", sf.gui.CButtonWidget, "" )
	help_window._buttons["page2_button"] = get_child_widget(dialog, "page2_button", sf.gui.CButtonWidget, "" )

	help_window._levels_tab_list = get_child_widget(dialog, "levels_tab_list", sf.gui.CTabWidget, "" )
	
	help_window._buttons["page1_button"].DisableButton(true)
	
	--   
	s11.AddShowEffectToWidget(dialog, misc.hide_window_delay, misc.show_window_delay, misc.shift_before_hide, _window)
	
	help_window._parent = _window
	help_window._self = dialog
    _window.AddChildWindow(dialog)
	if game_background then
		game_background.Init()
		game_background.SetUseClip(false)
	end
end

function help_window.DoDraw(_this, _renderer) 
	if game_background then
		game_background.Draw(_renderer)
	end
    return false 
end

function help_window.DoUpdate(_this) 
	if game_background then
		game_background.Update()
	end
	if hog_widget.IsCompleted() then
		_this.AddFlags(_this.FlagDead)
	end
	return false 
end

function help_window.OnChar(_this, _char, _keyboard_state, _state, _broadcast)
	return _this.SuperOnChar(_char, _keyboard_state, _state, _broadcast)
end

function help_window.OnKeyDown(_this, _key, _keyboard_state, _state, _broadcast)
    return false
end

function help_window.OnKeyUp(_this, _key, _keyboard_state, _state, _broadcast)
	return _this.SuperOnKeyUp( _key, _keyboard_state, _state, _broadcast)
end

function help_window.OnMouseMove(_this, _pos, _state, _broadcast)
	return _this.SuperOnMouseMove(_pos, _state, _broadcast) 
end

function help_window.OnMouseDown(_this, _pos, _button, _state, _broadcast)
	return _this.SuperOnMouseDown( _pos, _button, _state, _broadcast) 
end

function help_window.OnMouseUp(_this, _pos, _button, _state, _broadcast)
	return _this.SuperOnMouseUp( _pos, _button, _state, _broadcast) 
end

function help_window.OnDoubleClick(_this, _pos, _state, _broadcast)
	return _this.SuperOnDoubleClick( _pos, _state, _broadcast) 
end

function help_window.OnMouseWheel(_this, _pos, _delta, _state, _broadcast)
	return _this.SuperOnMouseWheel( _pos, _delta, _state, _broadcast)
end

function help_window.OnChildAction(_this, _action, _child)
	if not _child then return end
	local handler = help_window.actions[_child.GetId().c_str()]
	if handler then handler = handler[_action.c_str()] end
	if handler then handler(_this, _child) end
end

help_window.actions.ok_button = 
{
	pressed = function(_window) 
		s11.AddHideEffectToWidget(help_window._self, 300, 300, 300, help_window._parent)
	end
}

help_window.actions.page1_button = 
{
	pressed = function(_window) 
		help_window._buttons["page1_button"].DisableButton(true)
		help_window._buttons["page2_button"].DisableButton(false)
		help_window._levels_tab_list.SelectPanel(0)
	end
}

help_window.actions.page2_button = 
{
	pressed = function(_window) 
		help_window._buttons["page2_button"].DisableButton(true)
		help_window._buttons["page1_button"].DisableButton(false)
		help_window._levels_tab_list.SelectPanel(1)
	end
}

help_window.actions.credits_button = 
{
	pressed = function(_window) 
		credits_window_dialog.Show(_window)
	end
}
