hog_menu_window = hog_menu_window or {}
hog_menu_window.actions = hog_menu_window.actions or {}

function hog_menu_window.Show(_window)
	hog_window.SetStopTime(true)
	local dialog = sf.gui.CWindow()
	dialog.Load(g_App.GetSettings().GetChild("GUI", false).GetChildByAttribute("window", "id", "hog_menu_window", true),
		g_App.GetSettings().GetChild("GUITemplates", false))
	dialog.UpdateLayout()
	dialog.SetOffset((_window.GetSize().X - dialog.GetSize().X)/2, (_window.GetSize().Y - dialog.GetSize().Y)/2)

    _window.AddChildWindow(dialog)
end

function hog_menu_window.DoDraw(_this, _renderer) 
    return false 
end

function hog_menu_window.DoUpdate(_this) 
    return false 
end

function hog_menu_window.OnChar(_this, _char, _keyboard_state, _state, _broadcast)
	return _this.SuperOnChar(_char, _keyboard_state, _state, _broadcast)
end

function hog_menu_window.OnKeyDown(_this, _key, _keyboard_state, _state, _broadcast)
    if _key == 27 then
		hog_menu_window._ResumeGame(_this)
		return true
	end
    return _this.SuperOnKeyDown( _key, _keyboard_state, _state, _broadcast)
end

function hog_menu_window.OnKeyUp(_this, _key, _keyboard_state, _state, _broadcast)
	return _this.SuperOnKeyUp( _key, _keyboard_state, _state, _broadcast)
end

function hog_menu_window.OnMouseMove(_this, _pos, _state, _broadcast)
	return _this.SuperOnMouseMove(_pos, _state, _broadcast) 
end

function hog_menu_window.OnMouseDown(_this, _pos, _button, _state, _broadcast)
	return _this.SuperOnMouseDown( _pos, _button, _state, _broadcast) 
end

function hog_menu_window.OnMouseUp(_this, _pos, _button, _state, _broadcast)
	return _this.SuperOnMouseUp( _pos, _button, _state, _broadcast) 
end

function hog_menu_window.OnDoubleClick(_this, _pos, _state, _broadcast)
	return _this.SuperOnDoubleClick( _pos, _state, _broadcast) 
end

function hog_menu_window.OnMouseWheel(_this, _pos, _delta, _state, _broadcast)
	return _this.SuperOnMouseWheel( _pos, _delta, _state, _broadcast)
end

function hog_menu_window.OnChildAction(_this, _action, _child)
	if not _child then return end
	local handler = hog_menu_window.actions[_child.GetId().c_str()]
	if handler then handler = handler[_action.c_str()] end
	if handler then handler(_this, _child) end
end

function hog_menu_window._ResumeGame(_window)
	hog_window.SetStopTime(false)
	_window.AddFlags(_window.FlagDead)
end

hog_menu_window.actions.resume_button = 
{
	pressed = function(_window) 
		hog_menu_window._ResumeGame(_window)
	end
}

hog_menu_window.actions.map_button = 
{
	pressed = function(_window) 
		hog_window.SaveGame()
		map_window.Show()
	end
}

hog_menu_window.actions.menu_button = 
{
	pressed = function(_window) 
		hog_window.SaveGame()
		main_menu.Show()
	end
}

hog_menu_window.actions.replay_button = 
{
	pressed = function(_window) 
		if dialog_do_modal("restart_dialog", _window) == 1 then
			hog_window.Replay()
		end
	end
}

hog_menu_window.actions.options_button = 
{
	pressed = function(_window) 
        options_window_dialog.Show(_window)
	end
}

