--         
hog_stat_window = {}
hog_stat_window._actions = {}

function hog_stat_window.get_scores()
	return hog_stat_window._scores
end

--      
hog_stat_window.effects_params = 
{
	default = 
	{
		delay = 0,
		duration = 300
	},
	items = 
	{
		{
			widgets = 
			{ 
				{ id = "label_score_text" }, 
			},
			delay = 70,
			particle = "StatLabelTextEffect"
		},
		{
			widgets = 
			{ 
				{ id = "score_label", counter = {max_value = hog_stat_window.get_scores, str_format = "%i"} } 
			},
			delay = 300,
			particle = "StatLabelEffect"
		},
		
		{
			widgets = 
			{
				{ id = "time_label_text" }
			},
			delay = 70,
			particle = "StatLabelTextEffect"
		},
		
		{
			widgets = 
			{
				{ id = "accuracy_label_text" }
			},
			delay = 70,
			particle = "StatLabelTextEffect"
		},
		
		
		{
			widgets = 
			{
				{ id = "time_label" }
			},
			delay = 70,
			particle = "StatLabelEffect"
		},

		{
			widgets = 
			{
				{ id = "accuracy_label" }
			},
			delay = 70,
			particle = "StatLabelEffect"
		},


		{
			widgets = 
			{
				{ id = "prize_clip" }
			},
			delay = 70,
			particle = "StatLabelEffect"
		},
		
     	{
			widgets = 
			{
				{ id = "achievements_button" },
			},
			delay = 600,
			particle = "StatLabelTextAchEffect",
		},
		
		{
			widgets = 
			{
				{ id = "replay_button" },
				{ id = "ok_button" }
			}
		}
	}
}

--     
hog_stat_window._actions.ok_button = 
{
	pressed = function(_window) 
		hog_window.FinishHog()
	end
}

--     
hog_stat_window._actions.replay_button = 
{
	pressed = function(_window) 
		hog_window.Replay()
	end
}

hog_stat_window._actions.achievements_button = 
{
	pressed = function(_window) 
		achievements_window.Show(_window)
	end
}

function hog_stat_window.Show(_window)
	--   
	local dialog = sf.gui.CWindow()
	dialog.Load(g_App.GetSettings().GetChild("GUI", false).GetChildByAttribute("window", "id", "hog_stat_window", true),
		g_App.GetSettings().GetChild("GUITemplates", false))
	dialog.UpdateLayout()
	
	local prize_clip = get_child_widget(dialog, "prize_clip", sf.gui.CClipWidget, "" )
	prize_clip.GetClip().Load(tostring(hog_window.level.GetPrizeImage()), true) 
	
	local accuracy_label = get_child_widget(dialog, "accuracy_label", sf.gui.CLabelWidget, "" )
	local moves_count = hog_widget.GetMovesCount()
	local clicks_count = hog_widget.GetTotalClickCount()
	local acc_text = "100 %"
	if moves_count > 0 and clicks_count > 0 then
		acc_text = s11.StringFormat("%.2i", (moves_count/clicks_count)*100).."%"
	end
	accuracy_label.SetText(acc_text)
	
	local time_label = get_child_widget(dialog, "time_label", sf.gui.CLabelWidget, "" )
	time_label.SetText(TimeToString(hog_window.GetLeveltime()))
	
	local ach_rec_count = hog_window.GetAchievementsCount()
	local ach_recived_count = get_child_widget(dialog, "achievements_button", sf.gui.CButtonWidget, "" )
	ach_recived_count.SetText(s11.StringFormat(ach_recived_count.GetText(), ach_rec_count))
	
	if ach_rec_count == 0 then
		__visible(ach_recived_count, false)
	end
	
	hog_stat_window._scores = hog_window.GetPrizePoints()
	stat_effects.Init(dialog, hog_stat_window.effects_params)
	
	--  
	dialog.SetOffset((_window.GetSize().X - dialog.GetSize().X)/2, (_window.GetSize().Y - dialog.GetSize().Y)/2)

	s11.g_TrackManager.Instance().UpdateCurrentTrack("town_map", false)
	
	__AddStatShoweffect(dialog)
	--  
    _window.AddChildWindow(dialog)

	if hog_window._ach_hog_in_a_minet then
		achievements.GetAchievement("hog_for_one_minute")
	end

end

function hog_stat_window.DoDraw(_this, _renderer) 
    return false 
end

function hog_stat_window.DoUpdate(_this) 
	stat_effects.Update()
    return false 
end

function hog_stat_window.OnChar(_this, _char, _keyboard_state, _state, _broadcast)
	return _this.SuperOnChar(_char, _keyboard_state, _state, _broadcast)
end

function hog_stat_window.OnKeyDown(_this, _key, _keyboard_state, _state, _broadcast)
    return _this.SuperOnKeyDown( _key, _keyboard_state, _state, _broadcast)
end

function hog_stat_window.OnKeyUp(_this, _key, _keyboard_state, _state, _broadcast)
	return _this.SuperOnKeyUp( _key, _keyboard_state, _state, _broadcast)
end

function hog_stat_window.OnMouseMove(_this, _pos, _state, _broadcast)
	return _this.SuperOnMouseMove(_pos, _state, _broadcast) 
end

function hog_stat_window.OnMouseDown(_this, _pos, _button, _state, _broadcast)
	stat_effects.End()
	return _this.SuperOnMouseDown( _pos, _button, _state, _broadcast) 
end

function hog_stat_window.OnMouseUp(_this, _pos, _button, _state, _broadcast)
	return _this.SuperOnMouseUp( _pos, _button, _state, _broadcast) 
end

function hog_stat_window.OnDoubleClick(_this, _pos, _state, _broadcast)
	return _this.SuperOnDoubleClick( _pos, _state, _broadcast) 
end

function hog_stat_window.OnMouseWheel(_this, _pos, _delta, _state, _broadcast)
	return _this.SuperOnMouseWheel( _pos, _delta, _state, _broadcast)
end

function hog_stat_window.OnChildAction(_this, _action, _child)
	if not _child then return end
	local handler = hog_stat_window._actions[_child.GetId().c_str()]
	if handler then handler = handler[_action.c_str()] end
	if handler then handler(_this, _child) end
end
