---     
hog_window = {}

hog_window._actions = {}

hog_window.level_name_id = sf.misc.g_StringTable.Instance().FormatByStringsID("$8")
hog_window.bonus_level_postfix_id = sf.misc.g_StringTable.Instance().FormatByStringsID("$280")

hog_window._hint_resume_time = 900   --   
hog_window._hint_button_resume_image = "TEMP_shader_circle"    --     

hog_window.level_name_clip = "start_level"
hog_window.level_name_clip_pos = sf.misc.FloatVector(512, 384)

hog_window.level_time = 0
hog_window.achievements_count = 0
hog_window.stop_time = false

function hog_window.GetPrizePoints()
	return hog_window.level.GetPrizePoints()
end

function hog_window.SetStopTime(_value)
	hog_window.stop_time = _value
end

function hog_window.GetLeveltime()
	return hog_window.level_time
end

function hog_window.GetAchievementsCount()
	return hog_window.achievements_count
end

--    
hog_window._actions.menu_button = 
{
	pressed = function(_window) 
		hog_menu_window.Show(hog_window._self)
	end
}

--   
hog_window._actions.hog_hint_button = 
{
	pressed = function(_window) 
		hog_widget.GetHint()
		--    
		hint_button.StartHintButtonResume()
		hog_window._time_for_resume_hit = hog_window._hint_resume_time
	end
}

--       
function hog_window.FinishHog()
	--     
	local level_progress_info = hog_window.profile_data.GetLevelProgress(hog_window._current_game_dif_level, hog_window._current_game_level_index)
	level_progress_info.SetFinished(true)
	hog_window.profile_data.SetLevelProgress(hog_window._current_game_dif_level, hog_window._current_game_level_index, level_progress_info)
	hog_window.profile_data.AddScore(hog_window.GetPrizePoints())
	hog_window.profile_data.DropSavedLevelInfo()
	hog_window.profile_data.CreateTownSnapshot()
	hog_window.profile.SaveGameType(s11.CGameStruct.GameTypeClassic)
	--   
	map_window.Show()
end

function hog_window.SaveHogParams(xml_element)
	xml_element.Attr("level_time", tostring(hog_window.level_time) )
	
	xml_element.Attr("moves_count", tostring(hog_widget.GetMovesCount()) )
	xml_element.Attr("total_click_count", tostring(hog_widget.GetTotalClickCount()) )
	

	xml_element.Attr("achievements_count", "0" )
end

function hog_window.SaveGame()


	save_game.SaveLevelInfo(hog_window._save_file_name, hog_window.SaveHogParams)
end

function hog_window.LoadHogParams(group_info)

	hog_window.level_time = tonumber(group_info.GetValue("level_time").c_str())
	
	hog_widget.SetMovesCount(tonumber(group_info.GetValue("moves_count").c_str()))
	hog_widget.SetTotalClickCount(tonumber(group_info.GetValue("total_click_count").c_str()))
	

	hog_window.achievements_count = tonumber(group_info.GetValue("achievements_count").c_str())
end

function hog_window.LoadGame()
	save_game.Load(hog_window._save_file_name, hog_window.LoadHogParams)
end

function hog_window.Replay()
	hog_window.Show(hog_window._current_game_dif_level, hog_window._current_game_level_index, false, true)
end

--   
function hog_window.Show(_dif_level, _level_index, _load, _no_effect)
	local window = __ChangeWindowWithEffect(_no_effect)
	if not window then
		return
	end
	hog_window.achievements_count = 0
	hog_window._ach_hog_in_a_minet = nil
	
	game_time_counter.Init()
	hog_window.stop_time = false
	
	hog_window._time_achievement = not achievements.IsCompleted("hog_for_one_minute")
	
	hog_window.profile = s11.g_ProfileManager.Instance().GetCurrentProfile()
	hog_window._save_file_name = s11.g_ProfileManager.Instance().GetSavesFolder().."\\"..hog_window.profile.GetGUID().."_hog.sav"
	
	hog_window.profile_data = hog_window.profile.GetClassicData()
	hog_window._tutorial_flags = hog_window.profile_data.GetTutorialFlags()
	
	hog_window._first_run_tutorial = not hog_window._tutorial_flags.ReadFlag(s11.CProfileDataClassic.TutorialFlagFirstHog)

	local hog_info = g_App.GetSettings().GetChild("Constants", false).GetChildRef("hog_options", false)
	if hog_info then
		hog_window._hint_resume_time = tonumber(hog_info.GetValue("hint_resume_time").c_str()) or hog_window._hint_resume_time
		hog_window._hint_button_resume_image = hog_info.GetValue("hint_resume_image") or hog_window._hint_button_resume_image
	end

	hog_window._hog_timer = sf.core.CTimerWrapper(sf.core.g_Application.GetTimeManager().GetTimer("game_timer").AttachTimer(""))
	--          
	hog_window._finished = nil
	
	hog_window._hint_show_delay = 0
	
	--     
	hog_window._current_game_dif_level = _dif_level
	hog_window._current_game_level_index = _level_index

	--       
	local level = s11.g_GameStruct.Instance().GetLevelsSystem(s11.CGameStruct.GameTypeClassic).GetLevel(_dif_level, _level_index)
	if not level then 
		__message("Hog window. Unknown level")
		return 
	end
	local chapter_index = level.GetChapterIndex()
	local level_index_in_chapter = level.GetLevelIndexInChapter()

	hog_window.level_name = s11.StringFormat(hog_window.level_name_id, chapter_index + 1, level_index_in_chapter + 1) .."\n"..hog_window.bonus_level_postfix_id
	
	--       -  
	local hog_level = __cast(level, s11.CHogLevelInfo)
	if not hog_level then
		__message("Hog window. Wrong level type")
		return
	end
	
	hog_window.level = hog_level

	window.Load(
		g_App.GetSettings().GetChild("GUI", false).GetChildByAttribute("window", "id", "hog_window", true), 
		g_App.GetSettings().GetChild("GUITemplates", false))

	hog_window._self = window
		
	--   
	hog_window.StartScene()
	if _load then
		hog_window.LoadGame()
	else
		hog_window.level_time = 0
		hog_widget.SetMovesCount(0)
		hog_widget.SetTotalClickCount(0)
		
	
		hog_window.profile_data.SetSavedLevelDifficulty(_dif_level)
		hog_window.profile_data.SetSavedLevelIndex(_level_index)
		hog_window.SaveGame()
	end
	
	hog_widget.InitHog()
	window.UpdateLayout()
	
	window.SetOffset(0, 0)
	
	--     ,    
	hog_window._hint_button_widget = get_child_widget(window, "hog_hint_button", sf.gui.CButtonWidget)
	if not hog_window._hint_button_widget then
		__message("Button hint_button not found")
		return
	end
	
	--   hint    
	hint_button.FormHintButton(hog_window._hint_button_widget, hog_window._hint_button_resume_image)

	s11.g_TrackManager.Instance().UpdateCurrentTrack("hog", false)
	s11.g_GameBackground.Instance().DisableSounds(false)
	
	hog_window.OnShowWindow = function ()
		if hog_window._first_run_tutorial then
			hog_window._first_run_tutorial = false
			--     hog 
			hog_window._tutorial_flags.RaiseFlag(s11.CProfileDataClassic.TutorialFlagFirstHog)
			dialog_do_modal("hog_hint_dialog", hog_window._self)
		end
		hog_gui_effects.CreateStatrLevelClip(hog_window.level_name)
	
	end
	
	if _no_effect then
		g_App.SetMainWindow(window)
	end
	
	window = 0
	collectgarbage()
end

function hog_window.StartScene()
	local scene_widget = get_child_widget(hog_window._self, "hog_scene_widget", qe.CSceneWidget) 
	if scene_widget then
		quest.StartScene(hog_window._self, scene_widget, 
			tostring(hog_window.level.GetLevelId()), tostring(hog_window.level.GetSceneId()))
	else
		__message("scene widget for hog not found: hog_scene_widget")
		return
	end
    return false 
end

function hog_window.DoDraw(_this, _renderer) 
    return false 
end

function hog_window.DoUpdate(_this) 

	if hog_window.OnShowWindow then
		if not s11.WindowHasEffects(hog_window._self) then
			local show_func = hog_window.OnShowWindow
			hog_window.OnShowWindow = nil
			show_func()
		end
	end

	local frame_delta = hog_window._hog_timer.Get().GetFrameDelta()
	
	game_time_counter.AddGameTime(frame_delta)

	if hint_button.IsHintButtonDisabled() then
		hog_window._time_for_resume_hit = hog_window._time_for_resume_hit - frame_delta
		--   ,     
		local progress_time = 1 - hog_window._time_for_resume_hit/hog_window._hint_resume_time
		--    
		hint_button.UpdateHintButton(progress_time)
	end	
	if not hog_window.stop_time then
		hog_window.level_time = hog_window.level_time + frame_delta
	end
	
	--   
	quest.Update()
	
	--     
	if not hog_window._finished and hog_widget.IsCompleted() then
		--  ,     
		hog_window.WinHog()
	end
	return false 
end

function hog_window.WinHog()
	if hog_window._time_achievement and hog_window.GetLeveltime() < 60000 then
		
		hog_window._ach_hog_in_a_minet = true
		
		hog_window.achievements_count = hog_window.achievements_count + 1
	end
	hog_window._finished = true
	hog_stat_window.Show(hog_window._self)
end

function hog_window.OnChar(_this, _char, _keyboard_state, _state, _broadcast)
	return _this.SuperOnChar(_char, _keyboard_state, _state, _broadcast)
end

function hog_window.OnKeyDown(_this, _key, _keyboard_state, _state, _broadcast)
	--    
	if sf.core.g_Application.GetDebugLevel() >= sf.core.g_Application.DebugCheats then
		--      F5
		if _key == 116 then
			hog_window.WinHog()
			--hog_stat_window.Show(_this)
		end
	end
	
	if _this.SuperOnKeyDown( _key, _keyboard_state, _state, _broadcast) then
		return true
	end
	
	if _key == 27 then
		hog_menu_window.Show(hog_window._self)
		return true
	end
	
	return false
end

function hog_window.OnKeyUp(_this, _key, _keyboard_state, _state, _broadcast)
	return _this.SuperOnKeyUp( _key, _keyboard_state, _state, _broadcast)
end

function hog_window.OnMouseMove(_this, _pos, _state, _broadcast)
	return _this.SuperOnMouseMove(_pos, _state, _broadcast) 
end

function hog_window.OnMouseDown(_this, _pos, _button, _state, _broadcast)
	return _this.SuperOnMouseDown( _pos, _button, _state, _broadcast) 
end

function hog_window.OnMouseUp(_this, _pos, _button, _state, _broadcast)
	return _this.SuperOnMouseUp( _pos, _button, _state, _broadcast) 
end

function hog_window.OnDoubleClick(_this, _pos, _state, _broadcast)
	return _this.SuperOnDoubleClick( _pos, _state, _broadcast) 
end

function hog_window.OnMouseWheel(_this, _pos, _delta, _state, _broadcast)
	return _this.SuperOnMouseWheel( _pos, _delta, _state, _broadcast)
end

function hog_window.OnChildAction(_this, _action, _child)
	if not _child then return end
	local handler = hog_window._actions[_child.GetId().c_str()]
	if handler then handler = handler[_action.c_str()] end
	if handler then handler(_this, _child) end
end
