options_window_dialog = {}
options_window_dialog._actions = {}

function options_window_dialog.Show(_window)
    local app = sf.core.g_Application			
	local dialog = sf.gui.CWindow()
	dialog.Load(g_App.GetSettings().GetChild("GUI", false).GetChildByAttribute("window", "id", "options_window", true),
		g_App.GetSettings().GetChild("GUITemplates", false))

	dialog.UpdateLayout()
    local parent_window_size = _window.GetSize()
	dialog.SetOffset((parent_window_size.X - dialog.GetSize().X)/2, (parent_window_size.Y - dialog.GetSize().Y)/2)
	_window.AddChildWindow(dialog)

	options_window.InitOptionsWindow(dialog)	

end

function options_window_dialog.DoDraw(_this, _renderer)
end

function options_window_dialog.DoUpdate(_this)
end

function options_window_dialog.OnChar(_this, _char, _keyboard_state, _state, _broadcast)
	return _this.SuperOnChar(_char, _keyboard_state, _state, _broadcast)
end

function options_window_dialog.OnKeyDown(_this, _key, _keyboard_state, _state, _broadcast)
	if _this.SuperOnKeyDown( _key, _keyboard_state, _state, _broadcast) then
      return true
    end
    return false
end

function options_window_dialog.OnKeyUp(_this, _key, _keyboard_state, _state, _broadcast)
	return _this.SuperOnKeyUp( _key, _keyboard_state, _state, _broadcast)
end

function options_window_dialog.OnMouseMove(_this, _pos, _state, _broadcast)
	return _this.SuperOnMouseMove( _pos, _state, _broadcast) 
end

function options_window_dialog.OnMouseDown(_this, _pos, _button, _state, _broadcast)
	return _this.SuperOnMouseDown( _pos, _button, _state, _broadcast) 
end

function options_window_dialog.OnMouseUp(_this, _pos, _button, _state, _broadcast)
	return _this.SuperOnMouseUp( _pos, _button, _state, _broadcast) 
end

function options_window_dialog.OnDoubleClick(_this, _pos, _state, _broadcast)
	return _this.SuperOnDoubleClick( _pos, _state, _broadcast) 
end

function options_window_dialog.OnMouseWheel(_this, _pos, _delta, _state, _broadcast)
	return _this.SuperOnMouseWheel( _pos, _delta, _state, _broadcast)
end

function options_window_dialog.OnChildAction(_this, _action, _child)
	if not _child then return end
	local handler = options_window_dialog._actions[_child.GetId().c_str()]
	if handler then handler = handler[_action.c_str()] end
	if handler then handler(_this, _child) end
    if _action.c_str() == "value_changed" then
        if options_window._sliders_params[_child.GetId().c_str()] then
            local slider_value = options_window._GetSliderValue(_child.GetId().c_str())
            local current_set_function = options_window._sliders_params[_child.GetId().c_str()].set_function
            if current_set_function then
                current_set_function(slider_value)
            end
        end

    elseif _action.c_str() == "check_changed" then
        if options_window._checkbox_params[_child.GetId().c_str()] then
            local checkbox_widget = options_window._checkbox_params[_child.GetId().c_str()].widget
            if checkbox_widget then
                local checkbox_value = checkbox_widget.IsChecked()
                local set_fun = options_window._checkbox_params[_child.GetId().c_str()].set_function
                if set_fun then
                    set_fun(checkbox_value)
                    options_window._FillWidgets()
                end
            end
        end
    end
end
	
options_window_dialog._actions.ok = 
{
	pressed = function(_window) 
        options_window.ApplyChanges()
		_window.AddFlags(_window.FlagDead)
	end
}

options_window_dialog._actions.cancel = 
{
	pressed = function(_window) 
        options_window.Restore()
		_window.AddFlags(_window.FlagDead)
	end
}

options_window_dialog._actions.credits = 
{
	pressed = function(_window) 
        dialog_do_modal("credits_dialog", _window, true)
	end
}

------------------------------------------------------------------

options_window = {}

options_window._sliders_params = {}

options_window._sliders_params["sound_volume_slider"] = {
	widget = false,
	min_value = 0,
	max_value = 100,
	get_function = function () 
				       return s11.g_GameOptions.Instance().GetSoundVolume()
				   end,

	set_function = function (_value) 
				       s11.g_GameOptions.Instance().SetSoundVolume(_value) 
	                   s11.g_GameOptions.Instance().ApplyMusicChanges()
                   end
}
                               
options_window._sliders_params["music_volume_slider"] = {
	widget = false,
	min_value = 0, 
	max_value = 100,
	get_function = function ()
				       return s11.g_GameOptions.Instance().GetMusicVolume()
	               end,
	set_function = function (_value)
		               s11.g_GameOptions.Instance().SetMusicVolume(_value) 
		               s11.g_GameOptions.Instance().ApplyMusicChanges()
	               end
}

-----------------------------

options_window._checkbox_params = {}

options_window._checkbox_params["full_screen_checkbox"] = {

	widget = false,
	get_function = function ()
				       return s11.g_GameOptions.Instance().GetFullScreenMode()
                   end,
    set_function = function (_value) 
	                   s11.g_GameOptions.Instance().SetFullScreenMode(_value)
	                   s11.g_GameOptions.Instance().ApplyOptionsChanges()
                   end
}

options_window._checkbox_params["custom_cursors_checkbox"] = {

	widget = false,
	get_function = function ()
				       return s11.g_GameOptions.Instance().GetUseCustomCursors()
                   end,
    set_function = function (_value) 
	                   s11.g_GameOptions.Instance().SetUseCustomCursors(_value)
					   s11.g_GameOptions.Instance().ApplyOptionsChanges()
                   end
}
--------------------------

function options_window._SetSliderValue(_slider_id, _value)
	local current_silder = options_window._sliders_params[_slider_id]
	if not current_silder then
		__message("options for slider ".._slider_id.." not found")
		return
	end
	local diver = (current_silder.max_value - current_silder.min_value)
	if math.abs(diver) <= 0.0001 then
		__message("Wrong slider options for slider ".._slider_id)
		return
	end
	if not current_silder.widget then
		__message("widget for slider ".._slider_id.." not found")
	end
	current_silder.widget.SetValue((_value-current_silder.min_value)/diver, false)		
end

function options_window._GetSliderValue(_slider_id)
	local current_silder = options_window._sliders_params[_slider_id]
	if not current_silder then 
		return 0 
	end
	local slider_value = 0
	if current_silder.widget then
		slider_value = current_silder.widget.GetValue()		
	end
	local res = current_silder.min_value + (current_silder.max_value - current_silder.min_value)*slider_value
	return res
end

function options_window._FillWidgets()
	for slider_id in pairs(options_window._sliders_params) do
		local current_get_fun = options_window._sliders_params[slider_id].get_function
		if current_get_fun then
			options_window._SetSliderValue(slider_id, current_get_fun())
		end
	end
	for checkbox_id in pairs(options_window._checkbox_params) do
		local current_get_fun = options_window._checkbox_params[checkbox_id].get_function
		if current_get_fun then
			local current_widget = options_window._checkbox_params[checkbox_id].widget
			if current_widget then
				current_widget.Check(current_get_fun(), false)
			end
		end
	end
end

function options_window.InitOptionsWindow(_owner)
	for slider_id in pairs(options_window._sliders_params) do
		options_window._sliders_params[slider_id].widget = 
			__cast(_owner.GetWidget(slider_id, true).get(), "sf.gui.CSliderWidget")
	end

	for checkbox_id in pairs(options_window._checkbox_params) do
		options_window._checkbox_params[checkbox_id].widget = 
			__cast(_owner.GetWidget(checkbox_id, true).get(), "sf.gui.CCheckboxWidget")
	end
	options_window._FillWidgets()
end

function options_window.ApplyChanges()
	s11.g_GameOptions.Instance().UpdateLocalSettings()
	local res = s11.g_GameOptions.Instance().ApplyOptionsChanges();
	s11.g_GameOptions.Instance().Save()
end

function options_window.Restore()
	s11.g_GameOptions.Instance().RestoreOptions()
	s11.g_GameOptions.Instance().Save()
end
