--    
puzzle_lose_window = {}
puzzle_lose_window.actions = {}

function puzzle_lose_window.Show(_window)
	local dialog = sf.gui.CWindow()
	dialog.Load(g_App.GetSettings().GetChild("GUI", false).GetChildByAttribute("window", "id", "puzzle_lose_window", true),
		g_App.GetSettings().GetChild("GUITemplates", false))
	dialog.UpdateLayout()
	
	dialog.SetOffset((_window.GetSize().X - dialog.GetSize().X)/2, (_window.GetSize().Y - dialog.GetSize().Y)/2)

	s11.g_TrackManager.Instance().UpdateCurrentTrack("town_map", false)
	
    _window.AddChildWindow(dialog)
end

function puzzle_lose_window.DoDraw(_this, _renderer) 
    return false 
end

function puzzle_lose_window.DoUpdate(_this) 
    return false 
end


function puzzle_lose_window.OnChar(_this, _char, _keyboard_state, _state, _broadcast)
	return _this.SuperOnChar(_char, _keyboard_state, _state, _broadcast)
end

function puzzle_lose_window.OnKeyDown(_this, _key, _keyboard_state, _state, _broadcast)
    return _this.SuperOnKeyDown( _key, _keyboard_state, _state, _broadcast)
end

function puzzle_lose_window.OnKeyUp(_this, _key, _keyboard_state, _state, _broadcast)
	return _this.SuperOnKeyUp( _key, _keyboard_state, _state, _broadcast)
end

function puzzle_lose_window.OnMouseMove(_this, _pos, _state, _broadcast)
	return _this.SuperOnMouseMove(_pos, _state, _broadcast) 
end

function puzzle_lose_window.OnMouseDown(_this, _pos, _button, _state, _broadcast)
	return _this.SuperOnMouseDown( _pos, _button, _state, _broadcast) 
end

function puzzle_lose_window.OnMouseUp(_this, _pos, _button, _state, _broadcast)
	return _this.SuperOnMouseUp( _pos, _button, _state, _broadcast) 
end

function puzzle_lose_window.OnDoubleClick(_this, _pos, _state, _broadcast)
	return _this.SuperOnDoubleClick( _pos, _state, _broadcast) 
end

function puzzle_lose_window.OnMouseWheel(_this, _pos, _delta, _state, _broadcast)
	return _this.SuperOnMouseWheel( _pos, _delta, _state, _broadcast)
end

function puzzle_lose_window.OnChildAction(_this, _action, _child)
	if not _child then return end
	local handler = puzzle_lose_window.actions[_child.GetId().c_str()]
	if handler then handler = handler[_action.c_str()] end
	if handler then handler(_this, _child) end
end

puzzle_lose_window.actions.map_button = 
{
	pressed = function(_window) 
		map_window.ShowPuzzleMap(nil)
	end
}

puzzle_lose_window.actions.replay_button = 
{
	pressed = function(_window) 
		puzzle_window.Replay()
	end
}

puzzle_lose_window.actions.undo_button = 
{
	pressed = function(_window) 
		_window.AddFlags(_window.FlagDead)
		avatar_widget.ChangeMood("no_moves_puzzle_turn_off")

		puzzle_window.UnDo()
	end
}

