puzzle_stat_window = puzzle_stat_window or {}
puzzle_stat_window.actions = puzzle_stat_window.actions or {}
puzzle_stat_window.object = nil

function puzzle_stat_window.get_scores()
	return puzzle_stat_window._scores
end

puzzle_stat_window._res_images = {
	[0] = "screens_statistics_mask_green",
	[1] = "screens_statistics_mask_yellow",
}

--      
puzzle_stat_window.effects_params = 
{
	default = 
	{
		delay = 0,
		duration = 300
	},
	items = 
	{
		{
			widgets = 
			{ 
				{ id = "label_score_text" }, 
			},
			particle = "StatLabelTextEffect",
		    delay = 70 ,
		},
		
		{
			widgets = 
			{ 
				{ id = "score_label", counter = {max_value = puzzle_stat_window.get_scores, str_format = "%i"} } 
			},
			particle = "StatLabelEffect",
			delay = 70 
		},
		
		{
			widgets = 
			{
				{ id = "step_count_label_text" }
			},
			particle = "StatLabelTextEffect",
			delay = 70 
		},
		{
			widgets = 
			{
				{ id = "step_min_label_text" }
			},
			particle = "StatLabelTextEffect",
			delay = 70 
		},
		
		{
			widgets = 
			{
				{ id = "step_count_label" },
			},
			particle = "StatLabelEffect",
			delay = 70 ,
		},
		
		{
			widgets = 
			{
				{ id = "step_min_label" },
			},
			particle = "StatLabelEffect",
			delay = 70 ,
		},
		
				{
			widgets = 
			{
				{ id = "mask_image" },
			},
			particle = "StatLabelEffect",
			delay = 70 ,
		},
		
		{
			widgets = 
			{
				{ id = "time_label_text" },
				{ id = "time_label" }
			},
			particle = "StatLabelTextEffect",
			delay = 70 
		},	
		
	    {
			widgets = 
			{
				{ id = "cup_destroy_label_text" },
				{ id = "cup_destroy_label" }
			},
			particle = "StatLabelTextEffect02",
			delay = 100 
		},
		

		
		{
			widgets = 
			{
				{ id = "achievements_button" }
			},
			delay = 600,
			particle = "StatLabelTextAchEffect",
		},
		
	
		{
			widgets = 
			{
				{ id = "replay_button" },
				{ id = "ok_button" }
			}
		}
	}
}

function puzzle_stat_window.Show(_window)
	sf.core.g_Application.GetTimeManager().GetTimer("game_timer").SetK(1)
	local dialog = sf.gui.CWindow()
	dialog.Load(g_App.GetSettings().GetChild("GUI", false).GetChildByAttribute("window", "id", "puzzle_stat_window", true),
		g_App.GetSettings().GetChild("GUITemplates", false))
	dialog.UpdateLayout()
	
	local profile_data = s11.g_ProfileManager.Instance().GetCurrentProfile().GetPuzzleData()
	
	local step_count = game_window.game_field.GetGameInfo().GetMovesCount()
	
	local step_min_text = get_child_widget(dialog, "step_min_label_text", sf.gui.CLabelWidget, "" )
	local step_min_value = get_child_widget(dialog, "step_min_label", sf.gui.CLabelWidget, "" )
	
	if 	puzzle_window._min_moves_for_win == -1 then
		__visible(step_min_text, false)
		__visible(step_min_value, false)
	else
		local mask_image = get_child_widget(dialog, "mask_image", sf.gui.CImageWidget, "" )
		if step_count > puzzle_window._min_moves_for_win then
			mask_image.SetImage(game_stat_window._res_images[1])
		end
	
		step_min_value.SetText(tostring(puzzle_window._min_moves_for_win))
	end

	puzzle_stat_window.score_label = get_child_widget(dialog, "score_label", sf.gui.CLabelWidget, "" )
	puzzle_stat_window.time_label = get_child_widget(dialog, "time_label", sf.gui.CLabelWidget, "" )
	puzzle_stat_window.step_count_label = get_child_widget(dialog, "step_count_label", sf.gui.CLabelWidget, "" )
	puzzle_stat_window.cup_destroy_label = get_child_widget(dialog, "cup_destroy_label", sf.gui.CLabelWidget, "" )
	puzzle_stat_window.ach_recived_count = get_child_widget(dialog, "achievements_button", sf.gui.CButtonWidget, "" )
	
	puzzle_stat_window.score_label.SetText(tostring(profile_data.GetScore()))
	puzzle_stat_window.time_label.SetText(TimeToString(game_window.game_field.GetGameTime()))
	puzzle_stat_window.step_count_label.SetText(tostring(step_count))
	puzzle_stat_window.cup_destroy_label.SetText(s11.StringFormat("%.2i", (puzzle_window.game_info.GetDestroyedCapsCount()/puzzle_window._caps_on_start_level)*100).."%")
	
	local ach_rec_count = puzzle_window.game_info.GetAchievementRecivedCount()
	
	puzzle_stat_window.ach_recived_count.SetText(s11.StringFormat(puzzle_stat_window.ach_recived_count.GetText(), ach_rec_count))
	
	if ach_rec_count == 0 then
		__visible(puzzle_stat_window.ach_recived_count, false)
	end
	
	puzzle_stat_window._scores = profile_data.GetScore()
	
	stat_effects.Init(dialog, puzzle_stat_window.effects_params)
	
	dialog.SetOffset(
		puzzle_window._game_field_center[1] - dialog.GetSize().X / 2, 
		puzzle_window._game_field_center[2] - dialog.GetSize().Y / 2)

	s11.g_TrackManager.Instance().UpdateCurrentTrack("town_map", false)
	
	__AddStatShoweffect(dialog)
	
    _window.AddChildWindow(dialog)
end

function puzzle_stat_window.DoDraw(_this, _renderer) 
    return false 
end

function puzzle_stat_window.DoUpdate(_this)
	stat_effects.Update()
    return false 
end


function puzzle_stat_window.OnChar(_this, _char, _keyboard_state, _state, _broadcast)
	return _this.SuperOnChar(_char, _keyboard_state, _state, _broadcast)
end

function puzzle_stat_window.OnKeyDown(_this, _key, _keyboard_state, _state, _broadcast)
    return _this.SuperOnKeyDown( _key, _keyboard_state, _state, _broadcast)
end

function puzzle_stat_window.OnKeyUp(_this, _key, _keyboard_state, _state, _broadcast)
	return _this.SuperOnKeyUp( _key, _keyboard_state, _state, _broadcast)
end

function puzzle_stat_window.OnMouseMove(_this, _pos, _state, _broadcast)
	return _this.SuperOnMouseMove(_pos, _state, _broadcast) 
end

function puzzle_stat_window.OnMouseDown(_this, _pos, _button, _state, _broadcast)
	stat_effects.End()
	return _this.SuperOnMouseDown( _pos, _button, _state, _broadcast) 
end

function puzzle_stat_window.OnMouseUp(_this, _pos, _button, _state, _broadcast)
	return _this.SuperOnMouseUp( _pos, _button, _state, _broadcast) 
end

function puzzle_stat_window.OnDoubleClick(_this, _pos, _state, _broadcast)
	return _this.SuperOnDoubleClick( _pos, _state, _broadcast) 
end

function puzzle_stat_window.OnMouseWheel(_this, _pos, _delta, _state, _broadcast)
	return _this.SuperOnMouseWheel( _pos, _delta, _state, _broadcast)
end

function puzzle_stat_window.OnChildAction(_this, _action, _child)
	if not _child then return end
	local handler = puzzle_stat_window.actions[_child.GetId().c_str()]
	if handler then handler = handler[_action.c_str()] end
	if handler then handler(_this, _child) end
end

puzzle_stat_window.actions.ok_button = 
{
	pressed = function(_window) 
		local current_profile = puzzle_window.profile_data
			
		local level_progrees_info = current_profile.GetLevelProgress(puzzle_window.current_game_dif_level, puzzle_window.current_game_level_index)
			
		local level_progrees = level_progrees_info.GetProgress()
		local new_level_progress = game_window.game_field.GetPrizeIndex() + 1
		if level_progrees == -1 or level_progrees > new_level_progress then
			level_progrees_info.SetProgress(new_level_progress)
		end
		
		local old_moves_count = level_progrees_info.GetMovesCount()
		local curretn_moves_per_level = game_window.game_field.GetGameInfo().GetMovesCount()
		if old_moves_count == 0 or old_moves_count > curretn_moves_per_level then
			level_progrees_info.SetMovesCount(game_window.game_field.GetGameInfo().GetMovesCount())
		end

		level_progrees_info.SetFinished(true)
		
		current_profile.SetLevelProgress(puzzle_window.current_game_dif_level, puzzle_window.current_game_level_index, level_progrees_info)

		current_profile.DropSavedLevelInfo()

		puzzle_window.current_profile.SaveGameType(s11.CGameStruct.GameTypePuzzle)
		game_helpers.AddRecord(2)

		_window.AddFlags(_window.FlagDead)
	
		local curr_dif = puzzle_window.current_game_dif_level
		local curr_lev = puzzle_window.current_game_level_index
		local levels = s11.g_GameStruct.Instance().GetLevelsSystem(s11.CGameStruct.GameTypePuzzle).GetLevelsCount(curr_dif)
		
		if curr_lev >= (levels-1) and not achievements.IsCompleted("puzzle_all_levels") then
			end_window.Show(2)
		else
			map_window.ShowPuzzleMap(nil)			
		end
	end
}

puzzle_stat_window.actions.replay_button = 
{
	pressed = function(_window) 
		if dialog_do_modal("replay_dialog", _window) == 1 then
			puzzle_window.Replay()
		end
	end
}

puzzle_stat_window.actions.achievements_button = 
{
	pressed = function(_window) 
		achievements_window.Show(_window)
	end
}
