records_window = records_window or {}
records_window.actions = records_window.actions or {}

records_window.last_record_color = sf.graphics.Color(255, 255, 255, 0)
records_window.modes = {"classic", "endless", "puzzle"}

function records_window._InitTable(_mode)

	local table_id = "table_scores_"..records_window.modes[_mode+1]
	local app = sf.core.g_Application
	local table_info = {}
	
	table_info.table = __cast(records_window._window.GetWidget(table_id,true).get(), "sf.gui.CTableWidget")
	assert(table_info.table, "    id = \""..table_id.."\"")
	
	table_info.header_row = app.GetSettings().GetChild("GUI", false).GetChildByAttribute(
			"window", "id", "records_window", true).GetChildByAttribute(
			"table_widget", "id", table_id, true).GetNamedChild("rows", false).GetChild("row", false)
	
	table_info.string_row = table_info.header_row.GetNextSibling()
	
	local info = app.GetSettings().GetChild("Constants", false).GetChild("records_window", false).GetChildRef(table_id, false)
    if info then
        local last_record_color_str = info.GetValue("last_record_color").c_str()
        if not last_record_color_str.empty() "" then
            table_info.last_record_color = string_to_color(last_record_color_str)
        end
    end
	
	if not table_info.last_record_color then
		table_info.last_record_color = sf.graphics.Color(records_window.last_record_color)
	end
	
	table_info.table.ClearTable()
	table_info.table.LoadRow(table_info.header_row, records_window.template)
   
	local records_count = s11.g_RecordTable.Instance().EnumRecords(_mode)
	local last_record = s11.g_RecordTable.Instance().GetLastRecord(_mode)
	
	for i=1, records_count do
		table_info.table.LoadRow(table_info.string_row, records_window.template)

		local record = s11.g_RecordTable.Instance().GetRecord(_mode, i-1)
		
		__cast(table_info.table.GetCell(i, 0).GetWidgets().Get().get(), "sf.gui.CLabelWidget").SetText(" "..tostring(i))
		__cast(table_info.table.GetCell(i, 1).GetWidgets().Get().get(), "sf.gui.CLabelWidget").SetText(" "..record.Name)
		__cast(table_info.table.GetCell(i, 2).GetWidgets().Get().get(), "sf.gui.CLabelWidget").SetText(" "..TimeToString(record.Time, true))
		__cast(table_info.table.GetCell(i, 3).GetWidgets().Get().get(), "sf.gui.CLabelWidget").SetText(" "..tostring(record.Score))
		__cast(table_info.table.GetCell(i, 4).GetWidgets().Get().get(), "sf.gui.CLabelWidget").SetText(" "..record.Level)		
	end	
	
	if last_record ~= -1 and last_record <= records_count then 
		__cast(table_info.table.GetCell(last_record, 0).GetWidgets().Get().get(), "sf.gui.CLabelWidget").SetColor(table_info.last_record_color)
		__cast(table_info.table.GetCell(last_record, 1).GetWidgets().Get().get(), "sf.gui.CLabelWidget").SetColor(table_info.last_record_color)
		__cast(table_info.table.GetCell(last_record, 2).GetWidgets().Get().get(), "sf.gui.CLabelWidget").SetColor(table_info.last_record_color)
		__cast(table_info.table.GetCell(last_record, 3).GetWidgets().Get().get(), "sf.gui.CLabelWidget").SetColor(table_info.last_record_color)
		__cast(table_info.table.GetCell(last_record, 4).GetWidgets().Get().get(), "sf.gui.CLabelWidget").SetColor(table_info.last_record_color)
	end
	
	table_info.table.FitCells() 
end

function records_window.Show(_window, _start_panel, _no_effect)
    local app = sf.core.g_Application
	
	local window = sf.gui.CWindow()
	window.Load(g_App.GetSettings().GetChild("GUI", false).GetChildByAttribute("window", "id", "records_window", true),
		g_App.GetSettings().GetChild("GUITemplates", false))
	window.UpdateLayout()
    
	local parent_window_size = _window.GetSize()
	window.SetOffset((parent_window_size.X - window.GetSize().X)/2, (parent_window_size.Y - window.GetSize().Y)/2)
	records_window._parent = _window

	if not _no_effect then
		s11.AddShowEffectToWidget(window, misc.hide_window_delay, misc.show_window_delay, misc.shift_before_hide, _window)
	end

	_window.AddChildWindow(window)
	
	records_window._window = window
	records_window._parent = _window

	records_window.template = app.GetSettings().GetChild(_T("GUITemplates"), false)
	
	for i=0, 2 do
		records_window._InitTable(i)
	end
	
	local tab_widget = __cast(window.GetWidget("records_tab_list", true), sf.gui.CTabWidget)
	assert(tab_widget)
	
	records_window._tab_widget = tab_widget
	
	if _start_panel then
		if _start_panel >=0 and _start_panel < 3 then
			tab_widget.SelectPanel(_start_panel)
		end
	else
		local last_mode = s11.g_RecordTable.Instance().GetLastMode()
		if last_mode ~= -1 then
			tab_widget.SelectPanel(last_mode)
		end
	end

    window.UpdateLayout()
	
	if game_background then
		game_background.Init()
		game_background.SetUseClip(false)
	end

	collectgarbage()
end

function records_window.DoDraw(_this, _renderer)
	if game_background then
		game_background.Draw(_renderer)
	end
end

function records_window.DoUpdate(_this)
	if game_background then
		game_background.Update()
	end
end

function records_window.OnChar(_this, _char, _keyboard_state, _state, _broadcast)
	return _this.SuperOnChar(_char, _keyboard_state, _state, _broadcast)
end

function records_window.OnKeyDown(_this, _key, _keyboard_state, _state, _broadcast)
	if _this.SuperOnKeyDown( _key, _keyboard_state, _state, _broadcast) then
      return true
    end
    return false

end

function records_window.OnKeyUp(_this, _key, _keyboard_state, _state, _broadcast)
	return _this.SuperOnKeyUp( _key, _keyboard_state, _state, _broadcast)
end

function records_window.OnMouseMove(_this, _pos, _state, _broadcast)
	return _this.SuperOnMouseMove( _pos, _state, _broadcast) 
end

function records_window.OnMouseDown(_this, _pos, _button, _state, _broadcast)
	return _this.SuperOnMouseDown( _pos, _button, _state, _broadcast) 
end

function records_window.OnMouseUp(_this, _pos, _button, _state, _broadcast)
	return _this.SuperOnMouseUp( _pos, _button, _state, _broadcast) 
end

function records_window.OnDoubleClick(_this, _pos, _state, _broadcast)
	return _this.SuperOnDoubleClick( _pos, _state, _broadcast) 
end

function records_window.OnMouseWheel(_this, _pos, _delta, _state, _broadcast)
	return _this.SuperOnMouseWheel( _pos, _delta, _state, _broadcast)
end

function records_window.OnChildAction(_this, _action, _child)
	if not _child then return end
	local handler = records_window.actions[_child.GetId().c_str()]
	if handler then handler = handler[_action.c_str()] end
	if handler then handler(_this, _child) end
end
	
records_window.actions.ok = 
{
	pressed = function(_window) 
		s11.AddHideEffectToWidget(records_window._window, 300, 300, 300, records_window._parent)
	end
}

records_window.actions.clear = 
{
	pressed = function(_window) 
		local app = sf.core.g_Application
		
		local mode = records_window._tab_widget.GetSelectedPanel()
		assert(mode ~= -1)
		
		local window = sf.gui.CWindow()

		window.Load(
			app.GetSettings().GetChild("GUI", false).GetChildByAttribute("window", "id", "records_clear_dialog", true), 
			app.GetSettings().GetChild("GUITemplates", false))
		window.UpdateLayout()
		local modal_res = dialog_do_modal(window, _window)
		
        if modal_res == 1 then
            s11.g_RecordTable.Instance().Clear(mode)
			records_window._InitTable(mode)
            _window.UpdateLayout()
        end
	end
}
