--     
shadow_widget = {}

__inherite(shadow_widget, null_lua_widget_handler())

function shadow_widget.__CreateInstance()
    return "shadow_widget"
end

function shadow_widget.Load(_this, _info, _templates)
	return true
end

function shadow_widget._Colse()
	if shadow_widget._widget then
		shadow_widget._widget.AddFlags(shadow_widget._widget.FlagDead)
		shadow_widget._widget = nil
	end
end

function shadow_widget.Hide()
	shadow_widget._timer.Get().SetK(-1)
	shadow_widget._timer.Get().SetTime(shadow_widget._hide_time)
end

function shadow_widget.AddShadow(_parend_window, _layer, _texture_id, _pos, _alpha, _show_time, _hide_time, _size)

	shadow_widget._size = _size
	shadow_widget._show_time = _show_time
	shadow_widget._hide_time = _hide_time

	local new_widget = sf.gui.CLuaWidget("shadow_widget",_layer, 0)

	--      
	new_widget.SetOffset(0, 0)
	new_widget.SetLua(g_Lua.GetId())
	new_widget.SetOverloadTable("shadow_widget")
	
	shadow_widget._timer = __create_timer()
	
	shadow_widget._widget = new_widget
	shadow_widget._mask_texture = sf.core.g_Application.GetResourceManager().GetTexture(_texture_id)			
	shadow_widget._pos = _pos
	shadow_widget._target_alpha = _alpha
	shadow_widget._color = sf.graphics.Color(0, 0, 0, 0)
	
	--    
	_parend_window.AddWidget(new_widget)
end

function shadow_widget.DoUpdate(_this)
	local k = shadow_widget._timer.Get().GetK()
	local _time = shadow_widget._timer.Get().GetTime()
	
	if k > 0.1 then
		koef = _time / shadow_widget._show_time
		if koef > 1 then
			koef = 1
			shadow_widget._timer.Get().SetK(0)
		end
		shadow_widget._color = sf.graphics.Color(shadow_widget._target_alpha * koef, 0, 0, 0)
	elseif k < -0.1 then
		koef = _time / shadow_widget._hide_time
		if koef <= 0 then
			koef = 0
			shadow_widget._Colse()
		end
		shadow_widget._color = sf.graphics.Color(shadow_widget._target_alpha * koef, 0, 0, 0)
	end
	return false
end

function shadow_widget.DoDraw(_this, _renderer)
	s11.misc.RenderBorderedImage(_renderer, 
							     shadow_widget._mask_texture, 
								 shadow_widget._pos.X, 
								 shadow_widget._pos.Y, 
								 shadow_widget._color, 
								 shadow_widget._size)
    return false
end

function shadow_widget.OnMouseMove(_this, _pos, _state, _broadcast)
    return false
end

function shadow_widget.OnMouseUp(_this, _pos, _button, _state, _broadcast)
    return false
end

function shadow_widget.OnMouseDown(_this, _pos, _button, _state, _broadcast)
    return false
end

function shadow_widget.OnDoubleClick(_this, _pos, _state, _broadcast)
    return true
end
