--    
totems_widget = totems_widget or {}
totems_widget._totem_effect_create_functions = totems_widget._totem_effect_create_functions or {}
totems_widget._totem_load_options_functions = totems_widget._totem_load_options_functions or {}

--    
totems_widget._blue_totem_options = {
	--     
	--         
	flags = {               
		simple_hit = 1,
		blow_hit = 2,
		turn_on_shield = 4
	},
	-- ()      
	shield_draw_pos = sf.misc.FloatVector(140, 470),  --      
	start_lightning_pos = sf.misc.FloatVector(40, 40), --       
	steel_shield_id = " ",                  --  
	chain_shield_id = " ",
	hit_fly_speed = 400, --        
	shield_text = "",   --   
	font = nil,          --   
	slmple_hit = 0,  --     
	blow_hit = 0     --         
	
}

--      
totems_widget._totem_load_options_functions[s11.CFieldCap.CapTypeBlue] = function (_totems_info)

	local options = totems_widget._blue_totem_options
	options.start_lightning_pos = totems_widget.GetAbsOffset(StringToFloatVector(_totems_info.GetValue("start_lightning_pos").c_str()))
	options.shield_draw_pos = totems_widget.GetAbsOffset(StringToFloatVector(_totems_info.GetValue("shield_draw_pos").c_str()))
	options.hit_fly_speed = tonumber(_totems_info.GetValue("hit_fly_speed").c_str()) or 0
	
	local shake_info = g_App.GetSettings().GetChild("Constants", false).GetChild("shake_options", false).GetChild("blue_totem", false)
	
	options.slmple_hit = tonumber(shake_info.GetValue("slmple_hit").c_str())
	options.blow_hit = tonumber(shake_info.GetValue("blow_hit").c_str())
	
end

--       
-- _cell -      
-- _force -  
-- _start_pos -  
-- _fly_speed -  
local HitCellEffect = function(_cell, _force, _start_pos, _fly_speed)
    local new_child_effect = 
    {
        Init = function(_self, _fly_speed, _start_pos, _cell, _force)
			-- ,    
			_cell.AddLock()
			_self._end_pos = game_helpers.GetFieldPos() + _cell.GetCapPos(true)
			_self._cell = _cell
			_self._force = _force or 0
			_self._start_pos = _start_pos
            _self._start_time = effects_widget.effects_timer.Get().GetTime()
            _self._total_time = CalcTimeForVector(_self._start_pos, _self._end_pos, _fly_speed)
            _self._end_time = _self._start_time + _self._total_time
			_self._blow_effect = "BlueTotemLightnigHit"
			local options = totems_widget._blue_totem_options
			_self._shake_force = options.slmple_hit
			if _self._force == 2 then
				_self._blow_effect = "BlueTotemLightnigHitExpl"
				_self._shake_force = options.blow_hit
			end
			_self._particle_effect = effects_widget.visual_effects:CreateEffect("BlueTotemLightning", _start_pos)            
        end,

        Draw = function(_self, _renderer)
			--if _self._fly_obj_pos ~= nil then
				--local pos = _self._fly_obj_pos
				--_renderer.RenderLine(pos - sf.misc.FloatVector(20,20), pos + sf.misc.FloatVector(20,20), 0xffffffff)
				--_renderer.RenderLine(pos - sf.misc.FloatVector(20,-20), pos + sf.misc.FloatVector(20,-20), 0xffffffff)
			--end
        end,

        Update = function(_self, _time)
            local koef = (_time - _self._start_time)/_self._total_time
            _self._fly_obj_pos = effects_widget.SimpleFlyFunction( _self._start_pos, _self._end_pos, koef)
			_self._particle_effect:SetPos(_self._fly_obj_pos)
            if _time > _self._end_time then
                _self:InstantApply()
            end
        end,

        InstantApply = function(_self)
            if not _self._is_dead then
				--    
				_self._cell.DecLock()
				game_window.game_field.BlowUpCell(_self._cell, _self._force, _self._shake_force)
				_self._particle_effect:Kill(false)
				game_window.game_field.AddCompositeEffect(_self._end_pos, _self._blow_effect)
			end

            _self._is_dead = true
        end,

		IsDead = function(_self)
			return _self._is_dead
		end,
    }
	new_child_effect:Init(_fly_speed, _start_pos, _cell, _force)
	effects_widget.add_effect(new_child_effect)
end

--     
totems_widget._totem_effect_create_functions[s11.CFieldCap.CapTypeBlue] = function ()
    local new_child_effect = 
    {
		_HitCellEffect = HitCellEffect,
		_options = totems_widget._blue_totem_options,

        Init = function(_self, _work_info)
			_self._end_time = totems_widget._totem_work_time + totems_widget.effects_timer.Get().GetTime()
			--     
			local steel_list = {}
			local chain_list = {}
			for i = 0,s11.ConstsFieldSizeX-1 do
				for j = 0,s11.ConstsFieldSizeY-1 do
					local cell = game_window.game_field.GetCell(i, j)
					local cap = cell.GetCap()
					--     
					if cell.IsFree() and cap then
						--     
						--      
						if cap.IsSteel() then
							table.insert(steel_list, cell)
						end
						if cap.IsChain() then
							table.insert(chain_list, cell)
						end
					end
				end
			end

			--     
			--  ,       ,   
			--   
			_self:_CreateHitCellEffects(steel_list, 
                                        _work_info.perk1, 
                                        game_window.game_field.SetSteelShield)
			--   
			_self:_CreateHitCellEffects(chain_list, 
                                        _work_info.perk2, 
                                        game_window.game_field.SetChainShield)

        end,
		
		--    
		-- _cell_list -   
		-- _flags -      
		-- _shield_function - ,     
		_CreateHitCellEffects = function(_self, _cell_list, _flags, _shield_function)
			--         
			if __and(_flags, totems_widget._blue_totem_options.flags.turn_on_shield) ~= 0 then
				_shield_function(true)
				--   
				--totems_widget._UpdateShieldInfo(game_window.game_field)
			end
			--       
			if #_cell_list == 0 then return end
			
			local force = -1
			--     ,    = 0
			if __and(_flags, totems_widget._blue_totem_options.flags.simple_hit) ~= 0 then
				force = 0
			end
			--    -,    = 2
			if __and(_flags, totems_widget._blue_totem_options.flags.blow_hit) ~= 0 then
				force = 2
			end
			--        
			if force == -1 then return end
			--             
			for _,cell in pairs(_cell_list) do
				_self._HitCellEffect(cell, force, _self._options.start_lightning_pos, _self._options.hit_fly_speed)
			end
		end,
		
        Draw = function(_self, _renderer)
        end,

        Update = function(_self, _time)
            if _time > _self._end_time then
                _self:InstantApply()
            end
        end,

        InstantApply = function(_self)
            _self._is_dead = true
        end,
		
		IsDead = function(_self)
			return _self._is_dead
		end
    }
    return new_child_effect
end
