--       
totems_widget = totems_widget or {}
totems_widget._totem_effect_create_functions = totems_widget._totem_effect_create_functions or {}
totems_widget._totem_load_options_functions = totems_widget._totem_load_options_functions or {}

--  
totems_widget._red_totem_options = {
	
	fire_ball_big_speed = 400,
	
	fire_ball_small_speed = 400,
	
	fire_ball_start_pos = sf.misc.FloatVector(0, 0), --    
	base_shake_force = 0,        --  
	big_balls_shake_force = 0, 
	emiters_offsets = 
	{
		[1] = sf.misc.FloatVector(10, 10),
		[2] = sf.misc.FloatVector(100, 10),
		[3] = sf.misc.FloatVector(100, 100),
		[4] = sf.misc.FloatVector(10, 100)
	}
}

--      
totems_widget._totem_load_options_functions[s11.CFieldCap.CapTypeRed] = function (_totems_info)
	local options = totems_widget._red_totem_options
	
	--   
	options.emiters_offsets = {}
	local index = 1
	local emiters_info = _totems_info.GetChild("emiters_pos", false).GetFirstChildRef()
	while emiters_info do
		options.emiters_offsets[index] = totems_widget.GetAbsOffset(StringToFloatVector(emiters_info.GetValue("offset").c_str()))
		index = index + 1
		emiters_info = emiters_info.GetNextSiblingRef()
	end
	

	options.fire_ball_big_speed = tonumber(_totems_info.GetValue("fire_ball_big_speed").c_str()) or 0
	options.fire_ball_small_speed = tonumber(_totems_info.GetValue("fire_ball_small_speed").c_str()) or 0
	
	local shake_info = g_App.GetSettings().GetChild("Constants", false).GetChild("shake_options", false).GetChild("red_totem", false)
	
	options.base_shake_force = tonumber(shake_info.GetValue("base_ball_hit").c_str())
	options.big_balls_shake_force = tonumber(shake_info.GetValue("base_ball_hit").c_str())
end

--   FireBall (   )
-- _force -    
-- _fly_speed -   
-- _start_pos -    
local AddFireBall = function(_force, _fly_speed, _start_pos)
    local new_child_effect = 
    {
        Init = function(_self, _speed, _force, _start_pos)
			_self._options = totems_widget._red_totem_options
			_self._force = _force or 0
			_self._cell_pos_x = math.random(0, s11.ConstsFieldSizeX-2)
			_self._cell_pos_y = math.random(0, s11.ConstsFieldSizeY-2)
			_self._start_pos = _start_pos
			_self._end_pos = game_helpers.GetFieldPos() + game_window.game_field.GetCell(_self._cell_pos_x, _self._cell_pos_y).GetCellOffset()
            _self._start_time = effects_widget.effects_timer.Get().GetTime()
            _self._total_time = CalcTimeForVector(_self._start_pos, _self._end_pos, _speed)
            _self._end_time = _self._start_time + _self._total_time
			_self._hit_effect_id = "FireBallSmallHit"
			local system_id = "FireBallSmall"
			--    
		    local options = totems_widget._red_totem_options
			_self._shake_force = options.base_shake_force
			--       
			if _force == 1 then
				_self._end_pos = _self._end_pos + sf.misc.FloatVector(83, 83)
			end

			if _force == 2 then
				_self._shake_force = _self._shake_force + options.big_balls_shake_force
				system_id = "FireBallBig"
				_self._hit_effect_id = "FireBallBigHit"
				_self._end_pos = _self._end_pos + sf.misc.FloatVector(42, 42)
			end
			_self._particle_effect = effects_widget.visual_effects:CreateEffect(system_id, _start_pos)            
			
        end,

        Draw = function(_self, _renderer)
			--if _self._fly_obj_pos ~= nil then
				--local pos = _self._fly_obj_pos
				--_renderer.RenderLine(pos - sf.misc.FloatVector(20,20), pos + sf.misc.FloatVector(20,20), 0xffffffff)
				--_renderer.RenderLine(pos - sf.misc.FloatVector(20,-20), pos + sf.misc.FloatVector(20,-20), 0xffffffff)
			--end
        end,

        Update = function(_self, _time)
            local koef = (_time - _self._start_time)/_self._total_time
            _self._fly_obj_pos = effects_widget.SimpleFlyFunction( _self._start_pos, _self._end_pos, koef)
			_self._particle_effect:SetPos(_self._fly_obj_pos)
            if _time > _self._end_time then
                _self:InstantApply()
            end
        end,

        InstantApply = function(_self)
            if not _self._is_dead then
				_self._particle_effect:Kill(false)
				game_window.game_field.AddCompositeEffect(_self._end_pos, _self._hit_effect_id)
				game_window.game_field.BlowUpCell(_self._cell_pos_x, _self._cell_pos_y, _self._force, _self._shake_force)
			end

            _self._is_dead = true
        end,

		IsDead = function(_self)
			return _self._is_dead
		end,
    }
	new_child_effect:Init(_fly_speed, _force or 0, _start_pos)
	effects_widget.add_effect(new_child_effect)
end

---     
totems_widget._totem_effect_create_functions[s11.CFieldCap.CapTypeRed] = function ()
    local new_child_effect = 
    {
		_AddFireBall = AddFireBall,
		_options = totems_widget._red_totem_options,
		--    
		_GetNextEmiterOffset = function(_self)
			_self._emiter_index = _self._emiter_index + 1
			if _self._emiter_index > #_self._options.emiters_offsets then
				_self._emiter_index = 1
			end
			return _self._options.emiters_offsets[_self._emiter_index]
		end,
        Init = function(_self, _work_info)
			_self._emiter_index = 0
			_self._end_time = totems_widget._totem_work_time + totems_widget.effects_timer.Get().GetTime()
			--       
			--        
			for i = 1,_work_info.perk1 do
				_self._AddFireBall(1, 
                                   _self._options.fire_ball_small_speed, 
                                   _self:_GetNextEmiterOffset())
			end
			--        
			for i = 1,_work_info.perk2 do
				_self._AddFireBall(2, 
                                   _self._options.fire_ball_big_speed, 
                                   _self:_GetNextEmiterOffset())
			end

        end,

        Draw = function(_self, _renderer)
        end,

        Update = function(_self, _time)
            if _time > _self._end_time then
                _self:InstantApply()
            end
        end,

        InstantApply = function(_self)
            _self._is_dead = true
        end,
		
		IsDead = function(_self)
			return _self._is_dead
		end
    }
    return new_child_effect
end
