--     
totem_tutorial = {}

totem_tutorial._cap_type = s11.CFieldCap.CapTypeRed   --  
totem_tutorial._moves_count = 2                       --   
totem_tutorial._fly_speed = 700  --     
totem_tutorial._effect_target_pos = sf.misc.FloatVector(150, 530)  --     

function totem_tutorial.OnFinishTutorial()
	totem_tutorial._tutorial_flags.RaiseFlag(s11.CProfileDataClassic.TutorialFlagTotem)
	shadow_widget.Hide()
	drop_buttons.SetDisable(false)
	--    
end

function totem_tutorial.Init(_game_field, _tutorial_flags)
	totem_tutorial._game_field  = _game_field
	totem_tutorial._game_field.SetHintCapType(totem_tutorial._cap_type)
	totem_tutorial._game_field.SetStrategy(s11.strategy.CreateRedTotemTutorial(totem_tutorial._cap_type, totem_tutorial._moves_count))
	shadow_widget.AddShadow(game_window._self, 150, "tutorial_darkening_masks_cells_red_match01", sf.misc.FloatVector(541,357), 190, 300, 300)
	--     
	totem_tutorial._tutorial_flags = _tutorial_flags
	game_window._hint_tutorial = nil
	drop_buttons.SetDisable(true)
end

function totem_tutorial.DarkSecondMatch()
	shadow_widget.AddShadow(game_window._self, 150, "tutorial_darkening_masks_cells_red_match01", sf.misc.FloatVector(374,191), 190, 300, 300)
end
--        
-- _start_pos -  
function totem_tutorial.TutorialOnRedTotem(_start_pos)
	
	--   
	shadow_widget.Hide()
    local new_child_effect = 
    {
        Init = function(_self, _fly_speed, _start_pos, _end_pos)
			_self._time = _time
			_self._start_pos = _start_pos
			_self._end_pos = _end_pos
            _self._start_time = effects_widget.effects_timer.Get().GetTime()
            _self._total_time = CalcTimeForVector(_self._start_pos, _self._end_pos, _fly_speed)
            _self._end_time = _self._start_time + _self._total_time
			effects_widget.visual_effects:CreateInstantEffect("RedTutorialOnMatch", _start_pos)
			_self._particle_effect = effects_widget.visual_effects:CreateEffect("RedTutorialFly", _start_pos)            
        end,

        Draw = function(_self, _renderer)
        end,

        Update = function(_self, _time)
            local koef = (_time - _self._start_time)/_self._total_time
            _self._fly_obj_pos = effects_widget.SimpleFlyFunction( _self._start_pos, _self._end_pos, koef)
			_self._particle_effect:SetPos(_self._fly_obj_pos)
            if _time > _self._end_time then
                _self:InstantApply()
            end
        end,

        InstantApply = function(_self)
            if not _self._is_dead then
				_self._particle_effect:Kill(false)
				effects_widget.visual_effects:CreateInstantEffect("RedTutorialOnTotemApply", _self._fly_obj_pos)
				--   
				tutorial_window.Show(game_window._self, "red_totem")	
				--  ,     
				tutorial_window.SetPostShowEvent(totem_tutorial.DarkSecondMatch)
			end

            _self._is_dead = true
        end,

		IsDead = function(_self)
			return _self._is_dead
		end,
		
    }
	new_child_effect:Init(totem_tutorial._fly_speed, _start_pos + game_window.game_field.GetOffsetOnGameWindow() , totem_tutorial._effect_target_pos)
	effects_widget.add_visual_effect(new_child_effect)
end
