--    
totems_widget = totems_widget or {}
totems_widget._totem_effect_create_functions = totems_widget._totem_effect_create_functions or {}
totems_widget._totem_load_options_functions = totems_widget._totem_load_options_functions or {}

--    
totems_widget._yellow_totem_options = {
	--   
	fly_score_start_pos = sf.misc.FloatVector(0, 0), 
	fly_score_target_offset = sf.misc.FloatVector(40, 250), 
	fly_score_time = 500,
	--    
	run_frenzy_effect_time = 500, 
	run_frenzy_start_pos = sf.misc.FloatVector(0, 0),
	run_frenzy_end_offset = sf.misc.FloatVector(640, 740),

	fly_score_font_id = "mpc_gradient_30",
	fly_score_font = nil
	
}

--      
totems_widget._totem_load_options_functions[s11.CFieldCap.CapTypeYellow] = function (_totems_info)

	local options = totems_widget._yellow_totem_options

	options.run_frenzy_start_pos = totems_widget.GetAbsOffset(StringToFloatVector(_totems_info.GetValue("run_frenzy_start_pos").c_str()))
	options.run_frenzy_end_offset = StringToFloatVector(_totems_info.GetValue("run_frenzy_end_offset").c_str())
	options.run_frenzy_effect_time = tonumber(_totems_info.GetValue("run_frenzy_effect_time").c_str()) or 0

	options.fly_score_start_pos = totems_widget.GetAbsOffset(StringToFloatVector(_totems_info.GetValue("fly_score_start_pos").c_str()))
	options.fly_score_target_offset = StringToFloatVector(_totems_info.GetValue("fly_score_target_offset").c_str())
	options.fly_score_time = tonumber(_totems_info.GetValue("fly_score_time").c_str()) or 0
	
	options.fly_score_font_id = _totems_info.GetValue("fly_score_font_id").c_str()
	
	options.fly_score_font = sf.core.g_Application.GetResourceManager().GetFont(options.fly_score_font_id)

end

--   
-- _start_pos -  
-- _target_pos -  
-- _fly_time -  
local StartScoreFrenzy = function(_start_pos, _target_pos, _fly_time)
    local new_child_effect = 
    {
        Init = function(_self, _total_time, _start_pos, _end_pos)
			_self._start_pos = _start_pos
			_self._end_pos = _end_pos
            _self._start_time = effects_widget.effects_timer.Get().GetTime()
            _self._total_time = _total_time
            _self._end_time = _self._start_time + _self._total_time
			_self._particle_effect = effects_widget.visual_effects:CreateEffect("YellowTotemFrenzyTurnOn", _start_pos)     
			__sound("totem_yellow_use02")			
        end,

        Draw = function(_self, _renderer)
			--if _self._fly_obj_pos ~= nil then
				--local pos = _self._fly_obj_pos
				--_renderer.RenderLine(pos - sf.misc.FloatVector(20,20), pos + sf.misc.FloatVector(20,20), 0xffffffff)
				--_renderer.RenderLine(pos - sf.misc.FloatVector(20,-20), pos + sf.misc.FloatVector(20,-20), 0xffffffff)
			--end
        end,

        Update = function(_self, _time)
            local koef = (_time - _self._start_time)/_self._total_time
            _self._fly_obj_pos = effects_widget.SimpleFlyFunction( _self._start_pos, _self._end_pos, koef)
			_self._particle_effect:SetPos(_self._fly_obj_pos)
            if _time > _self._end_time then
                _self:InstantApply()
            end
        end,

        InstantApply = function(_self)
            if not _self._is_dead then
				game_window.game_field.RunScoreFrenzy()
				_self._particle_effect:Kill(false)
				effects_widget.visual_effects:CreateInstantEffect("YellowTotemFrenzyTurnOnHit", _self._fly_obj_pos)
				game.OnAddScore()
				
			end

            _self._is_dead = true
        end,

		IsDead = function(_self)
			return _self._is_dead
		end,
    }
	new_child_effect:Init(_fly_time, _start_pos, _target_pos)
	effects_widget.add_effect(new_child_effect)
end

--       
-- _score -  
-- _start_pos -  
-- _target_pos -  
-- _fly_time -    
local AddScoreBonus = function(_score, _start_pos, _target_pos, _fly_time)
    local new_child_effect = 
    {
        Init = function(_self, _total_time, _start_pos, _end_pos, _score_inc )
			_self._score = _score_inc
			_self._score_str = tostring(_score_inc)
			_self._start_pos = _start_pos
			_self._end_pos = _end_pos
            _self._start_time = effects_widget.effects_timer.Get().GetTime()
            _self._total_time = _total_time
            _self._end_time = _self._start_time + _self._total_time
			_self._particle_effect = effects_widget.visual_effects:CreateEffect("ScoreFlyFromTotem", _start_pos)            
        end,

        Draw = function(_self, _renderer)
			if _self._fly_obj_pos ~= nil then
				local pos = _self._fly_obj_pos
				--_renderer.RenderLine(pos - sf.misc.FloatVector(20,20), pos + sf.misc.FloatVector(20,20), 0xffffffff)
				--_renderer.RenderLine(pos - sf.misc.FloatVector(20,-20), pos + sf.misc.FloatVector(20,-20), 0xffffffff)
				_renderer.RenderString( totems_widget._yellow_totem_options.fly_score_font, 
									   _self._score_str, 
									   pos.X, 
									   pos.Y, 
									   0, 
									   0, 
									   1, 
									   sf.graphics.Color(255, 255, 255, 255), 0)
			end
        end,

        Update = function(_self, _time)
            local koef = (_time - _self._start_time)/_self._total_time
            _self._fly_obj_pos = effects_widget.SimpleFlyFunction( _self._start_pos, _self._end_pos, koef)
			_self._particle_effect:SetPos(_self._fly_obj_pos)
            if _time > _self._end_time then
                _self:InstantApply()
            end
        end,

        InstantApply = function(_self)
            if not _self._is_dead then
				game_window.game_field.AddScoreToProfile(_self._score)
				_self._particle_effect:Kill(false)
				effects_widget.visual_effects:CreateInstantEffect("ScoreHitEffect", _self._fly_obj_pos)
				game.OnAddScore()
				
			end

            _self._is_dead = true
        end,

		IsDead = function(_self)
			return _self._is_dead
		end,
    }
	new_child_effect:Init(_fly_time, _start_pos, _target_pos, _score)
	effects_widget.add_effect(new_child_effect)
end

--   
totems_widget._totem_effect_create_functions[s11.CFieldCap.CapTypeYellow] = function ()
    local new_child_effect = 
    {
		_options = totems_widget._yellow_totem_options,
        Init = function(_self, _work_info)
			_self._end_time = totems_widget._totem_work_time + totems_widget.effects_timer.Get().GetTime()
			--    
			if _work_info.perk1 > 0 then
				_self._AddScoreBonus(_work_info.perk1, 
				                     _self._options.fly_score_start_pos,
									 _self._options.fly_score_target_offset,
				                     _self._options.fly_score_time)
			end
			--    
			if _work_info.perk2 == 1 then
				_self._StartScoreFrenzy(_self._options.run_frenzy_start_pos, 
									    _self._options.run_frenzy_end_offset,
									    _self._options.run_frenzy_effect_time)
			end
        end,

        Draw = function(_self, _renderer)
        end,

        Update = function(_self, _time)
            if _time > _self._end_time then
                _self:InstantApply()
            end
        end,

        InstantApply = function(_self)
            _self._is_dead = true
        end,
		
		IsDead = function(_self)
			return _self._is_dead
		end,
		_AddScoreBonus = AddScoreBonus,
		_StartScoreFrenzy = StartScoreFrenzy
    }
    return new_child_effect
end
