---          ,    town_window
building_info_window = {}
building_info_window._actions = {}

--        
building_info_window._back_info_window_on = "screens_town_town_window"
building_info_window._back_info_window_off = "screens_town_town_window_off"

building_info_window._sell_string = sf.misc.g_StringTable.Instance().FormatByStringsID("$287")
building_info_window._buy_string = sf.misc.g_StringTable.Instance().FormatByStringsID("$286")

building_info_window._left_block_offset = sf.misc.FloatVector(-7, -7)
building_info_window._right_block_offset = sf.misc.FloatVector(0, 0)

--       
building_info_window._bubblehelp_arrow_off = "screens_town_bubblehelp_arrow_off"

building_info_window._block_off = "screens_town_town_window_block_off"

__inherite(building_info_window, null_lua_widget_handler(building_info_window._actions))

building_info_window._actions.close_button = 
{
    pressed = function(_owner)
		town_window._CloseBuildingInfoWindow()
    end
}

building_info_window._actions.buy_button = 
{
    pressed = function(_owner)
		town_window.OnBuyInInfoWindow()
    end
}

building_info_window._actions.sell_button = 
{
    pressed = function(_owner)
		town_window.OnSellInInfoWindow()
    end
}

function building_info_window.__CreateInstance()
    return "building_info_window"
end

building_info_window._close_button_offset = sf.misc.FloatVector(38, 17) 

building_info_window._widgets_list = {}  --  

--- ,      
building_info_window._widget_id_list = 
{
	close_button = sf.gui.CButtonWidget,
	building_name_label = sf.gui.CLabelWidget,
	building_level_image = sf.gui.CImageWidget,
	action_label = sf.gui.CLabelWidget,
	money_image = sf.gui.CImageWidget,
	money_label = sf.gui.CLabelWidget,
	upgrade_action_label = sf.gui.CLabelWidget,
	buy_button = sf.gui.CButtonWidget,
	sell_button = sf.gui.CButtonWidget,
	bubblehelp_arrow_widget = sf.gui.CImageWidget,
	money_disabled = sf.gui.CImageWidget,
	block_image = sf.gui.CImageWidget,
	price_text_label = sf.gui.CLabelWidget,
}

--- ,    
building_info_window._over_block_widgets =
{
	"money_image",
	"money_label",
	"upgrade_action_label",
}

--- ,      
building_info_window._removed_in_last_state_widgets =
{
	"money_image",
	"money_label",
	"upgrade_action_label",
	"buy_button",
	"money_disabled",
	"block_image",
	"price_text_label"
}

--- ,      
building_info_window._removed_if_buyable_widgets =
{
	"money_disabled",
}

--       
building_info_window._disable_table = 
{
	money = {widget = "money_disabled", start_widget = "money_image", offset = sf.misc.FloatVector(0, 0)},
}

--- ,      
building_info_window._remove_widgets =
{
}

---      
function building_info_window.FormBuildingInfoWidget(_building_info, _profile)
	building_info_window._cost_disable = nil
	building_info_window._id = _building_info.id
	local background_off = nil
	local town_object = town_info.GetItemInfo(_building_info.id)
    local building_info_resources = g_App.GetSettings().GetChild("GUI", false)
	                                                       .GetChildByAttribute("window", "id", "building_info_window", true)
    local building_info_widget = sf.gui.CLuaWidget("building_info_widget", 140, 0)

    building_info_widget.Load(building_info_resources, g_App.GetSettings().GetChild("GUITemplates", false))
	
	building_info_window._widgets_list = {}
	--      
	for widget_id,widget_type in pairs(building_info_window._widget_id_list) do
		local loaded_widget = get_child_widget(building_info_widget, widget_id, widget_type) 
		---  -   ,     nil
		if not loaded_widget then
			__message("Widget ".. widget_id .." not found")
			return nil
		end
		building_info_window._widgets_list[widget_id] = loaded_widget
	end

	local widgets_list = building_info_window._widgets_list
	---   
	widgets_list["building_name_label"].SetText(town_object.caption)
	---   
	widgets_list["building_level_image"].SetImage("screens_town_item_level"..tostring(_building_info.current_level))

	---        
	if _building_info.current_level == 0 then
	    ---   ,  
		---    
		building_info_widget.RemoveWidget(widgets_list["action_label"])
		---   
		building_info_widget.RemoveWidget(widgets_list["sell_button"])
	else
	    ---      ,  
		---      
		local current_upgrade_info = town_object.upgrades_cost[_building_info.current_level]
		---     ( ,   )
		local is_selable, is_forbid_sell = town_window.IsSellable(_building_info.id)
		widgets_list["sell_button"].SetText(s11.StringFormat(building_info_window._sell_string,
																current_upgrade_info.money_cost*town_window.GetSellKoef()))
		
		if not is_selable then
			---       
			if not is_forbid_sell then
				building_info_widget.RemoveWidget(widgets_list["sell_button"])
			else
				widgets_list["sell_button"].DisableButton(true)
			end
		end
		---    
		widgets_list["action_label"].SetText(current_upgrade_info.current_action)
		widgets_list["action_label"].ResizeToFitText(true)
	end

	local cost_disable = {}
	---     
	if _building_info.current_level == 4 then
		---    ,         ,  
		for _,widget_id in pairs(building_info_window._removed_in_last_state_widgets) do
			building_info_widget.RemoveWidget(widgets_list[widget_id])
		end
	else
	    ---    ,    
		local next_upgrade_info = town_object.upgrades_cost[_building_info.current_level + 1]
		widgets_list["money_label"].SetText(tostring(next_upgrade_info.money_cost))
		---     
		widgets_list["upgrade_action_label"].SetText(tostring(next_upgrade_info.future_action))
		widgets_list["upgrade_action_label"].ResizeToFitText(true)
		---   
		widgets_list["buy_button"].SetText(s11.StringFormat(building_info_window._buy_string, next_upgrade_info.money_cost))
        ---  ()  ,   
		local res_table, buyable = town_info.GetResourcesTable(_building_info.id, _profile)
		cost_disable = res_table
		building_info_window._cost_disable = res_table
		if not buyable then
			widgets_list["buy_button"].DisableButton(true)
			background_off = true
		end
	end
	
	for _,widget_id in pairs(building_info_window._remove_widgets) do
		building_info_widget.RemoveWidget(widgets_list[widget_id])
	end
	

    ---  ,     
    building_info_widget.Update()
    ---     (    )
	building_info_widget.UpdateLayout()
	
	---    
	local info_window_size = building_info_widget.GetSize()
	
	---           
	widgets_list["close_button"].SetOffset(info_window_size.X - building_info_window._close_button_offset.X, 
	                                          building_info_window._close_button_offset.Y)
	---    ,      
	
	local back_ground_id = building_info_window._back_info_window_on
	if not background_off then
		for _,widget_id in pairs(building_info_window._removed_if_buyable_widgets) do
			building_info_widget.RemoveWidget(widgets_list[widget_id])
		end
	else
		for res_id,disable_info in pairs(building_info_window._disable_table) do
			local widget = widgets_list[disable_info.widget]
			if not cost_disable[res_id] then
				building_info_widget.RemoveWidget(widget)
			else
				local power_base_offset = widgets_list[disable_info.start_widget].GetOffset() + disable_info.offset
				widget.SetOffset(power_base_offset.X, power_base_offset.Y)
			end
		end
		
		back_ground_id = building_info_window._back_info_window_off
		widgets_list["bubblehelp_arrow_widget"].SetImage(building_info_window._bubblehelp_arrow_off)
	end
	
	
	local block_image = get_child_widget(building_info_widget, "block_image", sf.gui.CImageWidget) 
	if block_image then
		local left_limits = sf.misc.FloatVector(-1, -1)
		local right_limits = sf.misc.FloatVector(-1, -1)
		for _, id in pairs(building_info_window._over_block_widgets) do
			local offset = widgets_list[id].GetOffset()
			local size = widgets_list[id].GetSize()
			if left_limits.X > offset.X or left_limits.X == -1 then
				left_limits.X = offset.X
			end
			if left_limits.Y > offset.Y or left_limits.Y == -1 then
				left_limits.Y = offset.Y
			end
			
			offset = offset + size
			if right_limits.X < offset.X or right_limits.X == -1 then
				right_limits.X = offset.X
			end
			if right_limits.Y < offset.Y or right_limits.Y == -1 then
				right_limits.Y = offset.Y
			end
			
			
		end
		left_limits = left_limits + building_info_window._left_block_offset
		right_limits = right_limits + building_info_window._right_block_offset
		local block_size = right_limits - left_limits
		if background_off then
			widgets_list["block_image"].SetImage(building_info_window._block_off)
		end

		widgets_list["block_image"].SetOffset(left_limits.X, left_limits.Y)
		widgets_list["block_image"].SetSize(block_size.X, block_size.Y)
		local block_image = widgets_list["block_image"].GetImage()
		block_image.SetFlags(__or(__or(block_image.GetFlags(), sf.graphics.CImage.FlagBoxImage), sf.graphics.CImage.FlagIntDest))
		
	end
	
	local right = widgets_list["money_label"].GetOffset() + widgets_list["money_label"].GetSize()
	
	local left = widgets_list["money_image"].GetOffset() + building_info_window._disable_table["money"].offset
	
	building_info_window._res_hint_pos = (left + right)/2 
	
	building_info_window._background_image = sf.graphics.CImage(back_ground_id);

	building_info_window._background_image.SetFlags(__or(__or(building_info_window._background_image.GetFlags(), 
																sf.graphics.CImage.FlagBoxImage), sf.graphics.CImage.FlagIntDest))

	building_info_window._background_image.SetRect( sf.misc.FloatRect(0, 0, info_window_size.X, info_window_size.Y))

	
	building_info_window._buy_pos = nil
	building_info_window._buy_size = nil
	
	local buy_button_widget = get_child_widget(building_info_widget, "buy_button", sf.gui.CButtonWidget) 
	if buy_button_widget then
		if buy_button_widget.GetButtonState() == sf.gui.CButtonWidget.StateDisabled then
			building_info_window._buy_pos = buy_button_widget.GetOffset()
			building_info_window._buy_size = buy_button_widget.GetSize()
		end
	end

	building_info_window._sell_pos = nil
	building_info_window._sell_size = nil
	
	return building_info_widget
end

function building_info_window.DoDraw(_this, _renderer)
    if building_info_window._background_image then
        building_info_window._background_image.Draw(_renderer)
    end
    return false
end

function building_info_window.OnMouseDown(_this, _pos, _button, _state, _broadcast)
	if __IsPointInRect( _pos, building_info_window._buy_pos, building_info_window._buy_size)then
		if town_window.GetPlayerLevel() >= town_window._level_for_show_res_tutorial then
			town_window.ShowDisableBuyTutorial(building_info_window._res_hint_pos + _this.GetOffset(), building_info_window._cost_disable)
		end
		return true
	end
	if __IsPointInRect( _pos, building_info_window._sell_pos, building_info_window._sell_size)then
		town_window.ShowDisableSellTutorial(building_info_window._id)	
		return true
	end
    return false
end

function building_info_window.DoUpdate(_this)
    return false    
end

function building_info_window.Load(_this, _info, _templates)
    return false    
end

function building_info_window.OnMouseMove(_this, _pos, _state, _broadcast)
	town_window._hand_cursor = false
	return false
end
----------------------------------------------------------------------------------------
---     
click_catch_widget = {}

function click_catch_widget.__CreateInstance()
    return "click_catch_widget"
end

__inherite(click_catch_widget, null_lua_widget_handler())

function click_catch_widget.OnMouseDown(_this, _pos, _button, _state, _broadcast)
	return true 
end

function click_catch_widget.OnMouseMove(_this, _pos, _state, _broadcast)
	town_window._hand_cursor = false
	if not _broadcast then
		cursor_drop_widget.drop_cursor = true
	end
	return true
end