-- -,    
cost_hint_widget = {}

__inherite(cost_hint_widget, null_lua_widget_handler())

--   
cost_hint_widget.params = 
{
	--  true,       offsets,    (          auto_offset)
	custom_offsets = true,
	
	offsets = 
	{
		green_totem 		= {876,595},
		orange_totem 		= {975,450},
		violet_totem 		= {795,230},
		red_totem 			= {225,560},
		blue_totem 			= {125,365},
		white_totem 		= {522,225},
		yellow_totem 		= {295,220},
		dynamite_bonus 		= {670,565},
		lightning_bonus 	= {800,428},
		time_bonus 			= {610,325},
		hint_bonus 			= {382,376},
		solidarity_bonus 	= {330,445},
		score_mul_bonus 	= {420,330},
		frenzy_time_upgrade = {653,156},
		gems_count_upgrade 	= {505,465},
		level_time_upgrade 	= {485,580}
	},
	
	auto_offset = {0,80},
	
	-- ,     
	widgets = 
	{
		-- 
		--   ("image"),  , ,   
		
		--   
		gray_back =		{ "image", "screens_town_building_info_off", 1, sf.misc.FloatVector(0, 0) },
		--   
		back = 			{ "image", "screens_town_building_info_on", 1, sf.misc.FloatVector(0, 0) },
		--   
		level = 		{ "image", "screens_town_icon_level", 3, sf.misc.FloatVector(6, 4) },		
		--  
		power = 		{ "image", "screens_town_icon_power", 3, sf.misc.FloatVector(61, 2) },
		--  
		coin = 			{ "image", "screens_town_icon_coin", 3, sf.misc.FloatVector(117, 4) },
		--     
		red_frame1 =	{ "image", "screens_town_building_info_disabled", 2, sf.misc.FloatVector(4, 2) },
		--    
		red_frame2 = 	{ "image", "screens_town_building_info_disabled", 2, sf.misc.FloatVector(60, 2) },
		--    
		red_frame3 = 	{ "image", "screens_town_building_info_disabled", 2, sf.misc.FloatVector(116, 2) },
		
		-- 
		--   ("label"),  , ,   
		
		--  -  
		level_label = 	{ "label", "mpc_21_yellow", 3, sf.misc.FloatVector(26, 5) },
		--  - 
		power_label = 	{ "label", "mpc_21_yellow", 3, sf.misc.FloatVector(86, 5) },
		--  - 
		coin_label = 	{ "label", "mpc_21_yellow", 3, sf.misc.FloatVector(145, 5) },
		
		-- 
		--   ("button"),  , ,   
		button_buy = 	{ "button", "screens_town_button_fast_buy", 5, sf.misc.FloatVector(147, 40), "$303" },
	},
	
	-- ,       
	fade_time = 500
}

cost_hint_widget._hints = {}

function cost_hint_widget.__CreateInstance()
    return "cost_hint_widget"
end

--   
cost_hint_widget._create_widget = 
{ 
	-- 
	image = function(_info)
		local image = sf.gui.CImageWidget(_info[2], "", _info[3], 0)
		return image
	end,

	-- 
	label = function(_info)
		local label = sf.gui.CLabelWidget(g_App.GetResourceManager().GetFont(_info[2]), "", "", _info[3], 0)
		return label
	end,

	-- 
	button = function(_info, _id)
		local button = sf.gui.CButtonWidget(sf.graphics.CImage(_info[2]), nil, _id, _info[3], 0)
		if _info[5] then
			button.AddToolTip(_info[5])
		end
		return button
	end
}

function cost_hint_widget.InitHint(_id, _info)
	if not cost_hint_widget._hints[_id] then
		cost_hint_widget._hints[_id] = cost_hint_widget._CreateHint()
	end
	cost_hint_widget._hints[_id]:Init(_id, _info)
end

function cost_hint_widget.ShowHint(_id)
	if cost_hint_widget._hints[_id]._last_level then
		return
	end
	__visible(cost_hint_widget._hints[_id]._widget, true)
end

function cost_hint_widget.HideHint(_id)
	__visible(cost_hint_widget._hints[_id]._widget, false)
end

function cost_hint_widget.FadeInHint(_id)
	cost_hint_widget._hints[_id]:FadeIn()
end

function cost_hint_widget.FadeOutHint(_id)
	cost_hint_widget._hints[_id]:FadeOut()
end

cost_hint_widget._create_labels = false

if not cost_hint_widget._create_labels then
	cost_hint_widget.params.widgets.button_buy[4] = sf.misc.FloatVector(-20, -20)
end

function cost_hint_widget._CreateHint()
	return
	{
		_widget = nil,
		_widgets = {},
		_buyable = true,
		_fade_direct = 1,
		_alpha = 255,
		_last_update = 0,
		_last_level = true,
		
		Init = function(_self, _id, _info)
			
			if not _self._widget then
				_self._widget = sf.gui.CWidget("",0,0)
				
				if cost_hint_widget._create_labels then
					for id,info in pairs(cost_hint_widget.params.widgets) do
						local w = cost_hint_widget._create_widget[info[1]](info, _id)
						w.SetOffset(info[4].X, info[4].Y)
						_self._widget.AddWidget(w)
						_self._widgets[id] = w
					end
				
				else
					info = cost_hint_widget.params.widgets["button_buy"]
					local w = cost_hint_widget._create_widget[info[1]](info, _id)
					w.SetOffset(info[4].X, info[4].Y)
					_self._widget.AddWidget(w)
					_self._widgets["button_buy"] = w
				
				end
				
				--     
				local size = sf.misc.FloatVector(0,0)
				size.X =_self._widgets.button_buy.GetOffset().X + _self._widgets.button_buy.GetSize().X
				size.Y = _self._widgets.button_buy.GetOffset().Y + _self._widgets.button_buy.GetSize().Y
				_self._widget.SetSize(size.X, size.Y)
				
				if cost_hint_widget.params.custom_offsets then
					--    ,   
					local offset = cost_hint_widget.params.offsets[_id]
					_self._widget.SetOffset(offset[1], offset[2])
				else
					--     
					local pos = quest.get_object_pos(_info.building_object_id)
					pos.X = pos.X - size.X / 2 + cost_hint_widget.params.auto_offset[1]
					pos.Y = pos.Y - size.Y / 2 + cost_hint_widget.params.auto_offset[2]
					
					if pos.X < 0 then pos.X = 0 end
					if pos.Y < 0 then pos.Y = 0 end
					if pos.X + size.X > 1024 then pos.X = 1024 - size.X end
					if pos.Y + size.Y > 768 then pos.Y = 768 - size.Y end
					
					_self._widget.SetOffset(pos.X, pos.Y)
				end
				
				cost_hint_widget._this.AddWidget(_self._widget)
			end	
		
			_self._last_level = _info.current_level == 4
			--  /   ,   
			__visible(_self._widget, not _self._last_level)
			_self._buyable = town_window.IsBuyable(_id)
			--     / ...
			if not _self._last_level then
				local town_object = town_info.GetItemInfo(_info.id)
				--  :  ,    
				local costs = town_object.upgrades_cost[_info.current_level + 1]
				
				if cost_hint_widget._create_labels then

					_self._widgets.level_label.SetText(tostring(costs.level_cost))
					_self._widgets.power_label.SetText(tostring(costs.power_cost))
					_self._widgets.coin_label.SetText(tostring(costs.money_cost))
					
					--   ,   ,  
					__visible(_self._widgets.back, _self._buyable)
					--   ,   ,  
					__visible(_self._widgets.gray_back, not _self._buyable)
					
					--    ,   
					__visible(_self._widgets.red_frame1, few_level)
					__visible(_self._widgets.red_frame2, few_power)
					__visible(_self._widgets.red_frame3, few_money)
					
					--  ,   ,  
					__visible(_self._widgets.button_buy, _self._buyable)
				else
					--  ,   ,  
					__visible(_self._widgets.button_buy, _self._buyable)
				
				end
				--    ,   255,  0
				if _self._buyable then
					_self._fade_direct = 1
					_self._alpha = 255
				else
					_self._fade_direct = -1
					_self._alpha = 0
				end
				_self._widget.SetColor(sf.graphics.Color(_self._alpha, 255, 255, 255))
			end
		end,
		
		--   
		Update = function(_self)
			--    ,     ,      .
			if _self._buyable then
				return
			end
			
			local t = cost_hint_widget._timer.Get().GetTime()
			local dt = t - _self._last_update --    
			local ft = cost_hint_widget.params.fade_time --      0  255
			if ft == 0 then ft = dt end --     
			_self._last_update = t --    
			
			--        ,     (  )
			_self._alpha = _self._alpha + _self._fade_direct * 255.0 * (dt / ft)
			if _self._alpha > 255 then _self._alpha = 255 end
			if _self._alpha < 0 then _self._alpha = 0 end
			
			--     
			local c = sf.graphics.Color(_self._widget.GetColor())
			c.Alpha = _self._alpha
			_self._widget.SetColor(c)
		end,
		
		FadeIn = function(_self)
			if not _buyable then
				return
			end
			_self._fade_direct = 1
		end,
		
		FadeOut = function(_self)
			_self._fade_direct = -1
		end
	}
end

function cost_hint_widget.Load(_this, _info, _templates)
	cost_hint_widget._this = _this	
	cost_hint_widget._profile = s11.g_ProfileManager.Instance().GetCurrentProfile().GetClassicData()
	cost_hint_widget._timer = __create_timer()
	cost_hint_widget._hints = {}
	_this.SetSize(1024, 768)
end

function cost_hint_widget.HideHints()
	for _, hint in pairs(cost_hint_widget._hints) do
		local _tool_tip_helper = get_child_widget(hint._widgets.button_buy, "ToolTipHelperWidget", sf.gui.CToolTipHelperWidget, "  ") 
		_tool_tip_helper.StopShowToolTip()
	end
end

function cost_hint_widget.DoUpdate(_this)
	for _, hint in pairs(cost_hint_widget._hints) do
		hint:Update()
	end
	return false
end

function cost_hint_widget.DoDraw(_this, _renderer)
    return false
end

function cost_hint_widget.OnMouseMove(_this, _pos, _state, _broadcast)
    return false
end

function cost_hint_widget.OnMouseUp(_this, _pos, _button, _state, _broadcast)
    return false
end

function cost_hint_widget.OnMouseDown(_this, _pos, _button, _state, _broadcast)
    return false
end

function cost_hint_widget.OnDoubleClick(_this, _pos, _state, _broadcast)
    return true
end

function cost_hint_widget.OnChildAction(_this, _action, _child)
	if _child and _action.c_str() == "pressed" then
		local _tool_tip_helper = get_child_widget(_child, "ToolTipHelperWidget", sf.gui.CToolTipHelperWidget, "  ") 
		_tool_tip_helper.StopShowToolTip()
		local id = _child.GetId().c_str()
		town_window.BuyItem(id)
		town_window._CloseBuildingInfoWindow()
		town_window._self.HideToolTip()
	end
	return false
end
