town_info = {}
--        

--  ,   
function town_info.GetResourcesTable(_id, _profile)
	
	local _info_table = {}
	
	local building_level = _profile.GetItemLevel(_id)
	if building_level == -1 then
		__message("town_info.IsBuyable : Unknown object ".._id)
		return _info_table
	end

	if building_level >= 4 then
		return _info_table
	end
	local town_object = town_info.GetItemInfo(_id)
	if not town_object then
		__message(_id .. "   ")
		return _info_table
	end
	
	local buyable_flag = true
	local upgrade_info = town_object.upgrades_cost[building_level + 1]
	if upgrade_info.money_cost > _profile.GetMoney() then
		_info_table["money"] = true
		buyable_flag = false
	end					
	--if upgrade_info.power_cost > _profile.GetPower() then
		--_info_table["power"] = true
		--buyable_flag = false
	--end					
	if upgrade_info.level_cost > _profile.GetPlayerLevel() then
		buyable_flag = false
		_info_table["level"] = true
		
		if _profile.GetFinishedLevels() >= upgrade_info.level_cost then
			_info_table["level_low"] = true
		else
			_info_table["level_target"] = upgrade_info.level_cost
		
		end
	end	
	
	return _info_table, buyable_flag
end

--   
function town_info.IsBuyable(_id, _profile)
	
	local building_level = _profile.GetItemLevel(_id)
	if building_level == -1 then
		__message("town_info.IsBuyable : Unknown object ".._id)
		return flase
	end

	if building_level >= 4 then
		return flase
	end
	local town_object = town_info.GetItemInfo(_id)
	if not town_object then
		__message(_id .. "   ")
		return false
	end
	local upgrade_info = town_object.upgrades_cost[building_level + 1]
	return upgrade_info.money_cost <= town_window._current_profile.GetMoney()
		--and upgrade_info.power_cost <= town_window._current_profile.GetPower()
			and upgrade_info.level_cost <= town_window._current_profile.GetPlayerLevel()
end

--      ()
function town_info.GetItemInfo(_id)
	return town_info._items_info[_id]
end

--           
function town_info.FormEmptyBuildingsTable()
	local res_table = {}

	---    
	for id,_ in pairs(town_info._items_info) do
		res_table[id] = {}
		res_table[id].id = id
	end
	
	return res_table
end

--     
function town_info._LoadConstants()
	---    
	local town_group = g_App.GetSettings().GetChild("Town", false)
	if not town_group then
		__message("Town info not found")
		return
	end

	town_info._items_info = {}
	
	local def_power_cost = tonumber(town_group.GetValue("def_power_cost").c_str()) or 1
	
	---   
	local building_info = town_group.GetChildRef("building", false)
	while building_info do
		local id = building_info.GetValue("linked_item_id").c_str()
		local name = building_info.GetValue("name")

		local new_building_info = {}
		town_info._items_info[id] = new_building_info
		
		new_building_info.id = id
		new_building_info.caption = name
		new_building_info.current_level = 0
		new_building_info.icon_id = building_info.GetValue("building_icon").c_str()
		new_building_info.icon_off_id = building_info.GetValue("building_icon_off").c_str()
		new_building_info.upgrades_cost = {}
		
		---    
		local index = 1
		local level = building_info.GetChildRef("level", false)
		while level do
			---      
			local new_upgrade = {}
			
			---      
			if level.GetValue("forbid_sell").c_str() == "true" then
				new_upgrade.forbid_sell = true
			end
			---  ""     
			new_upgrade.money_cost = tonumber(level.GetValue("cost").c_str())
			new_upgrade.power_cost = tonumber(level.GetValue("power_cost").c_str()) or def_power_cost
			new_upgrade.level_cost = tonumber(level.GetValue("char_level").c_str())
			if not new_upgrade.power_cost then
				new_upgrade.power_cost = 0
			end
			new_upgrade.level_cost = tonumber(level.GetValue("char_level").c_str())
			---    
			new_upgrade.future_action = level.GetValue("fut_act")
			new_upgrade.current_action = level.GetValue("cur_act")
			
			---   
			new_building_info.upgrades_cost[index] = new_upgrade

			index = index + 1
			level = level.GetNextSiblingRef()
		end
		building_info = building_info.GetNextSiblingRef()
	end
end

town_info._LoadConstants()
