function log(str)
	print(str)
	io.flush()
end

g_App = sf.core.g_Application
g_Lua = sf.lua.CLua.GetLua("main")

main = {}
g_Lua.LoadScript("scripts/misc.lua")


g_Lua.LoadScript("scripts/qe_lite/quest.lua")

load_lua_scripts("scripts/game/")

load_lua_scripts("scripts/game/common/")
load_lua_scripts("scripts/game/gameplay/")
load_lua_scripts("scripts/game/adventure/")
load_lua_scripts("scripts/game/map/")

--   
load_lua_scripts("scripts/game/totems/")

--  endless
load_lua_scripts("scripts/game/endless/")

--   puzzle
load_lua_scripts("scripts/game/puzzle/")
--  hog
load_lua_scripts("scripts/game/hog/")
--  town
load_lua_scripts("scripts/game/town/")

function Init()
end


function OnClose()
	s11.g_RecordTable.Instance().Save()
	s11.g_ProfileManager.Instance().Save()
end

function OnActivate(_activate)
	if not _activate then
		if not sf.core.g_Application.GetTopWindow() or not sf.core.g_Application.GetTopWindow().get() then
				return
		end
		local window = sf.core.g_Application.GetTopWindow().get()
		local window_id = window.GetId().c_str()
		if window_id == "game_window" then
			game_window.ShowMenu()
			return
		end
		if window_id == "hog_window" then
			hog_menu_window.Show(window)
			return
		end
		--     endless 
		if window_id == "endless_window" then
			endless_window.ShowMenu()
			return
		end
		
		if window_id == "puzzle_window" then
			puzzle_window.ShowMenu()
			return
		end
		
	end
end

function Run()
	---s11.effects.LoadEffectsSettings()
	s11.g_GameOptions.Instance().ApplyOptionsChanges()
    s11.g_GameOptions.Instance().ApplyMusicChanges()

	
	--g_Quest.Instance().Load()
	--g_QuestData = qe.CQuest() 
	--g_QuestData.Load()
	
	---s11.g_SystemMenu.Instance().Load()
	---s11.g_GameStruct.Instance().Load()
    
	
	qe.g_LuaThreadManager.Instance().SetLua(g_Lua)
	
	local level_timer = sf.core.g_Application.GetTimeManager().AttachTimer("qe_level", sf.core.g_Application.GetTimeManager().GetTimer("game_timer"))
	local script_timer = level_timer.AttachTimer("qe_script_timer")
	
	qe.g_LuaThreadManager.Instance().SetTimer(script_timer)

   
	--s11.g_TrackManager.Instance().LoadOptions()
	
	---s11.g_GameBackground.Instance().LoadSettings()
	
	main_menu.Show(true, nil, true)

end

function MoveWindowToCenter(_owner, _child_window)
	local owner_size = _owner.GetSize()
	local owner_offset = _owner.GetOffset()
	local child_size = _child_window.GetSize()
	_child_window.SetOffset(owner_size.X/2 - child_size.X/2, owner_size.Y/2 - child_size.Y/2)
end

game_background = {}

function game_background.Init()
	local chapter_index = 0
	local level_index_in_chapter = 0
	
	local profile = s11.g_ProfileManager.Instance().GetCurrentProfile()
	if profile then
		profile = profile.GetClassicData()
		if profile.HasSavedLevelInfo() then
			local dif_level = profile.GetSavedLevelDifficulty()
			local level_index = profile.GetSavedLevelIndex()
			local level = s11.g_GameStruct.Instance().GetLevelsSystem(s11.CGameStruct.GameTypeClassic).GetLevel(dif_level, level_index)
			if level then
				chapter_index = level.GetChapterIndex()
				level_index_in_chapter = level.GetLevelIndexInChapter()
			end
		end
	end
	
	s11.g_GameBackground.Instance().Init(chapter_index, level_index_in_chapter)
end

function game_background.SetUseClip(_value)
	s11.g_GameBackground.Instance().SetUseClip(_value)
end

function game_background.Update()
	s11.g_GameBackground.Instance().Update()
end

function game_background.Draw(_renderer)
	s11.g_GameBackground.Instance().Draw(_renderer)
end
