modifers = modifers or {}
modifers.def_slep_on_hide_show = true
modifers.def_time_for_hide_show = 300

function modifers.hide(_object, _do_not_assert)
    modifers.hide_ex(nil, nil, _object, _do_not_assert)
end

function modifers.hide_ex(_momental, _sleep, _object, _do_not_assert)
    if _momental == nil then
        _momental = modifers.def_time_for_hide_show
    end
    if _sleep == nil then
        _sleep = modifers.def_slep_on_hide_show
    end
    local current_object = g_QuestState.GetScriptObject() 
    if _object ~= nil then
        current_object = quest.FindObjectById(_object)
        if not _do_not_assert then        
            quest.show_object_find_error(_object, current_object)
        end
    end
    if current_object then
        if current_object.ReadObjectFlag(qe.CBaseSceneObject.ObjectFlagHidden) == false then
            current_object.RaiseObjectFlag(qe.CBaseSceneObject.ObjectFlagHidden)
            if _momental > 0 then
                qe.g_EffectsList.Instance().AddEffect(qe.CAlphaEffect(current_object, false, false, _momental, nil))--g_QuestState.GetLevelTimer().Get())) 
                if _sleep == true then
                    sleep(_momental)
                end            
            end
        end        
    end
end

function modifers.show(_object, _do_not_assert)
    modifers.show_ex(nil, nil, _object, _do_not_assert)
end

function modifers.show_ex(_momental, _sleep, _object, _do_not_assert)
    if _momental == nil then
        _momental = modifers.def_time_for_hide_show
    end
    if _sleep == nil then
        _sleep = modifers.def_slep_on_hide_show
    end
    
    local current_object = g_QuestState.GetScriptObject() 
    if _object ~= nil then
        current_object = quest.FindObjectById(_object)
        if not _do_not_assert then        
            quest.show_object_find_error(_object, current_object)
        end
    end
    if current_object then
        if current_object.ReadObjectFlag(qe.CBaseSceneObject.ObjectFlagHidden) == true then
            current_object.ClearObjectFlag(qe.CBaseSceneObject.ObjectFlagHidden)
            if _momental > 0 then
                qe.g_EffectsList.Instance().AddEffect(qe.CAlphaEffect(current_object, true, false, _momental, nil))--g_QuestState.GetLevelTimer().Get()))
                if _sleep == true then
                    sleep(_momental)
                end            
            end
        end
    end
end

function modifers.disable(_object, _do_not_assert)
    local current_object = g_QuestState.GetScriptObject() 
    if _object ~= nil then
        current_object = quest.FindObjectById(_object)
        if not _do_not_assert then        
            quest.show_object_find_error(_object, current_object)
        end
    end
    if current_object then
        current_object.RaiseObjectFlag(qe.CBaseSceneObject.ObjectFlagDisable)
    end
end

function modifers.enable(_object, _do_not_assert)
    local current_object = g_QuestState.GetScriptObject() 
    if _object ~= nil then
        current_object = quest.FindObjectById(_object)
        if not _do_not_assert then        
            quest.show_object_find_error(_object, current_object)
        end
    end
    if current_object then
        current_object.ClearObjectFlag(qe.CBaseSceneObject.ObjectFlagDisable)
    end
end

function modifers.play_clip(_object, _delay, _do_not_assert)
    local current_object = nil

    current_object = g_QuestState.GetScriptObject()
    if _object ~= nil then
       current_object = quest.FindObjectById(_object)
       if not _do_not_assert then        
           quest.show_object_find_error(_object, current_object)
       end

    end
    if current_object then
        local clip_object = __cast(current_object, qe.CClipObject )
        if clip_object ~= nil then
            local clip_time = clip_object.GetClipTime()
            if _delay ~= nil and type(_delay) == "number" then
                clip_time = _delay
            end
            if clip_time >= 0 or clip_time > 0 and _delay ~= nil then
                clip_object.Stop()
                clip_object.Play()
                Wait(clip_time)
            end
        else
            local image_object = __cast(current_object, qe.CImageObject )
            if image_object ~= nil then
                local image_time = image_object.GetTotalTime()
                if _delay ~= nil and type(_delay) == "number" and _delay > 0 then
                    image_time = _delay
                end
                if image_time > 0 then
                    image_object.PlayFromStart()
                    Wait(image_time)
                end
            end
        end
    end
end

function modifers.is_hide(_object, _do_not_assert)
    if _object ~= nil then
        current_object = quest.FindObjectById(_object)
        if not _do_not_assert then        
            quest.show_object_find_error(_object, current_object)
        end
    end
    if current_object then
        return current_object.ReadObjectFlag(qe.CBaseSceneObject.ObjectFlagHidden)
    else
        return false
    end
end

function modifers.is_disable(_object, _do_not_assert)
    if _object ~= nil then
        current_object = quest.FindObjectById(_object)
        if not _do_not_assert then        
            quest.show_object_find_error(_object, current_object)
        end
    end
    if current_object then
        return current_object.ReadObjectFlag(qe.CBaseSceneObject.ObjectFlagDisable)
    else
        return false
    end
end
