save_game = save_game or {}

function save_game.SaveLevelInfo(_file_name, _game_info_save_function)
    if g_QuestState.GetCurrentLevel() then
        threads_managment.InterruptClickScript()
        local xml_writer =  sf.misc.CXmlWriter() 
        local root_xml_element = sf.misc.CXmlElement ( xml_writer, "Save")
        local level_info = sf.misc.CXmlElement ( root_xml_element, "LevelInfo")
        level_info.Attr("current_scene", g_QuestState.GetCurrentScene().GetId().c_str() )
        g_QuestState.GetCurrentLevel().Save(level_info, true)
        level_info.Flush()

		
		if _game_info_save_function then

			local   game_info = sf.misc.CXmlElement ( root_xml_element, "GameInfo")
			_game_info_save_function(game_info)
			game_info.Flush()		
		end
        root_xml_element.Flush()
        xml_writer.SaveToFile(_file_name)
        sf.misc.SetNamedFullAccess(_file_name, false)
    end
end

function save_game.CopyObjectInfo(_dst_object, _src_object)
    _dst_object.SetObjectFlags(_src_object.GetObjectFlags())
    _dst_object.SetHint(_src_object.GetHint())
end

function save_game.CopyBaseObjectInfo(_dst_object, _src_object)
    assert(_dst_object.GetType() == _src_object.GetType())    
    local id = _dst_object.GetId().c_str()
    
    if _dst_object.GetType() == qe.CBaseSceneObject.GroupType then
        save_game.CopyObjectInfo(_dst_object, _src_object)
        local src_object =  __cast(_src_object, qe.CSceneGroup)
        local dst_object =  __cast(_dst_object, qe.CSceneGroup)
        local src_object_child = src_object.GetChilds()
        while not src_object_child.IsEnd() do
            local dst_child = dst_object.GetStateById(src_object_child.Get().GetId())
            if dst_child then
                save_game.CopyObjectInfo(dst_child, src_object_child.Get())
            end
            src_object_child.Next()
        end
    else
        save_game.CopyObjectInfo(_dst_object, _src_object)
    end
end

function save_game.Load(_load_file_name, _game_info_load_function)
    local load_group = sf.core.CSettings()
    load_group.LoadXml(_load_file_name)
    local save_group = load_group.GetChildRef("Save", false)
    local loaded_level = nil
    if save_group then


        local level_info = save_group.GetChildRef("LevelInfo", false)
        if level_info then
            local level_group = level_info.GetFirstChildRef()
            if level_group then
                loaded_level = qe.CLevel() 
                loaded_level.Load(level_group, true)
            end
        end                


        if loaded_level then

            local original_level_scene = g_QuestState.GetCurrentLevel().GetScenes()
            while not original_level_scene.IsEnd() do
                local original_scene = original_level_scene.Get()
                local loaded_scene = loaded_level.GetSceneById(original_scene.GetId())
                local original_scene_child = original_scene.GetObjects()
       
                while not original_scene_child.IsEnd() do
                    local loaded_child = loaded_scene.IsContentObject(original_scene_child.Get().GetId())
                    if loaded_child ~= nil then
                        save_game.CopyBaseObjectInfo(original_scene_child.Get(), loaded_child)
                    end
                    original_scene_child.Next()
                end

                local original_scene_area = original_scene.GetAreas()
       
                while not original_scene_area.IsEnd() do
                    local loaded_area = loaded_scene.IsContentArea(original_scene_area.Get().GetId())
                    if loaded_area ~= nil then
                        save_game.CopyBaseObjectInfo(original_scene_area.Get(), loaded_area)
                    end
                    original_scene_area.Next()
                end

                original_level_scene.Next()
            end
			if _game_info_load_function then
				local game_info = save_group.GetChildRef("GameInfo", false)
				if game_info then
					_game_info_load_function(game_info)
				end
			end
        end
    end
end

