/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import net.minecraftforge.common.ForgeDirection;

public class RotationHelper {
    private static final ForgeDirection[] UP_DOWN_AXES = new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN};

    public static ForgeDirection[] getValidVanillaBlockRotations(aqs block) {
        return block instanceof and ? UP_DOWN_AXES : ForgeDirection.VALID_DIRECTIONS;
    }

    public static boolean rotateVanillaBlock(aqs block, abr worldObj, int x2, int y, int z, ForgeDirection axis) {
        if (worldObj.I) {
            return false;
        }
        if (block instanceof and && (axis == ForgeDirection.UP || axis == ForgeDirection.DOWN)) {
            return RotationHelper.rotateBlock(worldObj, x2, y, z, axis, 7);
        }
        if (block instanceof asm || block instanceof ant || block instanceof anr) {
            return RotationHelper.rotateBlock(worldObj, x2, y, z, axis, 7);
        }
        return false;
    }

    private static boolean rotateBlock(abr worldObj, int x2, int y, int z, ForgeDirection axis, int mask) {
        int rotMeta = worldObj.h(x2, y, z);
        int masked = rotMeta & ~mask;
        ForgeDirection orientation = ForgeDirection.getOrientation(rotMeta & mask);
        ForgeDirection rotated = orientation.getRotation(axis);
        worldObj.b(x2, y, z, rotated.ordinal() & mask | masked, 3);
        return true;
    }
}

