/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.oredict;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class OreDictionary {
    private static boolean hasInit = false;
    private static int maxID = 0;
    private static HashMap<String, Integer> oreIDs = new HashMap();
    private static HashMap<Integer, ArrayList<xz>> oreStacks = new HashMap();
    public static final int WILDCARD_VALUE = Short.MAX_VALUE;

    public static void initVanillaEntries() {
        if (!hasInit) {
            OreDictionary.registerOre("logWood", new xz(aqs.O, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("plankWood", new xz(aqs.C, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("slabWood", new xz((aqs)aqs.bT, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("stairWood", aqs.ay);
            OreDictionary.registerOre("stairWood", aqs.cc);
            OreDictionary.registerOre("stairWood", aqs.cd);
            OreDictionary.registerOre("stairWood", aqs.cb);
            OreDictionary.registerOre("stickWood", xx.F);
            OreDictionary.registerOre("treeSapling", new xz(aqs.D, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("treeLeaves", new xz((aqs)aqs.P, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("oreGold", aqs.L);
            OreDictionary.registerOre("oreIron", aqs.M);
            OreDictionary.registerOre("oreLapis", aqs.S);
            OreDictionary.registerOre("oreDiamond", aqs.aB);
            OreDictionary.registerOre("oreRedstone", aqs.aS);
            OreDictionary.registerOre("oreEmerald", aqs.bW);
            OreDictionary.registerOre("oreQuartz", aqs.cu);
        }
        HashMap<xz, String> replacements = new HashMap<xz, String>();
        replacements.put(new xz(aqs.C, 1, Short.MAX_VALUE), "plankWood");
        replacements.put(new xz(xx.F), "stickWood");
        String[] dyes = new String[]{"dyeBlack", "dyeRed", "dyeGreen", "dyeBrown", "dyeBlue", "dyePurple", "dyeCyan", "dyeLightGray", "dyeGray", "dyePink", "dyeLime", "dyeYellow", "dyeLightBlue", "dyeMagenta", "dyeOrange", "dyeWhite"};
        for (int i = 0; i < 16; ++i) {
            xz dye = new xz(xx.aY, 1, i);
            if (!hasInit) {
                OreDictionary.registerOre(dyes[i], dye);
            }
            replacements.put(dye, dyes[i]);
        }
        hasInit = true;
        xz[] replaceStacks = replacements.keySet().toArray(new xz[replacements.keySet().size()]);
        xz[] exclusions = new xz[]{new xz(aqs.T), new xz(xx.be)};
        List recipes = aaa.a().b();
        ArrayList<Object> recipesToRemove = new ArrayList<Object>();
        ArrayList<Object> recipesToAdd = new ArrayList<Object>();
        for (Object obj : recipes) {
            xz output;
            aad recipe;
            if (obj instanceof aad) {
                recipe = (aad)obj;
                output = recipe.b();
                if (output != null && OreDictionary.containsMatch(false, exclusions, output) || !OreDictionary.containsMatch(true, recipe.d, replaceStacks)) continue;
                recipesToRemove.add(recipe);
                recipesToAdd.add(new ShapedOreRecipe(recipe, replacements));
                continue;
            }
            if (!(obj instanceof aae) || (output = (recipe = (aae)obj).b()) != null && OreDictionary.containsMatch(false, exclusions, output) || !OreDictionary.containsMatch(true, recipe.b.toArray(new xz[recipe.b.size()]), replaceStacks)) continue;
            recipesToRemove.add((aac)obj);
            ShapelessOreRecipe newRecipe = new ShapelessOreRecipe((aae)recipe, replacements);
            recipesToAdd.add(newRecipe);
        }
        recipes.removeAll(recipesToRemove);
        recipes.addAll(recipesToAdd);
        if (recipesToRemove.size() > 0) {
            System.out.println("Replaced " + recipesToRemove.size() + " ore recipies");
        }
    }

    public static int getOreID(String name) {
        Integer val = oreIDs.get(name);
        if (val == null) {
            val = maxID++;
            oreIDs.put(name, val);
            oreStacks.put(val, new ArrayList());
        }
        return val;
    }

    public static String getOreName(int id) {
        for (Map.Entry<String, Integer> entry : oreIDs.entrySet()) {
            if (id != entry.getValue()) continue;
            return entry.getKey();
        }
        return "Unknown";
    }

    public static int getOreID(xz itemStack) {
        if (itemStack == null) {
            return -1;
        }
        for (Map.Entry<Integer, ArrayList<xz>> ore : oreStacks.entrySet()) {
            for (xz target : ore.getValue()) {
                if (itemStack.d != target.d || target.k() != Short.MAX_VALUE && itemStack.k() != target.k()) continue;
                return ore.getKey();
            }
        }
        return -1;
    }

    public static ArrayList<xz> getOres(String name) {
        return OreDictionary.getOres(OreDictionary.getOreID(name));
    }

    public static String[] getOreNames() {
        return oreIDs.keySet().toArray(new String[oreIDs.keySet().size()]);
    }

    public static ArrayList<xz> getOres(Integer id) {
        ArrayList<Object> val = oreStacks.get(id);
        if (val == null) {
            val = new ArrayList();
            oreStacks.put(id, val);
        }
        return val;
    }

    private static boolean containsMatch(boolean strict, xz[] inputs, xz ... targets) {
        for (xz input : inputs) {
            for (xz target : targets) {
                if (!OreDictionary.itemMatches(target, input, strict)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean itemMatches(xz target, xz input, boolean strict) {
        if (input == null && target != null || input != null && target == null) {
            return false;
        }
        return target.d == input.d && (target.k() == Short.MAX_VALUE && !strict || target.k() == input.k());
    }

    public static void registerOre(String name, xx ore) {
        OreDictionary.registerOre(name, new xz(ore));
    }

    public static void registerOre(String name, aqs ore) {
        OreDictionary.registerOre(name, new xz(ore));
    }

    public static void registerOre(String name, xz ore) {
        OreDictionary.registerOre(name, OreDictionary.getOreID(name), ore);
    }

    public static void registerOre(int id, xx ore) {
        OreDictionary.registerOre(id, new xz(ore));
    }

    public static void registerOre(int id, aqs ore) {
        OreDictionary.registerOre(id, new xz(ore));
    }

    public static void registerOre(int id, xz ore) {
        OreDictionary.registerOre(OreDictionary.getOreName(id), id, ore);
    }

    private static void registerOre(String name, int id, xz ore) {
        ArrayList<xz> ores = OreDictionary.getOres(id);
        ore = ore.m();
        ores.add(ore);
        MinecraftForge.EVENT_BUS.post(new OreRegisterEvent(name, ore));
    }

    static {
        OreDictionary.initVanillaEntries();
    }

    public static class OreRegisterEvent
    extends Event {
        public final String Name;
        public final xz Ore;

        public OreRegisterEvent(String name, xz ore) {
            this.Name = name;
            this.Ore = ore;
        }
    }
}

