/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.oredict;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.oredict.OreDictionary;

public class ShapedOreRecipe
implements aac {
    private static final int MAX_CRAFT_GRID_WIDTH = 3;
    private static final int MAX_CRAFT_GRID_HEIGHT = 3;
    private xz output = null;
    private Object[] input = null;
    private int width = 0;
    private int height = 0;
    private boolean mirrored = true;

    public ShapedOreRecipe(aqs result, Object ... recipe) {
        this(new xz(result), recipe);
    }

    public ShapedOreRecipe(xx result, Object ... recipe) {
        this(new xz(result), recipe);
    }

    public ShapedOreRecipe(xz result, Object ... recipe) {
        this.output = result.m();
        String shape = "";
        int idx = 0;
        if (recipe[idx] instanceof Boolean) {
            this.mirrored = (Boolean)recipe[idx];
            if (recipe[idx + 1] instanceof Object[]) {
                recipe = (Object[])recipe[idx + 1];
            } else {
                idx = 1;
            }
        }
        if (recipe[idx] instanceof String[]) {
            String[] parts = (String[])recipe[idx++];
            for (String s : parts) {
                this.width = s.length();
                shape = shape + (String)s;
            }
            this.height = parts.length;
        } else {
            while (recipe[idx] instanceof String) {
                String s = (String)recipe[idx++];
                shape = shape + s;
                this.width = s.length();
                ++this.height;
            }
        }
        if (this.width * this.height != shape.length()) {
            String ret = "Invalid shaped ore recipe: ";
            for (Object tmp : recipe) {
                ret = ret + tmp + ", ";
            }
            ret = ret + this.output;
            throw new RuntimeException(ret);
        }
        HashMap<Character, Object> itemMap = new HashMap<Character, Object>();
        while (idx < recipe.length) {
            Character chr = (Character)recipe[idx];
            Object in = recipe[idx + 1];
            if (in instanceof xz) {
                itemMap.put(chr, ((xz)in).m());
            } else if (in instanceof xx) {
                itemMap.put(chr, new xz((xx)in));
            } else if (in instanceof aqs) {
                itemMap.put(chr, new xz((aqs)in, 1, Short.MAX_VALUE));
            } else if (in instanceof String) {
                itemMap.put(chr, OreDictionary.getOres((String)in));
            } else {
                String ret = "Invalid shaped ore recipe: ";
                for (Object tmp : recipe) {
                    ret = ret + tmp + ", ";
                }
                ret = ret + this.output;
                throw new RuntimeException(ret);
            }
            idx += 2;
        }
        this.input = new Object[this.width * this.height];
        int x = 0;
        for (char chr : shape.toCharArray()) {
            this.input[x++] = itemMap.get(Character.valueOf(chr));
        }
    }

    ShapedOreRecipe(aad recipe, Map<xz, String> replacements) {
        this.output = recipe.b();
        this.width = recipe.b;
        this.height = recipe.c;
        this.input = new Object[recipe.d.length];
        block0: for (int i = 0; i < this.input.length; ++i) {
            xz ingred = recipe.d[i];
            if (ingred == null) continue;
            this.input[i] = recipe.d[i];
            for (Map.Entry<xz, String> replace : replacements.entrySet()) {
                if (!OreDictionary.itemMatches(replace.getKey(), ingred, true)) continue;
                this.input[i] = OreDictionary.getOres(replace.getValue());
                continue block0;
            }
        }
    }

    public xz a(vf var1) {
        return this.output.m();
    }

    public int a() {
        return this.input.length;
    }

    public xz b() {
        return this.output;
    }

    public boolean a(vf inv, abr world) {
        for (int x = 0; x <= 3 - this.width; ++x) {
            for (int y = 0; y <= 3 - this.height; ++y) {
                if (this.checkMatch(inv, x, y, false)) {
                    return true;
                }
                if (!this.mirrored || !this.checkMatch(inv, x, y, true)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(vf inv, int startX, int startY, boolean mirror) {
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                int subX = x - startX;
                int subY = y - startY;
                Object target = null;
                if (subX >= 0 && subY >= 0 && subX < this.width && subY < this.height) {
                    target = mirror ? this.input[this.width - subX - 1 + subY * this.width] : this.input[subX + subY * this.width];
                }
                xz slot = inv.b(x, y);
                if (target instanceof xz) {
                    if (this.checkItemEquals((xz)target, slot)) continue;
                    return false;
                }
                if (target instanceof ArrayList) {
                    boolean matched = false;
                    for (xz item : (ArrayList)target) {
                        matched = matched || this.checkItemEquals(item, slot);
                    }
                    if (matched) continue;
                    return false;
                }
                if (target != null || slot == null) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkItemEquals(xz target, xz input) {
        if (input == null && target != null || input != null && target == null) {
            return false;
        }
        return target.d == input.d && (target.k() == Short.MAX_VALUE || target.k() == input.k());
    }

    public ShapedOreRecipe setMirrored(boolean mirror) {
        this.mirrored = mirror;
        return this;
    }

    public Object[] getInput() {
        return this.input;
    }
}

