/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.asm;

import cpw.mods.fml.common.CertificateHelper;
import cpw.mods.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import cpw.mods.fml.common.patcher.ClassPatchManager;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import cpw.mods.fml.relauncher.IFMLCallHook;
import java.io.File;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.Map;
import javax.swing.JOptionPane;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;

public class FMLSanityChecker
implements IFMLCallHook {
    private static final String FMLFINGERPRINT = "51:0A:FB:4C:AF:A4:A0:F2:F5:CF:C5:0E:B4:CC:3C:30:24:4A:E3:8E".toLowerCase().replace(":", "");
    private static final String FORGEFINGERPRINT = "DE:4C:F8:A3:F3:BC:15:63:58:10:04:4C:39:24:0B:F9:68:04:EA:7D".toLowerCase().replace(":", "");
    private LaunchClassLoader cl;

    @Override
    public Void call() throws Exception {
        byte[] mlClass;
        CodeSource codeSource = this.getClass().getProtectionDomain().getCodeSource();
        boolean goodFML = false;
        if (codeSource.getLocation().getProtocol().equals("jar")) {
            Certificate[] certificates = codeSource.getCertificates();
            if (certificates != null) {
                for (Certificate cert : certificates) {
                    String fingerprint = CertificateHelper.getFingerprint(cert);
                    if (fingerprint.equals(FMLFINGERPRINT)) {
                        FMLRelaunchLog.info("Found valid fingerprint for FML. Certificate fingerprint %s", fingerprint);
                        goodFML = true;
                        continue;
                    }
                    if (fingerprint.equals(FORGEFINGERPRINT)) {
                        FMLRelaunchLog.info("Found valid fingerprint for Minecraft Forge. Certificate fingerprint %s", fingerprint);
                        goodFML = true;
                        continue;
                    }
                    FMLRelaunchLog.severe("Found invalid fingerprint for FML: %s", fingerprint);
                }
            }
        } else {
            goodFML = true;
        }
        if (!goodFML) {
            FMLRelaunchLog.severe("FML appears to be missing any signature data. This is not a good thing", new Object[0]);
        }
        if ((mlClass = this.cl.getClassBytes("ModLoader")) == null) {
            return null;
        }
        MLDetectorClassVisitor mlTester = new MLDetectorClassVisitor();
        ClassReader cr = new ClassReader(mlClass);
        cr.accept((ClassVisitor)mlTester, 1);
        if (!mlTester.foundMarker) {
            JOptionPane.showMessageDialog(null, "<html>CRITICAL ERROR<br/>ModLoader was detected in this environment<br/>ForgeModLoader cannot be installed alongside ModLoader<br/>All mods should work without ModLoader being installed<br/>Because ForgeModLoader is 100% compatible with ModLoader<br/>Re-install Minecraft Forge or Forge ModLoader into a clean<br/>jar and try again.", "ForgeModLoader critical error", 0);
            throw new RuntimeException("Invalid ModLoader class detected");
        }
        return null;
    }

    @Override
    public void injectData(Map<String, Object> data) {
        this.cl = (LaunchClassLoader)data.get("classLoader");
        File mcDir = (File)data.get("mcLocation");
        FMLDeobfuscatingRemapper.INSTANCE.setup(mcDir, this.cl, (String)data.get("deobfuscationFileName"));
        File binpatches = new File(mcDir, "binpatch");
        ClassPatchManager.INSTANCE.setup(FMLLaunchHandler.side());
    }

    static class MLDetectorClassVisitor
    extends ClassVisitor {
        private boolean foundMarker = false;

        private MLDetectorClassVisitor() {
            super(262144);
        }

        public FieldVisitor visitField(int arg0, String arg1, String arg2, String arg3, Object arg4) {
            if ("fmlMarker".equals(arg1)) {
                this.foundMarker = true;
            }
            return null;
        }
    }
}

