/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.discovery;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.MetadataCollection;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModContainerFactory;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.discovery.ITypeDiscoverer;
import cpw.mods.fml.common.discovery.ModCandidate;
import cpw.mods.fml.common.discovery.asm.ASMModParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.zip.ZipEntry;

public class JarDiscoverer
implements ITypeDiscoverer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ModContainer> discover(ModCandidate candidate, ASMDataTable table) {
        ArrayList foundMods = Lists.newArrayList();
        FMLLog.fine("Examining file %s for potential mods", candidate.getModContainer().getName());
        JarFile jar = null;
        try {
            jar = new JarFile(candidate.getModContainer());
            if (jar.getManifest() != null && jar.getManifest().getMainAttributes().get("FMLCorePlugin") != null) {
                FMLLog.finest("Ignoring coremod %s", candidate.getModContainer());
                ArrayList arrayList = foundMods;
                return arrayList;
            }
            ZipEntry modInfo = jar.getEntry("mcmod.info");
            MetadataCollection mc = null;
            if (modInfo != null) {
                FMLLog.finer("Located mcmod.info file in file %s", candidate.getModContainer().getName());
                mc = MetadataCollection.from(jar.getInputStream(modInfo), candidate.getModContainer().getName());
            } else {
                FMLLog.fine("The mod container %s appears to be missing an mcmod.info file", candidate.getModContainer().getName());
                mc = MetadataCollection.from(null, "");
            }
            for (ZipEntry zipEntry : Collections.list(jar.entries())) {
                ASMModParser modParser;
                Matcher match;
                if (zipEntry.getName() != null && zipEntry.getName().startsWith("__MACOSX") || !(match = classFile.matcher(zipEntry.getName())).matches()) continue;
                try {
                    modParser = new ASMModParser(jar.getInputStream(zipEntry));
                }
                catch (LoaderException e) {
                    FMLLog.log(Level.SEVERE, e, "There was a problem reading the entry %s in the jar %s - probably a corrupt zip", zipEntry.getName(), candidate.getModContainer().getPath());
                    jar.close();
                    throw e;
                }
                modParser.validate();
                modParser.sendToTable(table, candidate);
                ModContainer container = ModContainerFactory.instance().build(modParser, candidate.getModContainer(), candidate);
                if (container == null) continue;
                table.addContainer(container);
                foundMods.add(container);
                container.bindMetadata(mc);
            }
        }
        catch (Exception e) {
            FMLLog.log(Level.WARNING, e, "Zip file %s failed to read properly, it will be ignored", candidate.getModContainer().getName());
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (Exception e) {}
            }
        }
        return foundMods;
    }
}

