/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;

public class ChestGenHooks {
    public static final String MINESHAFT_CORRIDOR = "mineshaftCorridor";
    public static final String PYRAMID_DESERT_CHEST = "pyramidDesertyChest";
    public static final String PYRAMID_JUNGLE_CHEST = "pyramidJungleChest";
    public static final String PYRAMID_JUNGLE_DISPENSER = "pyramidJungleDispenser";
    public static final String STRONGHOLD_CORRIDOR = "strongholdCorridor";
    public static final String STRONGHOLD_LIBRARY = "strongholdLibrary";
    public static final String STRONGHOLD_CROSSING = "strongholdCrossing";
    public static final String VILLAGE_BLACKSMITH = "villageBlacksmith";
    public static final String BONUS_CHEST = "bonusChest";
    public static final String DUNGEON_CHEST = "dungeonChest";
    private static final HashMap<String, ChestGenHooks> chestInfo = new HashMap();
    private static boolean hasInit = false;
    private String category;
    private int countMin = 0;
    private int countMax = 0;
    ArrayList<mj> contents = new ArrayList();

    private static void init() {
        if (hasInit) {
            return;
        }
        hasInit = true;
        ChestGenHooks.addInfo(MINESHAFT_CORRIDOR, agg.a, 3, 7);
        ChestGenHooks.addInfo(PYRAMID_DESERT_CHEST, ahk.i, 2, 7);
        ChestGenHooks.addInfo(PYRAMID_JUNGLE_CHEST, ahl.l, 2, 7);
        ChestGenHooks.addInfo(PYRAMID_JUNGLE_DISPENSER, ahl.m, 2, 2);
        ChestGenHooks.addInfo(STRONGHOLD_CORRIDOR, ahv.a, 2, 4);
        ChestGenHooks.addInfo(STRONGHOLD_LIBRARY, ahz.b, 1, 5);
        ChestGenHooks.addInfo(STRONGHOLD_CROSSING, aie.c, 1, 5);
        ChestGenHooks.addInfo(VILLAGE_BLACKSMITH, ajf.a, 3, 9);
        ChestGenHooks.addInfo(BONUS_CHEST, jr.T, 10, 10);
        ChestGenHooks.addInfo(DUNGEON_CHEST, afo.a, 8, 8);
        yd book = new yd((yb)yb.bY, 1, 0);
        mj tmp = new mj(book, 1, 1, 1);
        ChestGenHooks.getInfo(MINESHAFT_CORRIDOR).addItem(tmp);
        ChestGenHooks.getInfo(PYRAMID_DESERT_CHEST).addItem(tmp);
        ChestGenHooks.getInfo(PYRAMID_JUNGLE_CHEST).addItem(tmp);
        ChestGenHooks.getInfo(STRONGHOLD_CORRIDOR).addItem(tmp);
        ChestGenHooks.getInfo(STRONGHOLD_LIBRARY).addItem(new mj(book, 1, 5, 2));
        ChestGenHooks.getInfo(STRONGHOLD_CROSSING).addItem(tmp);
        ChestGenHooks.getInfo(DUNGEON_CHEST).addItem(tmp);
    }

    static void addDungeonLoot(ChestGenHooks dungeon, yd item, int weight, int min, int max) {
        dungeon.addItem(new mj(item, min, max, weight));
    }

    private static void addInfo(String category, mj[] items, int min, int max) {
        chestInfo.put(category, new ChestGenHooks(category, items, min, max));
    }

    public static ChestGenHooks getInfo(String category) {
        if (!chestInfo.containsKey(category)) {
            chestInfo.put(category, new ChestGenHooks(category));
        }
        return chestInfo.get(category);
    }

    public static yd[] generateStacks(Random rand, yd source, int min, int max) {
        yd[] ret;
        int count = min + rand.nextInt(max - min + 1);
        if (source.b() == null) {
            ret = new yd[]{};
        } else if (count > source.b().m()) {
            ret = new yd[count];
            for (int x2 = 0; x2 < count; ++x2) {
                ret[x2] = source.m();
                ret[x2].b = 1;
            }
        } else {
            ret = new yd[]{source.m()};
            ret[0].b = count;
        }
        return ret;
    }

    public static mj[] getItems(String category, Random rnd) {
        return ChestGenHooks.getInfo(category).getItems(rnd);
    }

    public static int getCount(String category, Random rand) {
        return ChestGenHooks.getInfo(category).getCount(rand);
    }

    public static void addItem(String category, mj item) {
        ChestGenHooks.getInfo(category).addItem(item);
    }

    public static void removeItem(String category, yd item) {
        ChestGenHooks.getInfo(category).removeItem(item);
    }

    public static yd getOneItem(String category, Random rand) {
        return ChestGenHooks.getInfo(category).getOneItem(rand);
    }

    public ChestGenHooks(String category) {
        this.category = category;
    }

    public ChestGenHooks(String category, mj[] items, int min, int max) {
        this(category);
        for (mj item : items) {
            this.contents.add(item);
        }
        this.countMin = min;
        this.countMax = max;
    }

    public void addItem(mj item) {
        this.contents.add(item);
    }

    public void removeItem(yd item) {
        Iterator<mj> itr = this.contents.iterator();
        while (itr.hasNext()) {
            mj cont = itr.next();
            if (!item.a(cont.b) && (item.k() != Short.MAX_VALUE || item.d != cont.b.d)) continue;
            itr.remove();
        }
    }

    public mj[] getItems(Random rnd) {
        ArrayList<mj> ret = new ArrayList<mj>();
        for (mj orig : this.contents) {
            mj n;
            yb item = orig.b.b();
            if (item == null || (n = item.getChestGenBase(this, rnd, orig)) == null) continue;
            ret.add(n);
        }
        return ret.toArray(new mj[ret.size()]);
    }

    public int getCount(Random rand) {
        return this.countMin < this.countMax ? this.countMin + rand.nextInt(this.countMax - this.countMin) : this.countMin;
    }

    public yd getOneItem(Random rand) {
        mj[] items = this.getItems(rand);
        mj item = (mj)mh.a((Random)rand, (mi[])items);
        yd[] stacks = ChestGenHooks.generateStacks(rand, item.b, item.c, item.d);
        return stacks.length > 0 ? stacks[0] : null;
    }

    public int getMin() {
        return this.countMin;
    }

    public int getMax() {
        return this.countMax;
    }

    public void setMin(int value) {
        this.countMin = value;
    }

    public void setMax(int value) {
        this.countMax = value;
    }

    static {
        ChestGenHooks.init();
    }
}

