/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.Normalizer;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;
import net.minecraft.server.MinecraftServer;
import org.lwjgl.input.Keyboard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TMIUtils {
    public static final String COPYRIGHT = "All of TooManyItems except for thesmall portion excerpted from the original Minecraft game is copyright 2011Marglyph. TooManyItems is free for personal use only. Do not redistributeTooManyItems, including in mod packs, and do not use TooManyItems' sourcecode or graphics in your own mods.";
    public static final String CONFIG_FILENAME = "TooManyItems.txt";
    public static final String NBT_FILENAME = "TMI.nbt";
    public static final int SPAWNER_ID = 52;
    public static final int MODE_SURVIVAL = 0;
    public static final int MODE_CREATIVE = 1;
    public static final int MODE_ADVENTURE = 2;
    public static final List<String> EMPTY_NAME = new ArrayList<String>(){
        {
            this.add("");
        }
    };
    public static boolean haveReplacedItems = false;
    public static final Random random = new Random();
    private static Map<Integer, yb> originalItems = new HashMap<Integer, yb>();
    public static List<yd> availableItems = new ArrayList<yd>();

    public static File configFile() {
        return new File(ats.w().x, CONFIG_FILENAME);
    }

    public static File nbtFile() {
        return new File(ats.w().x, NBT_FILENAME);
    }

    public static void loadPreferences(TMIConfig tMIConfig) {
        try {
            Map<String, String> map = tMIConfig.getSettings();
            File file = TMIUtils.configFile();
            if (file.exists()) {
                String string;
                if (!TMIUtils.nbtFile().exists()) {
                    map.put("favorites", "");
                    for (int i = 0; i < 7; ++i) {
                        map.put("save" + (i + 1), "");
                    }
                }
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                while ((string = bufferedReader.readLine()) != null) {
                    String[] stringArray = string.split(":", 2);
                    if (stringArray.length <= 1 || !map.containsKey(stringArray[0])) continue;
                    map.put(stringArray[0], stringArray[1]);
                }
                bufferedReader.close();
                if (!TMIUtils.nbtFile().exists()) {
                    for (int i = 0; i < tMIConfig.getNumSaves(); ++i) {
                        if (!map.containsKey("save" + (i + 1))) continue;
                        tMIConfig.decodeState(i, map.get("save" + (i + 1)));
                    }
                    System.out.println("Loading old favorites");
                    tMIConfig.decodeFavorites();
                }
            }
            TMIUtils.loadNBTFile(tMIConfig);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void savePreferences(TMIConfig tMIConfig) {
        try {
            TMIUtils.saveNBTFile(tMIConfig);
            Map<String, String> map = tMIConfig.getSettings();
            File file = TMIUtils.configFile();
            PrintWriter printWriter = new PrintWriter(new FileWriter(file));
            for (String string : map.keySet()) {
                if (string.matches("favorites|save\\d")) continue;
                printWriter.println(string + ":" + map.get(string));
            }
            printWriter.close();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public static void saveNBTFile(TMIConfig tMIConfig) {
        try {
            bx bx2;
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(TMIUtils.nbtFile()));
            cf cf2 = new cf();
            cf cf3 = new cf();
            List<yd> list = tMIConfig.getFavorites();
            for (yd cf4 : list) {
                bx2 = new bx();
                if (cf4 != null) {
                    cf4.b(bx2);
                }
                cf3.a((ck)bx2);
            }
            cf2.a((ck)cf3);
            for (int i = 0; i < 7; ++i) {
                if (TMIConfig.statesSaved[i]) {
                    yd[] ydArray = tMIConfig.getState(i);
                    bx2 = new cf();
                    for (int j = 0; j < ydArray.length; ++j) {
                        bx bx3 = new bx();
                        if (ydArray[j] != null) {
                            ydArray[j].b(bx3);
                        }
                        bx2.a((ck)bx3);
                    }
                    cf2.a((ck)bx2);
                    continue;
                }
                cf cf4 = new cf();
                cf2.a((ck)cf4);
            }
            TMIPrivateFields.writeTagList.invoke((Object)cf2, dataOutputStream);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public static void loadNBTFile(TMIConfig tMIConfig) {
        try {
            yd[] ydArray;
            ck ck2;
            File file = TMIUtils.nbtFile();
            if (!file.exists()) {
                return;
            }
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
            cf cf2 = new cf();
            TMIPrivateFields.readTagList.invoke((Object)cf2, dataInputStream, 1);
            int n = 0;
            if (cf2.c() > 0) {
                cf cf3 = (cf)cf2.b(0);
                ck2 = tMIConfig.getFavorites();
                ck2.clear();
                for (int i = 0; i < cf3.c(); ++i) {
                    ydArray = (yd[])cf3.b(i);
                    yd yd2 = new yd(0, 1, 0);
                    yd2.c((bx)ydArray);
                    ck2.add(yd2);
                }
            }
            for (int i = 1; i < cf2.c(); ++i) {
                cf cf4;
                n = i - 1;
                ck2 = cf2.b(i);
                if (!(ck2 instanceof cf) || (cf4 = (cf)ck2).c() <= 0 || n >= 7) continue;
                ydArray = tMIConfig.getState(n);
                for (int j = 0; j < cf4.c(); ++j) {
                    ck ck3 = cf4.b(j);
                    if (!(ck3 instanceof bx)) continue;
                    bx bx2 = (bx)ck3;
                    if (bx2.b("id")) {
                        ydArray[j] = new yd(0, 1, 0);
                        ydArray[j].c(bx2);
                        continue;
                    }
                    ydArray[j] = null;
                }
                TMIConfig.statesSaved[n] = true;
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public static void loadItems(TMIConfig tMIConfig) {
        cf cf2;
        bx bx2;
        Object object;
        Serializable serializable;
        List<yd> list = availableItems;
        List<yb> list2 = tMIConfig.getEnchantableItems();
        boolean bl = TMIConfig.isMultiplayer();
        list.clear();
        list2.clear();
        try {
            serializable = Class.forName("com.eloraam.redpower.RedPowerBase");
            object = (aqw)((Class)serializable).getDeclaredField("blockMicro").get(null);
            Field field = aqw.class.getDeclaredField("cF");
            TMIItemInfo.setMaxDamageException(field.getInt(object), 32000);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        serializable = new ArrayList();
        block11: for (aqw aqw2 : yb.g) {
            String string;
            mr mr2;
            yd yd2;
            if (aqw2 == null) continue;
            if (aqw2.cv == TMIItemInfo.addItemOffset(127)) {
                if (!tMIConfig.areDamageVariantsShown()) continue;
                for (Object object2 : ns.a.keySet()) {
                    list.add(new yd(TMIItemInfo.addItemOffset(127), 64, ((Integer)object2).intValue()));
                }
                continue;
            }
            if (aqw2.cv == 52) {
                if (bl) {
                    list.add(new yd(52, 64, 0));
                    continue;
                }
                try {
                    bx2 = TMIPrivateFields.getSpawnerEntityIdSet().iterator();
                    while (bx2.hasNext()) {
                        int n = (Integer)bx2.next();
                        list.add(new yd(52, 64, n));
                    }
                    bx2 = TMIUtils.makeSingleSpawner(50, 64, "\u00a7r\u00a79Charged Creeper Spawner");
                    bx2.e.l("SpawnData").a("powered", true);
                    list.add((yd)bx2);
                    yd yd3 = TMIUtils.makeSingleSpawner(51, 64, "\u00a7r\u00a79Wither Skeleton Spawner");
                    yd3.e.l("SpawnData").a("SkeletonType", (ck)new bw("", 1));
                    cf2 = new cf();
                    yd yd4 = new yd(TMIItemInfo.addItemOffset(16), 1, 0);
                    bx bx3 = new bx();
                    yd4.b(bx3);
                    cf2.a((ck)bx3);
                    cf2.a((ck)new bx());
                    cf2.a((ck)new bx());
                    cf2.a((ck)new bx());
                    cf2.a((ck)new bx());
                    yd3.e.l("SpawnData").a("Equipment", (ck)cf2);
                    list.add(yd3);
                    yd2 = TMIUtils.makeSingleSpawner(90, 64, "\u00a7r\u00a79Saddled Pig Spawner");
                    yd2.e.l("SpawnData").a("Saddle", true);
                    list.add(yd2);
                    list.add(TMIUtils.makeRandomFireworkSpawner());
                    mr2 = TMIUtils.makeSingleSpawner(21, 64, "\u00a7r\u00a79TMI Wide-Area Torch Spawner");
                    TMIUtils.addLore((yd)mr2, "It's full of torches!");
                    mr2.e.l("SpawnData").a("Tile", (byte)50);
                    mr2.e.l("SpawnData").a("Time", (byte)2);
                    mr2.e.l("SpawnData").a("DropItem", false);
                    mr2.e.a("MinSpawnDelay", (short)15);
                    mr2.e.a("MaxSpawnDelay", (short)15);
                    mr2.e.a("SpawnCount", (short)10);
                    mr2.e.a("MaxNearbyEntities", (short)15);
                    mr2.e.a("RequiredPlayerRange", (short)16);
                    mr2.e.a("SpawnRange", (short)136);
                    string = TMIUtils.makeSingleSpawner(100, 64, "\u00a7r\u00a79Wild Horse Spawner");
                    ((yd)string).e.l("SpawnData").a("EatingHaystack", false);
                    ((yd)string).e.l("SpawnData").a("Bred", false);
                    ((yd)string).e.l("SpawnData").a("ChestedHorse", false);
                    ((yd)string).e.l("SpawnData").a("HasReproduced", false);
                    ((yd)string).e.l("SpawnData").a("Tame", false);
                    ((yd)string).e.l("SpawnData").a("CanPickUpLoot", false);
                    ((yd)string).e.l("SpawnData").a("PersistenceRequired", true);
                    ((yd)string).e.l("SpawnData").a("CustomNameVisible", false);
                    ((yd)string).e.l("SpawnData").a("Leashed", false);
                    ((yd)string).e.l("SpawnData").a("Type", 0);
                    ((yd)string).e.l("SpawnData").a("Variant", 0);
                    ((yd)string).e.l("SpawnData").a("Temper", 0);
                    ((yd)string).e.l("SpawnData").a("InLove", 0);
                    ((yd)string).e.l("SpawnData").a("Age", 6000);
                }
                catch (Exception exception) {
                    System.out.println(exception);
                    list.add(new yd(52, 64, 0));
                }
                continue;
            }
            if (TMIItemInfo.isHidden(aqw2.cv)) continue;
            if (aqw2.c() > 0) {
                list2.add((yb)aqw2);
            }
            if (aqw2.cv < aqw.s.length && aqw.s[aqw2.cv] != null) {
                serializable.clear();
                aqw.s[aqw2.cv].a(aqw2.cv, (wv)null, (List)((Object)serializable));
                if (serializable.size() > 1) {
                    bx2 = serializable.iterator();
                    while (bx2.hasNext()) {
                        yd yd5 = (yd)bx2.next();
                        yd5.b = yb.g[yd5.d].m();
                        list.add(yd5);
                    }
                    continue;
                }
            }
            bx2 = new HashSet();
            int n = tMIConfig.areDamageVariantsShown() ? 15 : 0;
            int n2 = TMIItemInfo.getMaxDamageException(aqw2.cv);
            if (n2 > n) {
                n = n2;
            }
            boolean bl2 = false;
            for (int i = 0; i <= n; ++i) {
                if (aqw2.cv == 43 && i > 0 || aqw2.cv == 44 && i > 5 || aqw2.cv == 59 && (i != 7 || bl) || aqw2.cv == 104 && (i != 7 || bl) || aqw2.cv == 105 && (i != 7 || bl) || aqw2.cv == 115 && (i != 3 || bl) || aqw2.cv == 78 && i > 0 && bl || aqw2.cv == 125 && i > 0 || aqw2.cv == 126 && i > 3) continue;
                yd2 = new yd((yb)aqw2, aqw2.m(), i);
                try {
                    mr2 = aqw2.h(yd2);
                    string = aqw2.d(yd2);
                    if (TMIUtils.itemDisplayName(yd2).equals("Unnamed")) {
                        if (i != 0) continue;
                        continue block11;
                    }
                    if (aqw2.cv < aqw.s.length && aqw.s[aqw2.cv] != null) {
                        try {
                            aqw.s[aqw2.cv].a(1, i);
                        }
                        catch (Exception exception) {
                            continue;
                        }
                    }
                    boolean bl3 = !bl && (aqw2.cv == 99 || aqw2.cv == 100) && i < 16;
                    String string2 = string + "@" + mr2.g();
                    if (bx2.contains(string2) && !TMIItemInfo.isShown(aqw2.cv, i) && !bl3) continue;
                    list.add(yd2);
                    bx2.add(string2);
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
        if (tMIConfig.areDamageVariantsShown()) {
            object = TMIItemInfo.potionValues.iterator();
            while (object.hasNext()) {
                int n = (Integer)object.next();
                yd yd6 = new yd(TMIItemInfo.addItemOffset(117), 64, n);
                list.add(yd6);
            }
        }
        if (tMIConfig.areDamageVariantsShown()) {
            if (!tMIConfig.isMultiplayer()) {
                aqw aqw2;
                object = new yd(TMIItemInfo.addItemOffset(117), 64, 1);
                ni ni2 = new ni(3, 0, 1);
                TMIUtils.addEffectToPotion((yd)object, ni2);
                list.add((yd)object);
                yd yd7 = new yd(TMIItemInfo.addItemOffset(117), 64, 16384);
                aqw2 = new ni(7, 0, 3);
                TMIUtils.addEffectToPotion(yd7, (ni)aqw2);
                list.add(yd7);
                list.add(TMIUtils.makeFirework("Creepy Sparkler", 2, 3, new int[]{4312372}, new int[]{15435844}, true, false));
                list.add(TMIUtils.makeFirework("Star", 4, 2, new int[]{6719955}, null, false, false));
                list.add(TMIUtils.makeFirework("Big Red", 1, 1, new int[]{11743532}, null, false, false));
                bx2 = TMIUtils.makeExplosionTag(1, new int[]{11743532, 0xF0F0F0, 2437522}, new int[]{0xF0F0F0}, true, true);
                yd yd8 = new yd(TMIItemInfo.addItemOffset(145), 64, 0);
                yd8.e = new bx();
                cf2 = TMIUtils.makeFireworksTag(2, bx2, bx2);
                yd8.e.a("Fireworks", (bx)cf2);
                TMIUtils.nameStack(yd8, "Old Glory");
                list.add(yd8);
            }
        }
        TMIUtils.filterItems(null, tMIConfig);
    }

    public static yd makeRandomFireworkSpawner() {
        yd yd2 = new yd(52, 1, 22);
        yd2.e = new bx();
        TMIUtils.nameStack(yd2, "\u00a7r\u00a79TMI Random Firework Spawner");
        TMIUtils.addLore(yd2, "Every one is different");
        yd2.e.a("MinSpawnDelay", (short)20);
        yd2.e.a("MaxSpawnDelay", (short)20);
        yd2.e.a("SpawnCount", (short)1);
        yd2.e.a("MaxNearbyEntities", (short)5);
        yd2.e.a("RequiredPlayerRange", (short)120);
        yd2.e.a("SpawnRange", (short)2);
        cf cf2 = new cf("SpawnPotentials");
        yd2.e.a("SpawnPotentials", (ck)cf2);
        for (int i = 0; i < 10; ++i) {
            bx bx2 = new bx("SpawnData");
            bx2.a("Type", "FireworksRocketEntity");
            bx2.a("Weight", 1);
            bx bx3 = new bx("Properties");
            bx2.a("Properties", bx3);
            bx bx4 = TMIUtils.makeRandomFirework().b(new bx());
            bx3.a("FireworksItem", bx4);
            bx3.a("LifeTime", random.nextInt(15) + random.nextInt(15) + 20);
            cf2.a((ck)bx2);
        }
        return yd2;
    }

    public static yd makeSingleSpawner(int n, int n2, String string) {
        String string2 = ns.b((int)n);
        yd yd2 = new yd(52, n2, n);
        yd2.e = new bx();
        bx bx2 = new bx("SpawnData");
        yd2.e.a("SpawnData", bx2);
        if (string != null) {
            TMIUtils.nameStack(yd2, string);
        }
        return yd2;
    }

    public static yd makeFirework(String string, int n, int n2, int[] nArray, int[] nArray2, boolean bl, boolean bl2) {
        yd yd2 = new yd(TMIItemInfo.addItemOffset(145), 64, 0);
        yd2.e = new bx();
        bx bx2 = TMIUtils.makeExplosionTag(n2, nArray, nArray2, bl, bl2);
        bx bx3 = TMIUtils.makeFireworksTag(n, bx2);
        yd2.e.a("Fireworks", bx3);
        if (string != null && !string.equals("")) {
            TMIUtils.nameStack(yd2, string);
        }
        return yd2;
    }

    public static bx makeExplosionTag(int n, int[] nArray, int[] nArray2, boolean bl, boolean bl2) {
        bx bx2 = new bx("Explosion");
        bx2.a("Flicker", bl);
        bx2.a("Trail", bl2);
        bx2.a("Type", (byte)(n & 0xF));
        if (nArray != null && nArray.length > 0) {
            bx2.a("Colors", nArray);
        }
        if (nArray2 != null && nArray2.length > 0) {
            bx2.a("FadeColors", nArray2);
        }
        return bx2;
    }

    public static yd makeRandomFirework() {
        int[] nArray = random.nextBoolean() ? new int[]{TMIUtils.randomBrightColor(), TMIUtils.randomBrightColor()} : new int[]{TMIUtils.randomBrightColor()};
        int[] nArray2 = random.nextBoolean() ? new int[]{TMIUtils.randomBrightColor()} : null;
        return TMIUtils.makeFirework("Random Firework", random.nextInt(3) + 1, random.nextInt(4), nArray, nArray2, random.nextBoolean(), random.nextBoolean());
    }

    public static int randomBrightColor() {
        return Color.HSBtoRGB(random.nextFloat(), random.nextFloat(), random.nextFloat() * 0.5f + 0.5f);
    }

    public static bx makeFireworksTag(int n, bx ... bxArray) {
        bx bx2 = new bx("Fireworks");
        bx2.a("Flight", (byte)(n & 0xF));
        cf cf2 = new cf();
        bx2.a("Explosions", (ck)cf2);
        for (bx bx3 : bxArray) {
            cf2.a((ck)bx3);
        }
        return bx2;
    }

    public static String deaccent(String string) {
        try {
            Class.forName("java.text.Normalizer");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return string;
        }
        String string2 = Normalizer.normalize(string, Normalizer.Form.NFD);
        Pattern pattern = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
        return pattern.matcher(string2).replaceAll("");
    }

    public static void filterItems(String string, TMIConfig tMIConfig) {
        List<yd> list = availableItems;
        List<yd> list2 = tMIConfig.getItems();
        list2.clear();
        if (string == null || string.equals("")) {
            for (yd yd2 : list) {
                list2.add(yd2);
            }
        } else {
            string = TMIUtils.deaccent(string.toLowerCase());
            for (yd yd3 : list) {
                String string2;
                if (yd3 == null || (string2 = TMIUtils.itemDisplayName(yd3)) == null || !TMIUtils.deaccent(string2.toLowerCase()).contains(string)) continue;
                list2.add(yd3);
            }
        }
    }

    public static void safeReportException(Exception exception) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(".yyyyMMdd.HHmmss");
            StringBuffer stringBuffer = new StringBuffer();
            simpleDateFormat.format(new Date(), stringBuffer, new FieldPosition(1));
            String string = "tmi" + stringBuffer.toString() + ".txt";
            File file = new File(ats.w().x, string);
            PrintWriter printWriter = new PrintWriter(new FileWriter(file));
            printWriter.print("[code]TMI Version: 1.6.2 2013-07-08\n");
            exception.printStackTrace(printWriter);
            printWriter.println("[/code]");
            printWriter.close();
        }
        catch (Exception exception2) {
            System.out.println("Error during safeReportException:");
            exception2.printStackTrace();
        }
    }

    public static List<String> itemDisplayNameMultiline(yd yd2, boolean bl) {
        return TMIUtils.itemDisplayNameMultiline(yd2, bl, false);
    }

    public static List<String> itemDisplayNameMultiline(yd yd2, boolean bl, boolean bl2) {
        Object object;
        if (yd2 == null) {
            return EMPTY_NAME;
        }
        if (bl2) {
            bl = false;
        }
        List<String> list = null;
        if (TMIUtils.isValidItem(yd2)) {
            try {
                object = yd2.a((ue)ats.w().h, bl2);
                list = object;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (list == null || list.size() == 0 || yd2.d == 52 && yd2.e == null) {
            list = new ArrayList<String>();
            list.add(TMIItemInfo.getFallbackName(yd2.d, yd2.j()));
            if (bl2) {
                bl = true;
            }
        }
        if (((String)(object = ((String)list.get(0)).trim())).length() == 0) {
            object = TMIItemInfo.getFallbackName(yd2.d, yd2.j());
            list.set(0, (String)object);
        }
        if (bl && yd2 != null) {
            object = (String)object + " " + yd2.d;
            if (yd2.j() != 0) {
                object = (String)object + " : " + yd2.j();
            }
            list.set(0, (String)object);
        }
        return list;
    }

    public static String itemDisplayName(yd yd2) {
        List<String> list = TMIUtils.itemDisplayNameMultiline(yd2, false);
        return list.get(0);
    }

    public static boolean isValidItem(yd yd2) {
        return yd2 == null || yd2.d >= 0 && yd2.d < yb.g.length && yb.g[yd2.d] != null;
    }

    public static yd getValidItem(yd yd2) {
        if (TMIUtils.isValidItem(yd2)) {
            return yd2;
        }
        return new yd(yb.g[52]);
    }

    public static String getValidItemDisplayName(yd yd2) {
        if (TMIUtils.isValidItem(yd2)) {
            return TMIUtils.itemDisplayName(yd2);
        }
        return "Undefined Item";
    }

    public static void setHeldItem(yd yd2) {
        TMIUtils.getPlayer().bn.b(yd2);
        ats.w().h.bn.b(yd2);
    }

    public static void deleteHeldItem() {
        TMIUtils.setHeldItem(null);
    }

    public static yd getHeldItem() {
        return ats.w().h.bn.o();
    }

    public static void giveStack(yd yd2, TMIConfig tMIConfig) {
        TMIUtils.giveStack(yd2, tMIConfig, yd2.b);
    }

    public static void giveStack(yd yd2, TMIConfig tMIConfig, int n) {
        yd yd3 = TMIUtils.copyStack(yd2, n);
        ats ats2 = ats.w();
        if (TMIConfig.isMultiplayer()) {
            NumberFormat numberFormat = NumberFormat.getIntegerInstance();
            numberFormat.setGroupingUsed(false);
            MessageFormat messageFormat = new MessageFormat(tMIConfig.getSettings().get("give-command"));
            messageFormat.setFormatByArgumentIndex(1, numberFormat);
            messageFormat.setFormatByArgumentIndex(2, numberFormat);
            messageFormat.setFormatByArgumentIndex(3, numberFormat);
            Object[] objectArray = new Object[]{ats2.h.bu, yd3.d, yd3.b, yd3.j()};
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(messageFormat.format(objectArray));
            for (int[] nArray : TMIUtils.getEnchantments(yd3)) {
                stringBuilder.append(" ");
                stringBuilder.append(nArray[0]);
                stringBuilder.append(":");
                stringBuilder.append(nArray[1]);
            }
            ats2.h.b(stringBuilder.toString());
        } else {
            TMIUtils.getPlayer().bn.a(yd3);
        }
    }

    public static yd copyStack(yd yd2, int n) {
        if (yd2 == null) {
            return null;
        }
        yd2.b += n;
        return yd2.a(n);
    }

    public static yd copyStack(yd yd2) {
        if (yd2 == null) {
            return null;
        }
        return TMIUtils.copyStack(yd2, yd2.b);
    }

    public static void updateUnlimitedItems() {
        try {
            if (TMIConfig.isMultiplayer() || !TMIConfig.getInstance().isEnabled()) {
                return;
            }
            for (yd yd2 : TMIUtils.getPlayer().bn.a) {
                bx bx2;
                if (yd2 == null) continue;
                if (yd2.e != null && yd2.e.b("TooManyItems") && (bx2 = yd2.e.l("TooManyItems")).b("Unlimited")) {
                    int n = TMIUtils.maxStackSize(yd2.d);
                    if (n == 1) {
                        n = 64;
                    }
                    yd2.b = n;
                }
                if (yd2.j() >= 0) continue;
                TMIUtils.setStackDamage(yd2, -32000);
            }
            yd yd3 = TMIUtils.getHeldItem();
            if (yd3 != null && yd3.b > 64) {
                yd3.b = -1;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static void setStackDamage(yd yd2, int n) {
        try {
            TMIPrivateFields.stackDamage.setInt(yd2, n);
        }
        catch (Exception exception) {
            System.out.println("[TMI] Error setting stack damage");
            exception.printStackTrace();
        }
    }

    public static void deleteInventory() {
        List list = TMIUtils.getPlayer().bp.c;
        for (int i = 0; i < list.size(); ++i) {
            wd wd2 = (wd)list.get(i);
            if (wd2 == null) continue;
            wd2.c((yd)null);
        }
    }

    public static void deleteItemsOfType(yd yd2, awv awv2) {
        List list = TMIUtils.getPlayer().bp.c;
        for (int i = 0; i < list.size(); ++i) {
            yd yd3;
            wd wd2 = (wd)list.get(i);
            if (wd2 == null || (yd3 = wd2.d()) == null || yd3.d != yd2.d || yd3.j() != yd2.j()) continue;
            wd2.c((yd)null);
        }
    }

    public static boolean shiftKey() {
        return Keyboard.isKeyDown((int)54) || Keyboard.isKeyDown((int)42);
    }

    public static int getGameMode() {
        try {
            return ((acd)TMIPrivateFields.gameMode.get(ats.w().c)).a();
        }
        catch (IllegalAccessException illegalAccessException) {
            System.out.println(illegalAccessException);
            return 0;
        }
    }

    public static void setGameMode(int n) {
        if (TMIConfig.isMultiplayer()) {
            ats.w().h.b("/gamemode " + n);
        } else {
            TMIUtils.getPlayer().a(acd.a((int)n));
        }
    }

    public static boolean isCreativeMode() {
        return ats.w().c.h();
    }

    public static void setCreativeMode(boolean bl) {
        if (TMIConfig.isMultiplayer()) {
            ats.w().h.b("/gamemode " + (bl ? "1" : "0"));
        } else {
            TMIUtils.getPlayer().a(bl ? acd.c : acd.b);
        }
    }

    public static boolean isCreativeSearchTab() {
        return false;
    }

    public static boolean isRaining() {
        return ats.w().f.x.p();
    }

    public static void setRaining(boolean bl) {
        if (TMIConfig.isMultiplayer()) {
            ats.w().h.b("/toggledownfall");
        } else {
            MinecraftServer.F().b[0].x.b(bl);
            MinecraftServer.F().b[0].x.g(bl ? 18000 : 180000);
        }
    }

    public static long getTime() {
        return ats.w().f.x.g();
    }

    public static void setTime(long l) {
        if (TMIConfig.isMultiplayer()) {
            ats.w().h.b("/time set " + l);
        } else {
            MinecraftServer.F().b[0].b(l);
        }
    }

    public static void setHourForward(int n) {
        long l = TMIUtils.getTime() / 24000L * 24000L;
        long l2 = l + 24000L + (long)(n * 1000);
        TMIUtils.setTime(l2);
    }

    public static void logWithTrace(String string) {
        System.out.println(string);
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            System.out.println(stackTraceElementArray[i].toString());
        }
    }

    public static void logWithTrace(String string, int n) {
        System.out.println(string);
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length && i < n; ++i) {
            System.out.println(stackTraceElementArray[i].toString());
        }
    }

    public static boolean playerIsAlive() {
        return !ats.w().h.M;
    }

    public static void setPlayerHealth(float f) {
        if (TMIUtils.playerIsAlive()) {
            TMIUtils.getPlayer().g(f);
        }
    }

    public static void fillHunger() {
        if (TMIUtils.playerIsAlive()) {
            TMIUtils.getPlayer().bq.a(20);
            TMIUtils.getPlayer().bq.b(5.0f);
        }
    }

    public static void incrementDifficulty() {
        ats.w().u.a(auk.l, 1);
    }

    public static String getDifficultyString() {
        return ats.w().u.c(auk.l);
    }

    public static void suppressAchievementNotice() {
        try {
            for (Field field : ats.w().q.getClass().getDeclaredFields()) {
                if (!field.getName().equals("_gui_achievement_time")) continue;
                field.setAccessible(true);
                field.setInt(ats.w().q, 0);
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public static int maxStackSize(int n) {
        return yb.g[n].m();
    }

    public static List<int[]> getEnchantments(yd yd2) {
        cf cf2;
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        if (yd2 != null && (cf2 = yd2.r()) != null) {
            for (int i = 0; i < cf2.c(); ++i) {
                short s = ((bx)cf2.b(i)).d("id");
                short s2 = ((bx)cf2.b(i)).d("lvl");
                int[] nArray = new int[]{s, s2};
                arrayList.add(nArray);
            }
        }
        return arrayList;
    }

    public static boolean addEnchantment(yd yd2, int n, int n2) {
        if (n < aat.b.length && aat.b[n] != null) {
            yd2.a(aat.b[n], n2);
            return true;
        }
        return false;
    }

    public static void addEffectToPotion(yd yd2, ni ni2) {
        cf cf2;
        if (yd2.d != TMIItemInfo.addItemOffset(117)) {
            return;
        }
        if (yd2.e == null) {
            yd2.e = new bx();
        }
        if (yd2.e.b("CustomPotionEffects")) {
            cf2 = yd2.e.m("CustomPotionEffects");
        } else {
            cf2 = new cf();
            yd2.e.a("CustomPotionEffects", (ck)cf2);
        }
        bx bx2 = new bx();
        ni2.a(bx2);
        cf2.a((ck)bx2);
    }

    public static void nameStack(yd yd2, String string) {
        if (string != null) {
            bx bx2;
            if (yd2.e == null) {
                yd2.e = new bx();
            }
            if (yd2.e.b("display")) {
                bx2 = yd2.e.l("display");
            } else {
                bx2 = new bx();
                yd2.e.a("display", bx2);
            }
            bx2.a("Name", string);
        }
    }

    public static void addLore(yd yd2, String string) {
        if (string != null) {
            cf cf2;
            bx bx2;
            if (yd2.e == null) {
                yd2.e = new bx();
            }
            if (yd2.e.b("display")) {
                bx2 = yd2.e.l("display");
            } else {
                bx2 = new bx();
                yd2.e.a("display", bx2);
            }
            if (bx2.b("Lore")) {
                cf2 = bx2.m("Lore");
            } else {
                cf2 = new cf();
                bx2.a("Lore", (ck)cf2);
            }
            cj cj2 = new cj("Lore", string);
            cf2.a((ck)cj2);
        }
    }

    public static bx getTagCompoundWithCreate(yd yd2, String string) {
        bx bx2;
        if (yd2.e == null) {
            yd2.e = new bx();
        }
        if (!yd2.e.b(string)) {
            bx2 = new bx();
            yd2.e.a(string, bx2);
        } else {
            bx2 = yd2.e.l(string);
        }
        return bx2;
    }

    public static ju getPlayer() {
        return MinecraftServer.F().af().f(ats.w().h.bu);
    }

    public static void fastTransfer(int n, int n2, ux ux2) {
        ats ats2 = ats.w();
        yd yd2 = TMIUtils.getHeldItem();
        ats2.c.a(ux2.d, n, n2, 0, (ue)ats2.h);
        int n3 = ux2.c.size() - 36;
        boolean bl = n < n3;
        int n4 = 0;
        int n5 = n3;
        int n6 = n3 - 1;
        int n7 = ux2.c.size();
        if (bl) {
            n4 = n3;
            n5 = ux2.c.size();
            n6 = -1;
            n7 = n3;
        }
        boolean bl2 = true;
        while (n4 < n5 && n6 < n7) {
            yd yd3;
            wd wd2 = (wd)ux2.c.get(n4);
            if (wd2 != null && (yd3 = wd2.d()) != null && yd3.d == yd2.d && yd3.j() == yd2.j()) {
                wd wd3 = bl2 ? (wd)ux2.c.get(n) : (wd)ux2.c.get(n6);
                if (wd3 == null) {
                    ++n6;
                    bl2 = false;
                    continue;
                }
                yd yd4 = wd3.d();
                if (yd4 == null) {
                    wd3.c(yd3);
                    wd2.c((yd)null);
                } else if (yd4.d == yd3.d && yd4.j() == yd3.j()) {
                    int n8 = yd3.b + yd4.b;
                    int n9 = yb.g[yd3.d].m();
                    int n10 = n8 - n9;
                    if (n10 > 0) {
                        yd4.b = n9;
                        yd3.b = n10;
                        ++n6;
                        bl2 = false;
                        continue;
                    }
                    yd4.b = n8;
                    wd2.c((yd)null);
                } else {
                    ++n6;
                    bl2 = false;
                    continue;
                }
            }
            ++n4;
        }
    }

    public static boolean isEnchantmentNormallyPossible(aat aat2, yb yb2) {
        return aat2.A.a(yb2) || yb2.cv == TMIItemInfo.addItemOffset(147);
    }

    public static boolean isEnchantmentNormallyPossible(aat aat2, yd yd2) {
        return aat2.A.a(yb.g[yd2.d]) || yd2.d == TMIItemInfo.addItemOffset(147);
    }

    public static List<aat> getPossibleEnchantments(yb yb2) {
        if (yb2.c() > 0) {
            ArrayList<aat> arrayList = new ArrayList<aat>();
            for (aat aat2 : aat.b) {
                if (aat2 == null || !aat2.A.a(yb2)) continue;
                arrayList.add(aat2);
            }
            return arrayList;
        }
        return new ArrayList<aat>();
    }

    public static void replaceCustomItems() {
        block6: {
            block5: {
                if (haveReplacedItems) break block5;
                TMIConfig.getInstance();
                if (!TMIConfig.isMultiplayer() && TMIConfig.getInstance().getBooleanSetting("replace-items")) break block6;
            }
            return;
        }
        try {
            Class<?> clazz = Class.forName("cpw.mods.fml.common.registry.GameData");
            System.out.println("[TMI] Please ignore Forge item allocation errors. The items are fine.");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        TMIUtils.modMushroomBlock(true);
        TMIUtils.modMobSpawner(true);
        TMIUtils.modCrops(true);
        TMIUtils.modSnowCover(true);
        haveReplacedItems = true;
    }

    public static void dumpItemList() {
        try {
            File file = new File(ats.w().x, "TMIItemList.txt");
            PrintWriter printWriter = new PrintWriter(new FileWriter(file));
            for (yd yd2 : TMIConfig.getInstance().getItems()) {
                printWriter.println("" + yd2.d + ":" + yd2.j() + " " + TMIUtils.getValidItemDisplayName(yd2));
            }
            printWriter.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    public static yb unsetItem(int n) {
        yb yb2 = yb.g[n];
        yb.g[n] = null;
        try {
            Class<?> clazz = Class.forName("cpw.mods.fml.common.registry.GameData");
            Field field = clazz.getDeclaredField("idMap");
            TMIPrivateFields.unsetFinalPrivate(field);
            Map map = (Map)field.get(null);
            if (map.containsKey(n)) {
                map.remove(n);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return yb2;
    }

    public static void unsetAndSaveItem(int n) {
        originalItems.put(n, TMIUtils.unsetItem(n));
    }

    public static void modMobSpawner(boolean bl) {
        TMIUtils.unsetAndSaveItem(52);
        yb.g[52] = new TMIItemSpawner(52 - TMIItemInfo.itemOffset).b("mobSpawner");
    }

    public static void modMushroomBlock(boolean bl) {
        TMIUtils.unsetAndSaveItem(99);
        TMIUtils.unsetAndSaveItem(100);
        yb.g[99] = new TMIItemMushroomCap(99 - TMIItemInfo.itemOffset).b("mushroom");
        yb.g[100] = new TMIItemMushroomCap(100 - TMIItemInfo.itemOffset).b("mushroom");
    }

    public static void modCrops(boolean bl) {
        TMIUtils.unsetAndSaveItem(59);
        TMIUtils.unsetAndSaveItem(104);
        TMIUtils.unsetAndSaveItem(105);
        TMIUtils.unsetAndSaveItem(115);
        yb.g[59] = new TMIItemCrop(59 - TMIItemInfo.itemOffset).b("crops");
        yb.g[104] = new TMIItemCrop(104 - TMIItemInfo.itemOffset).b("pumpkinStem");
        yb.g[105] = new TMIItemCrop(105 - TMIItemInfo.itemOffset).b("melonStem");
        yb.g[115] = new TMIItemCrop(115 - TMIItemInfo.itemOffset).b("netherStalk");
    }

    public static void modSnowCover(boolean bl) {
    }

    public static void resetItems() {
        for (int n : originalItems.keySet()) {
            TMIUtils.unsetItem(n);
            yb.g[n] = originalItems.get(n);
        }
        originalItems.clear();
        haveReplacedItems = false;
    }
}

