/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.registry;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class VillagerRegistry {
    private static final VillagerRegistry INSTANCE = new VillagerRegistry();
    private Multimap<Integer, IVillageTradeHandler> tradeHandlers = ArrayListMultimap.create();
    private Map<Class<?>, IVillageCreationHandler> villageCreationHandlers = Maps.newHashMap();
    private List<Integer> newVillagerIds = Lists.newArrayList();
    @SideOnly(value=Side.CLIENT)
    private Map<Integer, bjl> newVillagers;

    public static VillagerRegistry instance() {
        return INSTANCE;
    }

    public void registerVillagerId(int id) {
        if (this.newVillagerIds.contains(id)) {
            FMLLog.severe("Attempt to register duplicate villager id %d", id);
            throw new RuntimeException();
        }
        this.newVillagerIds.add(id);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerVillagerSkin(int villagerId, bjl villagerSkin) {
        if (this.newVillagers == null) {
            this.newVillagers = Maps.newHashMap();
        }
        this.newVillagers.put(villagerId, villagerSkin);
    }

    public void registerVillageCreationHandler(IVillageCreationHandler handler) {
        this.villageCreationHandlers.put(handler.getComponentClass(), handler);
    }

    public void registerVillageTradeHandler(int villagerId, IVillageTradeHandler handler) {
        this.tradeHandlers.put((Object)villagerId, (Object)handler);
    }

    @SideOnly(value=Side.CLIENT)
    public static bjl getVillagerSkin(int villagerType, bjl defaultSkin) {
        if (VillagerRegistry.instance().newVillagers.containsKey(villagerType)) {
            return VillagerRegistry.instance().newVillagers.get(villagerType);
        }
        return defaultSkin;
    }

    public static Collection<Integer> getRegisteredVillagers() {
        return Collections.unmodifiableCollection(VillagerRegistry.instance().newVillagerIds);
    }

    public static void manageVillagerTrades(abl recipeList, ua villager, int villagerType, Random random) {
        for (IVillageTradeHandler handler : VillagerRegistry.instance().tradeHandlers.get((Object)villagerType)) {
            handler.manipulateTradesForVillager(villager, recipeList, random);
        }
    }

    public static void addExtraVillageComponents(ArrayList components, Random random, int i) {
        ArrayList parts = components;
        for (IVillageCreationHandler handler : VillagerRegistry.instance().villageCreationHandlers.values()) {
            parts.add(handler.getVillagePieceWeight(random, i));
        }
    }

    public static Object getVillageComponent(aja villagePiece, ajg startPiece, List pieces, Random random, int p1, int p2, int p3, int p4, int p5) {
        return VillagerRegistry.instance().villageCreationHandlers.get(villagePiece.a).buildComponent(villagePiece, startPiece, pieces, random, p1, p2, p3, p4, p5);
    }

    public static void addEmeraldBuyRecipe(ua villager, abl list, Random random, yb item, float chance, int min, int max) {
        if (min > 0 && max > 0) {
            ua.bB.put(item.cv, new mg((Object)min, (Object)max));
        }
        ua.a((abl)list, (int)item.o(), (Random)random, (float)chance);
    }

    public static void addEmeraldSellRecipe(ua villager, abl list, Random random, yb item, float chance, int min, int max) {
        if (min > 0 && max > 0) {
            ua.bC.put(item.cv, new mg((Object)min, (Object)max));
        }
        ua.b((abl)list, (int)item.o(), (Random)random, (float)chance);
    }

    public static void applyRandomTrade(ua villager, Random rand) {
        int extra = VillagerRegistry.instance().newVillagerIds.size();
        int trade = rand.nextInt(5 + extra);
        villager.p(trade < 5 ? trade : VillagerRegistry.instance().newVillagerIds.get(trade - 5));
    }

    public static interface IVillageTradeHandler {
        public void manipulateTradesForVillager(ua var1, abl var2, Random var3);
    }

    public static interface IVillageCreationHandler {
        public aja getVillagePieceWeight(Random var1, int var2);

        public Class<?> getComponentClass();

        public Object buildComponent(aja var1, ajg var2, List var3, Random var4, int var5, int var6, int var7, int var8, int var9);
    }
}

