/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event;

import java.util.List;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.entity.living.LivingPackSizeEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;

public class ForgeEventFactory {
    public static boolean doPlayerHarvestCheck(ue player, aqw block, boolean success) {
        PlayerEvent.HarvestCheck event = new PlayerEvent.HarvestCheck(player, block, success);
        MinecraftForge.EVENT_BUS.post(event);
        return event.success;
    }

    public static float getBreakSpeed(ue player, aqw block, int metadata, float original) {
        PlayerEvent.BreakSpeed event = new PlayerEvent.BreakSpeed(player, block, metadata, original);
        return MinecraftForge.EVENT_BUS.post(event) ? -1.0f : event.newSpeed;
    }

    public static PlayerInteractEvent onPlayerInteract(ue player, PlayerInteractEvent.Action action, int x2, int y, int z, int face) {
        PlayerInteractEvent event = new PlayerInteractEvent(player, action, x2, y, z, face);
        MinecraftForge.EVENT_BUS.post(event);
        return event;
    }

    public static void onPlayerDestroyItem(ue player, yd stack) {
        MinecraftForge.EVENT_BUS.post(new PlayerDestroyItemEvent(player, stack));
    }

    public static Event.Result canEntitySpawn(of entity, abv world, float x2, float y, float z) {
        LivingSpawnEvent.CheckSpawn event = new LivingSpawnEvent.CheckSpawn(entity, world, x2, y, z);
        MinecraftForge.EVENT_BUS.post(event);
        return event.getResult();
    }

    public static boolean doSpecialSpawn(of entity, abv world, float x2, float y, float z) {
        return MinecraftForge.EVENT_BUS.post(new LivingSpawnEvent.SpecialSpawn(entity, world, x2, y, z));
    }

    public static List getPotentialSpawns(jr world, og type, int x2, int y, int z, List oldList) {
        WorldEvent.PotentialSpawns event = new WorldEvent.PotentialSpawns((abv)world, type, x2, y, z, oldList);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return null;
        }
        return event.list;
    }

    public static int getMaxSpawnPackSize(of entity) {
        LivingPackSizeEvent maxCanSpawnEvent = new LivingPackSizeEvent(entity);
        MinecraftForge.EVENT_BUS.post(maxCanSpawnEvent);
        return maxCanSpawnEvent.getResult() == Event.Result.ALLOW ? maxCanSpawnEvent.maxPackSize : entity.bv();
    }
}

