/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import org.lwjgl.input.Keyboard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TMIConfig {
    public static final String COPYRIGHT = "All of TooManyItems except for thesmall portion excerpted from the original Minecraft game is copyright 2011Marglyph. TooManyItems is free for personal use only. Do not redistributeTooManyItems, including in mod packs, and do not use TooManyItems' sourcecode or graphics in your own mods.";
    public static final String VERSION = "1.5.2 2013-04-25";
    public static final int NUM_SAVES = 7;
    public static final int INVENTORY_SIZE = 44;
    public static boolean isModloaderEnabled;
    private static TMIConfig instance;
    private static List<wm> items;
    private static List<wk> enchantableItems;
    private static List<wm> favorites;
    private static HashSet<Integer> toolIds;
    private static HashSet<Integer> nonUnlimitedIds;
    private Map<String, String> settings = new LinkedHashMap<String, String>();
    private static wm[][] states;
    public static boolean[] statesSaved;

    public TMIConfig() {
        this.settings.put("enable", "true");
        this.settings.put("enablemp", "true");
        this.settings.put("itemsonly", "false");
        this.settings.put("give-command", "/give {0} {1} {2} {3}");
        this.settings.put("key", "o");
        for (int i2 = 0; i2 < this.getNumSaves(); ++i2) {
            this.settings.put("save-name" + (i2 + 1), "" + (i2 + 1));
        }
        this.settings.put("replace-items", "true");
        instance = this;
    }

    public static boolean isMultiplayer() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        Thread[] threadArray = new Thread[threadGroup.activeCount()];
        threadGroup.enumerate(threadArray);
        for (int i2 = 0; i2 < threadArray.length; ++i2) {
            String string;
            if (threadArray[i2] == null || (string = threadArray[i2].getName()) == null || !string.equals("Client read thread")) continue;
            return true;
        }
        return false;
    }

    public static TMIConfig getInstance() {
        if (instance == null) {
            new TMIConfig();
        }
        return instance;
    }

    public Map<String, String> getSettings() {
        return this.settings;
    }

    public List<wm> getItems() {
        return items;
    }

    public List<wk> getEnchantableItems() {
        return enchantableItems;
    }

    public int getHotkey() {
        String string = this.settings.get("key");
        int n2 = 0;
        n2 = Keyboard.getKeyIndex((String)string.toUpperCase());
        if (n2 == 0) {
            n2 = 24;
        }
        return n2;
    }

    public int getNumSaves() {
        return 7;
    }

    public boolean isStateSaved(int n2) {
        return statesSaved[n2];
    }

    public wm[] getState(int n2) {
        return states[n2];
    }

    public boolean getBooleanSetting(String string) {
        return Boolean.parseBoolean(this.settings.get(string));
    }

    public boolean isEnabled() {
        return TMIConfig.isMultiplayer() && this.getBooleanSetting("enablemp") || !TMIConfig.isMultiplayer() && this.getBooleanSetting("enable");
    }

    public void toggleEnabled() {
        String string = TMIConfig.isMultiplayer() ? "enablemp" : "enable";
        this.settings.put(string, Boolean.toString(!this.getBooleanSetting(string)));
    }

    public void setEnabled(boolean bl2) {
        String string = TMIConfig.isMultiplayer() ? "enablemp" : "enable";
        this.settings.put(string, Boolean.toString(bl2));
    }

    public static boolean isTool(wk wk2) {
        return toolIds.contains(wk2.cp);
    }

    public static boolean canItemBeUnlimited(wk wk2) {
        return !nonUnlimitedIds.contains(wk2.cp);
    }

    public boolean areDamageVariantsShown() {
        if (TMIConfig.isMultiplayer()) {
            String string = this.getSettings().get("give-command");
            return string.contains("{3}");
        }
        return true;
    }

    public void clearState(int n2) {
        for (int i2 = 0; i2 < 44; ++i2) {
            TMIConfig.states[n2][i2] = null;
            TMIConfig.statesSaved[n2] = false;
        }
        this.settings.put("save" + (n2 + 1), "");
    }

    public void loadState(int n2) {
        int n3;
        if (!statesSaved[n2]) {
            return;
        }
        try {
            if (Minecraft.x().s instanceof ayy) {
                TMIPrivateFields.setCreativeTab.invoke((Object)((ayy)Minecraft.x().s), ve.m);
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        wm[] wmArray = TMIUtils.getPlayer().bK.a;
        wm[] wmArray2 = TMIUtils.getPlayer().bK.b;
        for (n3 = 0; n3 < 4; ++n3) {
            wmArray2[n3] = TMIUtils.copyStack(states[n2][n3 + 4]);
        }
        for (n3 = 0; n3 < 27; ++n3) {
            wmArray[n3 + 9] = TMIUtils.copyStack(states[n2][n3 + 8]);
        }
        for (n3 = 0; n3 < 9; ++n3) {
            wmArray[n3] = TMIUtils.copyStack(states[n2][n3 + 8 + 27]);
        }
    }

    public void saveState(int n2) {
        int n3;
        wm[] wmArray = TMIUtils.getPlayer().bK.a;
        wm[] wmArray2 = TMIUtils.getPlayer().bK.b;
        for (n3 = 0; n3 < 4; ++n3) {
            TMIConfig.states[n2][n3 + 4] = TMIUtils.copyStack(wmArray2[n3]);
        }
        for (n3 = 0; n3 < 27; ++n3) {
            TMIConfig.states[n2][n3 + 8] = TMIUtils.copyStack(wmArray[n3 + 9]);
        }
        for (n3 = 0; n3 < 9; ++n3) {
            TMIConfig.states[n2][n3 + 8 + 27] = TMIUtils.copyStack(wmArray[n3]);
        }
        this.settings.put("save" + (n2 + 1), this.encodeState(n2));
        TMIConfig.statesSaved[n2] = true;
    }

    public String encodeState(int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < 44; ++i2) {
            if (states[n2][i2] != null) {
                stringBuilder.append(TMIConfig.states[n2][i2].c);
                stringBuilder.append(":");
                stringBuilder.append(TMIConfig.states[n2][i2].a);
                stringBuilder.append(":");
                stringBuilder.append(states[n2][i2].j());
                List<int[]> list = TMIUtils.getEnchantments(states[n2][i2]);
                for (int[] nArray : list) {
                    int n3 = nArray[0];
                    int n4 = nArray[1];
                    stringBuilder.append(":" + n3 + ":" + n4);
                }
            }
            stringBuilder.append(",");
        }
        return stringBuilder.toString();
    }

    public void decodeState(int n2, String string) {
        if (string.trim().equals("")) {
            TMIConfig.statesSaved[n2] = false;
        } else {
            String[] stringArray = string.split(",", 0);
            for (int i2 = 0; i2 < stringArray.length && i2 < states[n2].length; ++i2) {
                String[] stringArray2 = stringArray[i2].split(":");
                if (stringArray2.length < 3) continue;
                try {
                    TMIConfig.states[n2][i2] = new wm(Integer.parseInt(stringArray2[0]), Integer.parseInt(stringArray2[1]), Integer.parseInt(stringArray2[2]));
                    for (int i3 = 3; i3 < stringArray2.length - 1; i3 += 2) {
                        int n3 = Integer.parseInt(stringArray2[i3]);
                        int n4 = Integer.parseInt(stringArray2[i3 + 1]);
                        TMIUtils.addEnchantment(states[n2][i2], n3, n4);
                    }
                    continue;
                }
                catch (Exception exception) {
                    System.out.println(exception);
                }
            }
            TMIConfig.statesSaved[n2] = true;
        }
    }

    public List<wm> getFavorites() {
        return favorites;
    }

    public void decodeFavorites() {
        String[] stringArray;
        favorites.clear();
        for (String string : stringArray = this.settings.get("favorites").trim().split(",", 0)) {
            String[] stringArray2 = string.split(":");
            if (stringArray2.length < 2) continue;
            try {
                int n2 = Integer.parseInt(stringArray2[0]);
                int n3 = Integer.parseInt(stringArray2[1]);
                wm wm2 = new wm(n2, TMIUtils.maxStackSize(n2), n3);
                for (int i2 = 2; i2 < stringArray2.length - 1; i2 += 2) {
                    int n4 = Integer.parseInt(stringArray2[i2]);
                    int n5 = Integer.parseInt(stringArray2[i2 + 1]);
                    TMIUtils.addEnchantment(wm2, n4, n5);
                }
                favorites.add(wm2);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
    }

    public void encodeFavorites() {
        StringBuilder stringBuilder = new StringBuilder();
        for (wm wm2 : favorites) {
            stringBuilder.append(wm2.c);
            stringBuilder.append(":");
            stringBuilder.append(wm2.j());
            List<int[]> list = TMIUtils.getEnchantments(wm2);
            for (int[] nArray : list) {
                int n2 = nArray[0];
                int n3 = nArray[1];
                stringBuilder.append(":" + n2 + ":" + n3);
            }
            stringBuilder.append(",");
        }
        this.settings.put("favorites", stringBuilder.toString());
    }

    public static boolean canDelete() {
        return !TMIConfig.isMultiplayer();
    }

    public static boolean canChangeWeather() {
        return !TMIConfig.getInstance().getBooleanSetting("itemsonly");
    }

    public static boolean canChangeCreativeMode() {
        return !TMIConfig.getInstance().getBooleanSetting("itemsonly");
    }

    public static boolean canChangeTime() {
        return !TMIConfig.getInstance().getBooleanSetting("itemsonly");
    }

    public static boolean canChangeHealth() {
        return !TMIConfig.isMultiplayer() && !TMIConfig.getInstance().getBooleanSetting("itemsonly");
    }

    public static boolean canRestoreSaves() {
        return !TMIConfig.isMultiplayer();
    }

    public static boolean canChangeDifficulty() {
        return !TMIConfig.isMultiplayer();
    }

    static {
        int n2;
        isModloaderEnabled = false;
        items = new ArrayList<wm>();
        enchantableItems = new ArrayList<wk>();
        favorites = new ArrayList<wm>();
        toolIds = new HashSet();
        for (n2 = 0; n2 <= 3; ++n2) {
            toolIds.add(TMIItemInfo.addItemOffset(n2));
        }
        for (n2 = 11; n2 <= 23; ++n2) {
            toolIds.add(TMIItemInfo.addItemOffset(n2));
        }
        for (n2 = 27; n2 <= 30; ++n2) {
            toolIds.add(TMIItemInfo.addItemOffset(n2));
        }
        for (n2 = 34; n2 <= 38; ++n2) {
            toolIds.add(TMIItemInfo.addItemOffset(n2));
        }
        for (n2 = 42; n2 <= 61; ++n2) {
            toolIds.add(TMIItemInfo.addItemOffset(n2));
        }
        toolIds.add(TMIItemInfo.addItemOffset(103));
        toolIds.add(TMIItemInfo.addItemOffset(90));
        toolIds.add(TMIItemInfo.addItemOffset(5));
        nonUnlimitedIds = new HashSet();
        nonUnlimitedIds.add(TMIItemInfo.addItemOffset(102));
        states = new wm[7][44];
        statesSaved = new boolean[7];
    }
}

